/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.functions.common.model.functions.base;

import gr.cite.geoanalytics.functions.common.model.functions.LayerConfig;
import gr.cite.geoanalytics.functions.common.model.functions.base.FunctionLayerConfigBaseI;
import java.util.HashSet;
import java.util.Set;

public class FunctionLayerConfigBase
implements FunctionLayerConfigBaseI {
    private final int initializationSetSize;
    private Set<LayerConfig> layerConfigs = new HashSet<LayerConfig>();

    protected FunctionLayerConfigBase(Set<LayerConfig> layerConfigs) {
        this.initializationSetSize = layerConfigs.size();
        this.layerConfigs = layerConfigs;
    }

    @Override
    public Set<LayerConfig> getLayerConfigs() {
        return this.layerConfigs;
    }

    @Override
    public LayerConfig getLayerConfigByObjectID(String objID) {
        return this.layerConfigs.stream().filter(lc -> objID.equals(lc.getObjectID())).findFirst().get();
    }

    @Override
    public boolean isValidForSubmission() {
        if (this.layerConfigs.size() != this.initializationSetSize) {
            return false;
        }
        for (LayerConfig lc : this.layerConfigs) {
            if (lc.getLayerID() == null || lc.getLayerID().isEmpty()) {
                return false;
            }
            if (lc.getCaptionForUser() != null && !lc.getCaptionForUser().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

