/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarGenerator;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.lib.tar.TarReader;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;
    File[] componentFiles;
    InputStreamInterface[] componentStreams;
    boolean[] existList;
    boolean[] ignoreList;

    public static void main(String[] stringArray) throws IOException, TarMalformatException {
        block13: {
            try {
                if (stringArray.length < 1) {
                    System.out.println(RB.DbBackup_syntax.getString(DbBackup.class.getName()));
                    System.out.println();
                    System.out.println(RB.listing_format.getString());
                    System.exit(0);
                }
                if (stringArray[0].equals("--save")) {
                    boolean bl = stringArray.length > 1 && stringArray[1].equals("--overwrite");
                    if (stringArray.length != (bl ? 4 : 3)) {
                        throw new IllegalArgumentException();
                    }
                    DbBackup dbBackup = new DbBackup(new File(stringArray[stringArray.length - 2]), stringArray[stringArray.length - 1]);
                    dbBackup.setOverWrite(bl);
                    dbBackup.write();
                    break block13;
                }
                if (stringArray[0].equals("--list")) {
                    if (stringArray.length < 2) {
                        throw new IllegalArgumentException();
                    }
                    String[] stringArray2 = null;
                    if (stringArray.length > 2) {
                        stringArray2 = new String[stringArray.length - 2];
                        for (int i = 2; i < stringArray.length; ++i) {
                            stringArray2[i - 2] = stringArray[i];
                        }
                    }
                    new TarReader(new File(stringArray[1]), 0, stringArray2, new Integer(DbBackup.generateBufferBlockValue(new File(stringArray[1]))), null).read();
                    break block13;
                }
                if (stringArray[0].equals("--extract")) {
                    int n;
                    boolean bl = stringArray.length > 1 && stringArray[1].equals("--overwrite");
                    int n2 = n = bl ? 4 : 3;
                    if (stringArray.length < n) {
                        throw new IllegalArgumentException();
                    }
                    String[] stringArray3 = null;
                    if (stringArray.length > n) {
                        stringArray3 = new String[stringArray.length - n];
                        for (int i = n; i < stringArray.length; ++i) {
                            stringArray3[i - n] = stringArray[i];
                        }
                    }
                    File file = new File(stringArray[bl ? 2 : 1]);
                    int n3 = bl ? 2 : 1;
                    new TarReader(file, n3, stringArray3, new Integer(DbBackup.generateBufferBlockValue(file)), new File(stringArray[n - 1])).read();
                    break block13;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(RB.DbBackup_syntaxerr.getString(DbBackup.class.getName()));
                System.exit(2);
            }
        }
    }

    public DbBackup(File file, String string) {
        this.archiveFile = file;
        File file2 = new File(string);
        this.dbDir = file2.getAbsoluteFile().getParentFile();
        this.instanceName = file2.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".properties"), new File(this.dbDir, this.instanceName + ".script"), new File(this.dbDir, this.instanceName + ".data"), new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".lobs")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
    }

    public DbBackup(File file, String string, boolean bl) {
        this.archiveFile = file;
        File file2 = new File(string);
        this.dbDir = file2.getAbsoluteFile().getParentFile();
        this.instanceName = file2.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".script")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
        this.abortUponModify = false;
    }

    public void setStream(String string, InputStreamInterface inputStreamInterface) {
        for (int i = 0; i < this.componentFiles.length; ++i) {
            if (!this.componentFiles[i].getName().endsWith(string)) continue;
            this.componentStreams[i] = inputStreamInterface;
            break;
        }
    }

    public void setFileIgnore(String string) {
        for (int i = 0; i < this.componentFiles.length; ++i) {
            if (!this.componentFiles[i].getName().endsWith(string)) continue;
            this.ignoreList[i] = true;
            break;
        }
    }

    public void setOverWrite(boolean bl) {
        this.overWrite = bl;
    }

    public void setAbortUponModify(boolean bl) {
        this.abortUponModify = bl;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    public void write() throws IOException, TarMalformatException {
        long l = new Date().getTime();
        this.checkEssentialFiles();
        TarGenerator tarGenerator = new TarGenerator(this.archiveFile, this.overWrite, new Integer(DbBackup.generateBufferBlockValue(this.componentFiles)));
        for (int i = 0; i < this.componentFiles.length; ++i) {
            boolean bl;
            boolean bl2 = bl = this.componentStreams[i] != null || this.componentFiles[i].exists();
            if (!bl || this.ignoreList[i]) continue;
            if (this.componentStreams[i] == null) {
                tarGenerator.queueEntry(this.componentFiles[i].getName(), this.componentFiles[i]);
                this.existList[i] = true;
                continue;
            }
            tarGenerator.queueEntry(this.componentFiles[i].getName(), this.componentStreams[i]);
        }
        tarGenerator.write();
        this.checkFilesNotChanged(l);
    }

    public void writeAsFiles() throws IOException {
        int n = 512 * DbBackup.generateBufferBlockValue(this.componentFiles);
        byte[] byArray = new byte[n];
        this.checkEssentialFiles();
        for (int i = 0; i < this.componentFiles.length; ++i) {
            int n2;
            if (this.ignoreList[i] || !this.componentFiles[i].exists()) continue;
            File file = new File(this.archiveFile, this.componentFiles[i].getName());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (this.componentStreams[i] == null) {
                this.componentStreams[i] = new InputStreamWrapper(new FileInputStream(this.componentFiles[i]));
            }
            InputStreamInterface inputStreamInterface = this.componentStreams[i];
            while ((n2 = inputStreamInterface.read(byArray, 0, byArray.length)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStreamInterface.close();
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkEssentialFiles() throws FileNotFoundException, IllegalStateException {
        Object object;
        if (!this.componentFiles[0].getName().endsWith(".properties")) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            boolean bl;
            boolean bl2 = bl = this.componentStreams[i] != null || this.componentFiles[i].exists();
            if (bl) continue;
            throw new FileNotFoundException(RB.file_missing.getString(this.componentFiles[i].getAbsolutePath()));
        }
        if (!this.abortUponModify) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            object = this.componentFiles[0];
            fileInputStream = new FileInputStream((File)object);
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException2) {
            }
            finally {
                fileInputStream = null;
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                fileInputStream = null;
            }
        }
        object = properties.getProperty("modified");
        if (object != null && (((String)object).equalsIgnoreCase("yes") || ((String)object).equalsIgnoreCase("true"))) {
            throw new IllegalStateException(RB.modified_property.getString(new String[]{object}));
        }
    }

    void checkFilesNotChanged(long l) throws FileNotFoundException {
        if (!this.abortUponModify) {
            return;
        }
        try {
            for (int i = 0; i < this.componentFiles.length; ++i) {
                if (this.componentFiles[i].exists()) {
                    if (!this.existList[i]) {
                        throw new FileNotFoundException(RB.file_disappeared.getString(this.componentFiles[i].getAbsolutePath()));
                    }
                    if (this.componentFiles[i].lastModified() <= l) continue;
                    throw new FileNotFoundException(RB.file_changed.getString(this.componentFiles[i].getAbsolutePath()));
                }
                if (!this.existList[i]) continue;
                throw new FileNotFoundException(RB.file_appeared.getString(this.componentFiles[i].getAbsolutePath()));
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (!this.archiveFile.delete()) {
                System.out.println(RB.cleanup_rmfail.getString(this.archiveFile.getAbsolutePath()));
            }
            throw illegalStateException;
        }
    }

    protected static int generateBufferBlockValue(File[] fileArray) {
        int n;
        long l = 0L;
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n] == null || fileArray[n].length() <= l) continue;
            l = fileArray[n].length();
        }
        n = (int)(l / 5120L);
        if (n < 1) {
            return 1;
        }
        if (n > 40960) {
            return 40960;
        }
        return n;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

