/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import com.vividsolutions.jts.awt.ShapeReader;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import it.geosolutions.jaiext.jts.CoordinateSequence2D;
import it.geosolutions.jaiext.utilities.shape.LiteShape;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;

public class ROIGeometry
extends ROI {
    private static final Logger LOGGER = Logger.getLogger(ROIGeometry.class.getName());
    public static final boolean DEFAULT_ROIGEOMETRY_ANTIALISING = true;
    public static final boolean DEFAULT_ROIGEOMETRY_USEFIXEDPRECISION = false;
    private boolean useAntialiasing = true;
    private boolean useFixedPrecision = false;
    private static final long serialVersionUID = 1L;
    private static final AffineTransformation Y_INVERSION = new AffineTransformation(1.0, 0.0, 0.0, 0.0, -1.0, 0.0);
    private static final String UNSUPPORTED_ROI_TYPE = "The argument be either an ROIGeometry or an ROIShape";
    private final PreparedGeometry theGeom;
    private volatile PlanarImage roiImage;
    private final GeometryFactory geomFactory;
    private static final double tolerance = 1.0;
    private static final PrecisionModel PRECISION = new PrecisionModel(1.0);
    private static final GeometryFactory PRECISE_FACTORY = new GeometryFactory(PRECISION);
    private static final PrecisionModel FLOAT_PRECISION = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
    private static final GeometryFactory FLOAT_PRECISION_FACTORY = new GeometryFactory(FLOAT_PRECISION);
    private final CoordinateSequence2D testPointCS;
    private final Point testPoint;
    private final CoordinateSequence2D testRectCS;
    private final Polygon testRect;
    private RenderingHints hints;

    public ROIGeometry(Geometry geom) {
        this(geom, true, false);
    }

    public ROIGeometry(Geometry geom, boolean useFixedPrecision) {
        this(geom, true, useFixedPrecision);
    }

    public ROIGeometry(Geometry geom, boolean antiAliasing, boolean useFixedPrecision) {
        this(geom, true, useFixedPrecision, null);
    }

    public ROIGeometry(Geometry geom, RenderingHints hints) {
        this(geom, true, false, hints);
    }

    public ROIGeometry(Geometry geom, boolean antiAliasing, boolean useFixedPrecision, RenderingHints hints) {
        if (geom == null) {
            throw new IllegalArgumentException("geom must not be null");
        }
        if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("geom must be a Polygon, MultiPolygon");
        }
        this.useFixedPrecision = useFixedPrecision;
        this.hints = hints;
        Geometry cloned = null;
        if (useFixedPrecision) {
            Coordinate[] coords;
            this.geomFactory = PRECISE_FACTORY;
            cloned = this.geomFactory.createGeometry(geom);
            Coordinate[] arr$ = coords = cloned.getCoordinates();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Coordinate coord;
                Coordinate cc1 = coord = arr$[i$];
                PRECISION.makePrecise(cc1);
            }
            cloned.normalize();
        } else {
            Coordinate[] coords;
            this.geomFactory = FLOAT_PRECISION_FACTORY;
            cloned = this.geomFactory.createGeometry(geom);
            Coordinate[] arr$ = coords = cloned.getCoordinates();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Coordinate coord;
                Coordinate cc1 = coord = arr$[i$];
                FLOAT_PRECISION.makePrecise(cc1);
            }
            cloned.normalize();
        }
        this.theGeom = PreparedGeometryFactory.prepare(cloned);
        this.testPointCS = new CoordinateSequence2D(1);
        this.testPoint = this.geomFactory.createPoint(this.testPointCS);
        this.testRectCS = new CoordinateSequence2D(5);
        this.testRect = this.geomFactory.createPolygon(this.geomFactory.createLinearRing(this.testRectCS), null);
    }

    public ROI add(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    Geometry union = geom.union(this.theGeom.getGeometry());
                    return this.buildROIGeometry(union);
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.add(roi);
    }

    public boolean contains(java.awt.Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean contains(double x, double y) {
        this.testPointCS.setX(0, x);
        this.testPointCS.setY(0, y);
        this.testPoint.geometryChanged();
        return this.theGeom.contains(this.testPoint);
    }

    public boolean contains(Rectangle rect) {
        return this.contains(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(Rectangle2D rect) {
        return this.contains(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(int x, int y, int w, int h) {
        return this.contains((double)x, (double)y, (double)w, (double)h);
    }

    public boolean contains(double x, double y, double w, double h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.contains(this.testRect);
    }

    public ROI exclusiveOr(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    return this.buildROIGeometry(this.theGeom.getGeometry().symDifference(geom));
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.exclusiveOr(roi);
    }

    public int[][] getAsBitmask(int x, int y, int width, int height, int[][] mask) {
        ROI roiImage = new ROI(this.getAsImage());
        return roiImage.getAsBitmask(x, y, width, height, mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanarImage getAsImage() {
        if (this.roiImage == null) {
            ROIGeometry rOIGeometry = this;
            synchronized (rOIGeometry) {
                if (this.roiImage == null) {
                    Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
                    int x = (int)Math.floor(env.getMinX());
                    int y = (int)Math.floor(env.getMinY());
                    int w = (int)Math.ceil(env.getMaxX()) - x;
                    int h = (int)Math.ceil(env.getMaxY()) - y;
                    ParameterBlockJAI pb = new ParameterBlockJAI("VectorBinarize");
                    pb.setParameter("minx", x);
                    pb.setParameter("miny", y);
                    pb.setParameter("width", w);
                    pb.setParameter("height", h);
                    pb.setParameter("geometry", this.theGeom);
                    pb.setParameter("antiAliasing", this.useAntialiasing);
                    this.roiImage = JAI.create("VectorBinarize", pb, this.hints);
                }
            }
        }
        return this.roiImage;
    }

    public LinkedList getAsRectangleList(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        if (!this.intersects(rect)) {
            return null;
        }
        if (this.theGeom.getGeometry().isRectangle()) {
            Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
            Envelope intersection = env.intersection(new Envelope(x, x + width, y, y + width));
            int rx = (int)Math.round(intersection.getMinX());
            int ry = (int)Math.round(intersection.getMinY());
            int rw = (int)Math.round(intersection.getMaxX() - (double)rx);
            int rh = (int)Math.round(intersection.getMaxY() - (double)ry);
            LinkedList<Rectangle> result = new LinkedList<Rectangle>();
            result.add(new Rectangle(rx, ry, rw, rh));
            return result;
        }
        ROI roiImage = new ROI(this.getAsImage());
        return roiImage.getAsRectangleList(x, y, width, height);
    }

    public Shape getAsShape() {
        return new LiteShape(this.theGeom.getGeometry());
    }

    public Geometry getAsGeometry() {
        return this.theGeom.getGeometry();
    }

    public Rectangle getBounds() {
        Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
        return new Rectangle((int)env.getMinX(), (int)env.getMinY(), (int)env.getWidth(), (int)env.getHeight());
    }

    public Rectangle2D getBounds2D() {
        Envelope env = this.theGeom.getGeometry().getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
    }

    public int getThreshold() {
        return super.getThreshold();
    }

    public ROI intersect(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    Geometry intersect = geom.intersection(this.theGeom.getGeometry());
                    return this.buildROIGeometry(intersect);
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.intersect(roi);
    }

    private Geometry getGeometry(ROI roi) {
        if (roi instanceof ROIGeometry) {
            return ((ROIGeometry)roi).getAsGeometry();
        }
        if (roi instanceof ROIShape) {
            Shape shape = ((ROIShape)roi).getAsShape();
            Geometry geom = ShapeReader.read(shape, 0.0, this.geomFactory);
            geom.apply(Y_INVERSION);
            return geom;
        }
        return null;
    }

    public boolean intersects(Rectangle rect) {
        this.setTestRect(rect.x, rect.y, rect.width, rect.height);
        return this.theGeom.intersects(this.testRect);
    }

    public boolean intersects(Rectangle2D rect) {
        this.setTestRect(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
        return this.theGeom.intersects(this.testRect);
    }

    public boolean intersects(int x, int y, int w, int h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.intersects(this.testRect);
    }

    public boolean intersects(double x, double y, double w, double h) {
        this.setTestRect(x, y, w, h);
        return this.theGeom.intersects(this.testRect);
    }

    public ROI performImageOp(RenderedImageFactory RIF, ParameterBlock paramBlock, int sourceIndex, RenderingHints renderHints) {
        return super.performImageOp(RIF, paramBlock, sourceIndex, renderHints);
    }

    public ROI performImageOp(String name, ParameterBlock paramBlock, int sourceIndex, RenderingHints renderHints) {
        return super.performImageOp(name, paramBlock, sourceIndex, renderHints);
    }

    public void setThreshold(int threshold) {
        super.setThreshold(threshold);
    }

    public ROI subtract(ROI roi) {
        block3: {
            try {
                Geometry geom = this.getGeometry(roi);
                if (geom != null) {
                    Geometry difference = this.theGeom.getGeometry().difference(geom);
                    return this.buildROIGeometry(difference);
                }
            }
            catch (TopologyException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to perform operation using geometries, falling back on raster path", e);
            }
        }
        return super.subtract(roi);
    }

    public ROI transform(AffineTransform at, Interpolation interp) {
        return this.transform(at);
    }

    public ROI transform(AffineTransform at) {
        Geometry cloned = (Geometry)this.theGeom.getGeometry().clone();
        cloned.apply(new AffineTransformation(at.getScaleX(), at.getShearX(), at.getTranslateX(), at.getShearY(), at.getScaleY(), at.getTranslateY()));
        if (this.useFixedPrecision) {
            Coordinate[] coords;
            Geometry fixed = PRECISE_FACTORY.createGeometry(cloned);
            Coordinate[] arr$ = coords = fixed.getCoordinates();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Coordinate coord;
                Coordinate precise = coord = arr$[i$];
                PRECISION.makePrecise(precise);
            }
            cloned = fixed;
        }
        return this.buildROIGeometry(cloned);
    }

    private void setTestRect(double x, double y, double w, double h) {
        this.testRectCS.setXY(0, x, y);
        this.testRectCS.setXY(1, x, y + h);
        this.testRectCS.setXY(2, x + w, y + h);
        this.testRectCS.setXY(3, x + w, y);
        this.testRectCS.setXY(4, x, y);
        this.testRect.geometryChanged();
    }

    private ROI buildROIGeometry(Geometry geometry) {
        final ArrayList polygons = new ArrayList();
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                if (geom instanceof Polygon) {
                    polygons.add((Polygon)geom);
                }
            }
        });
        Geometry geom = null;
        if (polygons.size() == 0) {
            geom = this.geomFactory.createMultiPolygon(new Polygon[0]);
        } else if (polygons.size() == 1) {
            geom = (Geometry)polygons.get(0);
        } else {
            Polygon[] polygonArray = polygons.toArray(new Polygon[polygons.size()]);
            geom = this.geomFactory.createMultiPolygon(polygonArray);
        }
        return new ROIGeometry(geom, this.useAntialiasing, this.useFixedPrecision, this.hints);
    }
}

