/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1D;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.piecewise.MathTransformationAdapter;
import org.geotools.renderer.i18n.Errors;
import org.geotools.styling.AbstractContrastMethodStrategy;
import org.geotools.styling.ExponentialContrastMethodStrategy;
import org.geotools.styling.HistogramContrastMethodStrategy;
import org.geotools.styling.LogarithmicContrastMethodStrategy;
import org.geotools.styling.NormalizeContrastMethodStrategy;
import org.geotools.util.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.operation.TransformException;

public enum ContrastEnhancementType {
    EXPONENTIAL{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            RenderedImage inputImage = inputWorker.getRenderedImage();
            assert (inputImage.getSampleModel().getNumBands() == 1) : inputImage;
            int dataType = inputImage.getSampleModel().getDataType();
            if (dataType == 0) {
                LookupTable table = this.createByteLookupTable(EMPTY_MAP);
                inputWorker.lookup(table);
                return inputWorker.getRenderedImage();
            }
            inputWorker.removeRenderingHints();
            double[] minimum = inputWorker.getMinimums();
            double[] maximum = inputWorker.getMaximums();
            PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> transform = this.generatePiecewise(ContrastEnhancementType.setMinMaxParams(minimum[0], maximum[0]));
            inputWorker.piecewise(transform, 0);
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            byte[] lut = new byte[256];
            double normalizationFactor = 255.0;
            double correctionFactor = 148.40406025167826;
            for (int i = 1; i < lut.length; ++i) {
                lut[i] = (byte)(0.5 + 148.40406025167826 * (Math.exp((double)i / 255.0) - 1.0));
            }
            return ContrastEnhancementType.generateLookupTableByte(lut);
        }

        @Override
        PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generatePiecewise(Map<String, Object> params) {
            double maximum;
            Utilities.ensureNonNull("params", params);
            double minimum = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            final double normalizationFactor = maximum = ((Double)params.get(ContrastEnhancementType.KEY_MAX)).doubleValue();
            final double correctionFactor = normalizationFactor / 1.718281828459045;
            DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("exponential-contrast-enhancement-transform", RangeFactory.create(minimum, maximum), new MathTransformationAdapter(){

                @Override
                public double derivative(double value) throws TransformException {
                    throw new UnsupportedOperationException(Errors.format(15));
                }

                @Override
                public boolean isIdentity() {
                    return false;
                }

                @Override
                public double transform(double value) {
                    value = correctionFactor * (Math.exp(value / normalizationFactor) - 1.0);
                    return value;
                }
            });
            return new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
        }
    }
    ,
    LOGARITHMIC{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            RenderedImage inputImage = inputWorker.getRenderedImage();
            assert (inputImage.getSampleModel().getNumBands() == 1) : inputImage;
            int dataType = inputImage.getSampleModel().getDataType();
            if (dataType == 0) {
                LookupTable table = this.createByteLookupTable(EMPTY_MAP);
                inputWorker.lookup(table);
                return inputWorker.getRenderedImage();
            }
            inputWorker.removeRenderingHints();
            double[] minimum = inputWorker.getMinimums();
            double[] maximum = inputWorker.getMaximums();
            PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> transform = this.generatePiecewise(ContrastEnhancementType.setMinMaxParams(minimum[0], maximum[0]));
            inputWorker.piecewise(transform, 0);
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            byte[] lut = new byte[256];
            double normalizationFactor = 255.0;
            double correctionFactor = 100.0;
            for (int i = 1; i < lut.length; ++i) {
                lut[i] = (byte)(0.5 + 255.0 * Math.log((double)i * 100.0 / 255.0 + 1.0));
            }
            return ContrastEnhancementType.generateLookupTableByte(lut);
        }

        @Override
        PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generatePiecewise(Map<String, Object> params) {
            double maximum;
            Utilities.ensureNonNull("params", params);
            double minimum = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            final double normalizationFactor = maximum = ((Double)params.get(ContrastEnhancementType.KEY_MAX)).doubleValue();
            double correctionFactor = 100.0;
            DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("logarithmic-contrast-enhancement-transform", RangeFactory.create(minimum, maximum), new MathTransformationAdapter(){

                @Override
                public double derivative(double value) throws TransformException {
                    throw new UnsupportedOperationException(Errors.format(15));
                }

                @Override
                public boolean isIdentity() {
                    return false;
                }

                @Override
                public double transform(double value) {
                    value = normalizationFactor * Math.log(1.0 + value * 100.0 / normalizationFactor);
                    return value;
                }
            });
            return new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
        }
    }
    ,
    HISTOGRAM{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            inputWorker.rescaleToBytes();
            Histogram h = inputWorker.removeRenderingHints().getHistogram(null, null, null);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ContrastEnhancementType.KEY_HISTOGRAM, h);
            LookupTable table = this.createByteLookupTable(params);
            inputWorker.setRenderingHints(hints);
            inputWorker.lookup(table);
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            Utilities.ensureNonNull("params", params);
            Histogram h = (Histogram)params.get(ContrastEnhancementType.KEY_HISTOGRAM);
            byte[] cumulative = new byte[h.getNumBins(0)];
            float totalBinSum = 0.0f;
            for (int i = 0; i < cumulative.length; ++i) {
                totalBinSum += (float)h.getBinSize(0, i);
            }
            float scale = (float)(h.getHighValue(0) - 1.0 - h.getLowValue(0)) / totalBinSum;
            float sum = 0.0f;
            for (int i = 1; i < cumulative.length; ++i) {
                cumulative[i] = (byte)((double)((sum += (float)h.getBinSize(0, i - 1)) * scale) + h.getLowValue(0) + 0.5);
            }
            return ContrastEnhancementType.generateLookupTableByte(cumulative);
        }
    }
    ,
    NORMALIZE_DEFAULT{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            double[][] extrema = new double[2][];
            inputWorker.removeRenderingHints();
            RenderedImage inputImage = inputWorker.getRenderedImage();
            extrema[0] = inputWorker.getMinimums();
            extrema[1] = inputWorker.getMaximums();
            int numBands = extrema[0].length;
            assert (numBands == 1) : inputWorker.getRenderedOperation();
            int dataType = inputImage.getSampleModel().getDataType();
            double minData = extrema[0][0];
            double maxData = extrema[1][0];
            Map params = ContrastEnhancementType.setMinMaxParams(minData, maxData);
            if (dataType == 0) {
                if (maxData == 255.0 && minData == 0.0) {
                    return inputImage;
                }
                LookupTable table = this.createByteLookupTable(params);
                inputWorker.setRenderingHints(hints);
                inputWorker.lookup(table);
                return inputWorker.getRenderedImage();
            }
            double maximum = 255.0;
            double minimum = 0.0;
            if (4.areEqual(extrema[1][0], 255.0) && 4.areEqual(extrema[0][0], 0.0)) {
                return inputWorker.getRenderedImage();
            }
            double delta = extrema[1][0] - extrema[0][0];
            double scale = 255.0 / delta;
            double offset = 0.0 - scale * extrema[0][0];
            ImageLayout2 layout = new ImageLayout2(inputWorker.getRenderedImage());
            SampleModel sm = RasterFactory.createBandedSampleModel(0, inputWorker.getRenderedImage().getWidth(), inputWorker.getRenderedImage().getHeight(), 1);
            layout.setSampleModel(sm);
            layout.setColorModel(new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0));
            Hints localHints = hints.clone();
            localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            inputWorker.setRenderingHints(localHints);
            inputWorker.rescale(new double[]{scale}, new double[]{offset});
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            return 4.generateLinearByteLookupTable(params);
        }
    }
    ,
    NORMALIZE_STRETCH_TO_MINMAX{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            ContrastEnhancementType.checkParameters(parameters, ContrastEnhancementType.KEY_MIN, ContrastEnhancementType.KEY_MAX);
            Map processParams = ContrastEnhancementType.getMinMaxParams(parameters);
            RenderedImage inputImage = inputWorker.getRenderedImage();
            int dataType = inputImage.getSampleModel().getDataType();
            Utilities.ensureNonNull("processParams", processParams);
            double minData = (Double)processParams.get(ContrastEnhancementType.KEY_MIN);
            double maxData = (Double)processParams.get(ContrastEnhancementType.KEY_MAX);
            if (dataType == 0) {
                if (maxData == 255.0 && minData == 0.0) {
                    return inputImage;
                }
                LookupTable table = this.createByteLookupTable(processParams);
                inputWorker.setRenderingHints(hints);
                inputWorker.lookup(table);
                return inputWorker.getRenderedImage();
            }
            double maximum = 255.0;
            double minimum = 0.0;
            if (5.areEqual(maxData, 255.0) && 5.areEqual(minData, 0.0)) {
                return inputWorker.getRenderedImage();
            }
            double delta = maxData - minData;
            double scale = 255.0 / delta;
            double offset = 0.0 - scale * minData;
            ImageLayout2 layout = new ImageLayout2(inputWorker.getRenderedImage());
            ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            layout.setColorModel(colorModel);
            layout.setSampleModel(colorModel.createCompatibleSampleModel(inputWorker.getRenderedImage().getWidth(), inputWorker.getRenderedImage().getHeight()));
            Hints localHints = hints.clone();
            localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            inputWorker.setRenderingHints(localHints);
            inputWorker.rescale(new double[]{scale}, new double[]{offset});
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            Utilities.ensureNonNull("params", params);
            double min = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            double max = (Double)params.get(ContrastEnhancementType.KEY_MAX);
            double delta = max - min;
            double scale = 255.0 / delta;
            double offset = -scale * min;
            byte[] lut = new byte[256];
            for (int i = 1; i < lut.length; ++i) {
                lut[i] = (byte)((double)i < min ? 0 : (byte)((double)i > max ? -1 : (byte)(scale * (double)i + offset + 0.5)));
            }
            return ContrastEnhancementType.generateLookupTableByte(lut);
        }
    }
    ,
    NORMALIZE_CLIP_TO_MINMAX{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            ContrastEnhancementType.checkParameters(parameters, ContrastEnhancementType.KEY_MIN, ContrastEnhancementType.KEY_MAX);
            Map processParams = ContrastEnhancementType.getMinMaxParams(parameters);
            RenderedImage inputImage = inputWorker.getRenderedImage();
            int dataType = inputImage.getSampleModel().getDataType();
            Utilities.ensureNonNull("processParams", processParams);
            double minData = (Double)processParams.get(ContrastEnhancementType.KEY_MIN);
            double maxData = (Double)processParams.get(ContrastEnhancementType.KEY_MAX);
            if (dataType == 0) {
                if (maxData == 255.0 && minData == 0.0) {
                    return inputImage;
                }
                LookupTable table = this.createByteLookupTable(processParams);
                inputWorker.setRenderingHints(hints);
                inputWorker.lookup(table);
                return inputWorker.getRenderedImage();
            }
            PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> transform = this.generatePiecewise(processParams);
            inputWorker.piecewise(transform, 0);
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            double min = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            double max = (Double)params.get(ContrastEnhancementType.KEY_MAX);
            byte[] lut = ContrastEnhancementType.createClampingLookupTableByte(min, max, (byte)min, (byte)max);
            return ContrastEnhancementType.generateLookupTableByte(lut);
        }

        @Override
        PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generatePiecewise(Map<String, Object> params) {
            Utilities.ensureNonNull("params", params);
            double minimum = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            double maximum = (Double)params.get(ContrastEnhancementType.KEY_MAX);
            return ContrastEnhancementType.generateClampingPiecewise(minimum, maximum, minimum, maximum);
        }
    }
    ,
    NORMALIZE_CLIP_TO_ZERO{

        @Override
        RenderedImage process(ImageWorker inputWorker, Hints hints, Map<String, Expression> parameters) {
            ContrastEnhancementType.checkParameters(parameters, ContrastEnhancementType.KEY_MIN, ContrastEnhancementType.KEY_MAX);
            Map processParams = ContrastEnhancementType.getMinMaxParams(parameters);
            RenderedImage inputImage = inputWorker.getRenderedImage();
            int dataType = inputImage.getSampleModel().getDataType();
            Utilities.ensureNonNull("processParams", processParams);
            double minData = (Double)processParams.get(ContrastEnhancementType.KEY_MIN);
            double maxData = (Double)processParams.get(ContrastEnhancementType.KEY_MAX);
            if (dataType == 0) {
                if (maxData == 255.0 && minData == 0.0) {
                    return inputImage;
                }
                LookupTable table = this.createByteLookupTable(processParams);
                inputWorker.setRenderingHints(hints);
                inputWorker.lookup(table);
                return inputWorker.getRenderedImage();
            }
            processParams.put(ContrastEnhancementType.KEY_DATATYPE, dataType);
            PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> transform = this.generatePiecewise(processParams);
            inputWorker.piecewise(transform, 0);
            return inputWorker.getRenderedImage();
        }

        @Override
        LookupTable createByteLookupTable(Map<String, Object> params) {
            double min = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            double max = (Double)params.get(ContrastEnhancementType.KEY_MAX);
            byte[] lut = ContrastEnhancementType.createClampingLookupTableByte(min, max, (byte)0, (byte)0);
            return ContrastEnhancementType.generateLookupTableByte(lut);
        }

        @Override
        PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generatePiecewise(Map<String, Object> params) {
            Utilities.ensureNonNull("params", params);
            double minimum = (Double)params.get(ContrastEnhancementType.KEY_MIN);
            double maximum = (Double)params.get(ContrastEnhancementType.KEY_MAX);
            return ContrastEnhancementType.generateClampingPiecewise(minimum, maximum, 0.0, 0.0);
        }
    };

    private static final int MAX_BYTE = 255;
    private static final int MIN_BYTE = 0;
    public static final String KEY_MIN = "minValue";
    public static final String KEY_MAX = "maxValue";
    public static final String KEY_DATATYPE = "dataType";
    public static final String KEY_HISTOGRAM = "histogram";
    public static final String KEY_CORRECTION_FACTOR = "correctionFactor";
    public static final String KEY_NORMALIZATION_FACTOR = "normalizationFactor";
    public static final String NORMALIZE_STRETCH_TO_MINMAX_NAME = "StretchToMinimumMaximum";
    public static final String NORMALIZE_CLIP_TO_MINMAX_NAME = "ClipToMinimumMaximum";
    public static final String NORMALIZE_CLIP_TO_ZERO_NAME = "ClipToZero";
    private static final double DELTA = 1.0E-8;
    private static Map<String, Object> EMPTY_MAP;
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 1.0;

    private static PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generateClampingPiecewise(double minimum, double maximum, double minValue, double maxValue) {
        DefaultPiecewiseTransform1DElement zeroElement = DefaultPiecewiseTransform1DElement.create((CharSequence)"clamp-to-min", RangeFactory.create(0.0, true, minimum, false), minValue);
        DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("passthrough", RangeFactory.create(minimum, maximum));
        DefaultPiecewiseTransform1DElement maxElement = DefaultPiecewiseTransform1DElement.create((CharSequence)"clamp-to-max", RangeFactory.create(maximum, false, Double.POSITIVE_INFINITY, true), maxValue);
        return new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zeroElement, mainElement, maxElement}, 0.0);
    }

    private static Map<String, Object> getMinMaxParams(Map<String, Expression> parameters) {
        Expression min = parameters.get(KEY_MIN);
        Expression max = parameters.get(KEY_MAX);
        if (min == null || max == null) {
            throw new IllegalArgumentException(Errors.format(19, KEY_MIN, KEY_MAX));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Number minVal = min.evaluate(null, Double.class);
        Number maxVal = max.evaluate(null, Double.class);
        if (minVal == null || maxVal == null) {
            throw new IllegalArgumentException(Errors.format(19, KEY_MIN, KEY_MAX));
        }
        params.put(KEY_MIN, minVal.doubleValue());
        params.put(KEY_MAX, maxVal.doubleValue());
        return params;
    }

    private static byte[] createClampingLookupTableByte(double min, double max, byte newMin, byte newMax) {
        byte[] lut = new byte[256];
        for (int i = 1; i < lut.length; ++i) {
            lut[i] = (double)i < min ? newMin : ((double)i > max ? newMax : (byte)i);
        }
        return lut;
    }

    private static double getMaxValue(int dataType) {
        switch (dataType) {
            case 0: {
                return 255.0;
            }
            case 2: {
                return 32767.0;
            }
            case 1: {
                return 65535.0;
            }
            case 3: {
                return 2.147483647E9;
            }
            case 4: {
                return 3.4028234663852886E38;
            }
            case 5: {
                return Double.MAX_VALUE;
            }
        }
        return Double.NaN;
    }

    public static boolean areEqual(double a, double b) {
        if (!Double.isNaN(a) && !Double.isNaN(b)) {
            return Math.abs(a - b) < 1.0E-8;
        }
        return false;
    }

    static LookupTable generateLinearByteLookupTable(Map<String, Object> params) {
        Utilities.ensureNonNull("params", params);
        double min = (Double)params.get(KEY_MIN);
        double max = (Double)params.get(KEY_MAX);
        double delta = max - min;
        double scale = 255.0 / delta;
        double offset = -scale * min;
        byte[] lut = new byte[256];
        for (int i = 1; i < lut.length; ++i) {
            lut[i] = (byte)(scale * (double)i + offset + 0.5);
        }
        return ContrastEnhancementType.generateLookupTableByte(lut);
    }

    abstract RenderedImage process(ImageWorker var1, Hints var2, Map<String, Expression> var3);

    LookupTable createByteLookupTable(Map<String, Object> params) {
        throw new UnsupportedOperationException();
    }

    PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generatePiecewise(Map<String, Object> params) {
        throw new UnsupportedOperationException();
    }

    private static LookupTable generateLookupTableByte(byte[] lut) {
        return LookupTableFactory.create(lut, 0);
    }

    public static PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> generateGammaCorrectedPiecewise(double minimum, double maximum, final double gammaValue) {
        final double scale = (maximum - minimum) / 1.0;
        final double offset = minimum - 0.0 * scale;
        DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("gamma-correction-transform", RangeFactory.create(minimum, maximum), new MathTransformationAdapter(){

            @Override
            public double derivative(double value) throws TransformException {
                throw new UnsupportedOperationException(Errors.format(15));
            }

            @Override
            public boolean isIdentity() {
                return false;
            }

            @Override
            public double transform(double value) {
                value = (value - offset) / scale;
                return offset + Math.pow(value, gammaValue) * scale;
            }
        });
        return new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
    }

    private static Map<String, Object> setMinMaxParams(double minData, double maxData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_MIN, minData);
        params.put(KEY_MAX, maxData);
        return params;
    }

    private static void checkParameters(Map<String, Expression> parameters, String parameter1, String parameter2) {
        if (parameters == null) {
            throw new IllegalArgumentException(Errors.format(8, parameters));
        }
        if (parameters.isEmpty()) {
            throw new IllegalArgumentException(Errors.format(19, parameter1, parameter2));
        }
    }

    public static ContrastEnhancementType getType(AbstractContrastMethodStrategy method) {
        if (method instanceof NormalizeContrastMethodStrategy) {
            String algorithmType = ContrastEnhancementType.parseAlgorithm(method.getAlgorithm());
            if (algorithmType == null) {
                return NORMALIZE_DEFAULT;
            }
            if (NORMALIZE_STRETCH_TO_MINMAX_NAME.equals(algorithmType)) {
                return NORMALIZE_STRETCH_TO_MINMAX;
            }
            if (NORMALIZE_CLIP_TO_MINMAX_NAME.equals(algorithmType)) {
                return NORMALIZE_CLIP_TO_MINMAX;
            }
            if (NORMALIZE_CLIP_TO_ZERO_NAME.equals(algorithmType)) {
                return NORMALIZE_CLIP_TO_ZERO;
            }
            throw new IllegalArgumentException(Errors.format(18, algorithmType));
        }
        if (method instanceof LogarithmicContrastMethodStrategy) {
            return LOGARITHMIC;
        }
        if (method instanceof ExponentialContrastMethodStrategy) {
            return EXPONENTIAL;
        }
        if (method instanceof HistogramContrastMethodStrategy) {
            return HISTOGRAM;
        }
        throw new IllegalArgumentException(Errors.format(17, method));
    }

    private static String parseAlgorithm(Expression algorithm) {
        if (algorithm != null) {
            return algorithm.evaluate(null, String.class);
        }
        return null;
    }

    static {
        EMPTY_MAP = Collections.emptyMap();
    }
}

