/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;

public final class MultiplyConverter
extends UnitConverter {
    private final double _factor;
    private static final long serialVersionUID = 1L;

    public MultiplyConverter(double factor) {
        if ((double)((float)factor) == 1.0) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._factor = factor;
    }

    public double getFactor() {
        return this._factor;
    }

    public UnitConverter inverse() {
        return new MultiplyConverter(1.0 / this._factor);
    }

    public double convert(double amount) {
        return this._factor * amount;
    }

    public boolean isLinear() {
        return true;
    }

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof MultiplyConverter) {
            double factor = this._factor * ((MultiplyConverter)converter)._factor;
            return MultiplyConverter.valueOf(factor);
        }
        if (converter instanceof RationalConverter) {
            double factor = this._factor * (double)((RationalConverter)converter).getDividend() / (double)((RationalConverter)converter).getDivisor();
            return MultiplyConverter.valueOf(factor);
        }
        return super.concatenate(converter);
    }

    private static UnitConverter valueOf(double factor) {
        float asFloat = (float)factor;
        return asFloat == 1.0f ? UnitConverter.IDENTITY : new MultiplyConverter(factor);
    }
}

