/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.locale;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.swing.locale.PropertiesFileFinder;
import org.geotools.swing.locale.PropertiesFileInfo;
import org.geotools.util.logging.Logging;

public class LocaleUtils {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.swing");
    private static final String PREFIX = "org/geotools/swing/locale/";
    private static final List<LocaleInfo> supportedLocales;
    private static final List<Locale> workingLocales;
    private static final Map<String, ResourceBundle> bundles;
    private static final ReadWriteLock lock;

    private LocaleUtils() {
    }

    public static boolean isFullySupportedLocale(Locale locale) {
        for (LocaleInfo li : supportedLocales) {
            if (!li.locale.equals(locale)) continue;
            return li.fullySupported;
        }
        return false;
    }

    public static boolean isSupportedLocale(Locale locale) {
        for (LocaleInfo li : supportedLocales) {
            if (!li.locale.equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static void setLocale(Locale preferredLocale) {
        LocaleUtils.setLocale(Collections.singletonList(preferredLocale));
    }

    public static void setLocale(List<Locale> preferredLocales) {
        lock.writeLock().lock();
        try {
            LocaleUtils.filterAndCopy(preferredLocales);
            bundles.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static String getValue(String baseFileName, String key) {
        lock.readLock().lock();
        try {
            if (baseFileName == null || key == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            String string = LocaleUtils.getBundle(baseFileName).getString(key);
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static ResourceBundle getBundle(String resBundleName) {
        ResourceBundle rb = bundles.get(resBundleName);
        if (rb == null) {
            rb = ResourceBundle.getBundle(PREFIX + resBundleName, new ResourceBundle.Control(){

                @Override
                public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                    return workingLocales;
                }
            });
            bundles.put(resBundleName, rb);
        }
        return rb;
    }

    private static void filterAndCopy(List<Locale> requestedLocales) {
        workingLocales.clear();
        for (Locale locale : requestedLocales) {
            if (locale.equals(Locale.ROOT)) continue;
            if (LocaleUtils.isSupportedLocale(locale)) {
                workingLocales.add(locale);
                continue;
            }
            LOGGER.log(Level.WARNING, "{0} is not currently supported", locale);
        }
        workingLocales.add(Locale.ROOT);
    }

    private static List<LocaleInfo> loadLocaleInfo() throws IOException {
        PropertiesFileFinder finder = new PropertiesFileFinder();
        List<PropertiesFileInfo> infoList = finder.scan(PREFIX);
        HashSet<Locale> allLocales = new HashSet<Locale>();
        for (PropertiesFileInfo info : infoList) {
            allLocales.addAll(info.getLocales());
        }
        ArrayList<LocaleInfo> localeInfoList = new ArrayList<LocaleInfo>();
        for (Locale l : allLocales) {
            localeInfoList.add(new LocaleInfo(l, true));
        }
        for (PropertiesFileInfo info : infoList) {
            List<Locale> locales = info.getLocales();
            for (LocaleInfo li : localeInfoList) {
                if (locales.contains(li.locale)) continue;
                li.fullySupported = false;
            }
        }
        return localeInfoList;
    }

    static {
        bundles = new ConcurrentHashMap<String, ResourceBundle>();
        lock = new ReentrantReadWriteLock();
        try {
            supportedLocales = LocaleUtils.loadLocaleInfo();
            workingLocales = new ArrayList<Locale>();
            workingLocales.add(Locale.ROOT);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read the locale directory", ex);
        }
    }

    private static class LocaleInfo {
        Locale locale;
        boolean fullySupported;

        public LocaleInfo(Locale locale, boolean fullySupported) {
            this.locale = locale;
            this.fullySupported = fullySupported;
        }
    }
}

