/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.windbarbs;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

class SpeedConverter {
    private static final Logger LOGGER = Logging.getLogger(SpeedConverter.class);
    private static final UnitFormat UCUM_FORMAT_INSTANCE = UnitFormat.getUCUMInstance();
    private static final double SECONDS_IN_HOUR = 3600.0;
    private static final double METERS_IN_KILOMETER = 1000.0;
    private static final double METERS_IN_NAUTICAL_MILE = 1852.0;
    private static final double METERS_PER_SECOND_TO_KNOTS = 1.9438444924406046;
    private static final double CENTIMETERS_PER_SECOND_TO_KNOTS = 0.019438444924406047;
    private static final double KILOMETERS_PER_HOUR_TO_KNOTS = 0.5399568034557235;
    private static final String METER_PER_SECOND = "m/s";
    private static final String CENTIMETER_PER_SECOND = "cm/s";
    private static final String KILOMETER_PER_HOUR = "km/h";
    private static final String MILE_PER_HOUR = "mph";
    private static final double MILES_PER_HOUR_TO_KNOTS = 0.868976;
    private static final String KNOTS = "knots";
    private static final String KTS = "kts";
    private static final String KN = NonSI.KNOT.toString();

    SpeedConverter() {
    }

    static double toKnots(double speed, String uom) {
        Utilities.ensureNonNull("uom", uom);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Convert speed: " + speed + " (" + uom + ")");
        }
        if (Double.isNaN(speed)) {
            return Double.NaN;
        }
        if (Double.isInfinite(speed)) {
            throw new IllegalArgumentException("Provided infinite speed, which is illegal!");
        }
        if (uom.equalsIgnoreCase(KNOTS) || uom.equalsIgnoreCase(KTS) || uom.equalsIgnoreCase(KN)) {
            return speed;
        }
        if (uom.equalsIgnoreCase(METER_PER_SECOND)) {
            return speed * 1.9438444924406046;
        }
        if (uom.equalsIgnoreCase(CENTIMETER_PER_SECOND)) {
            return speed * 0.019438444924406047;
        }
        if (uom.equalsIgnoreCase(KILOMETER_PER_HOUR)) {
            return speed * 0.5399568034557235;
        }
        if (uom.equalsIgnoreCase(MILE_PER_HOUR)) {
            return speed * 0.868976;
        }
        try {
            Unit unit = (Unit)UCUM_FORMAT_INSTANCE.parseObject(uom);
            UnitConverter converter = unit.getConverterTo(NonSI.KNOT);
            return converter.convert(speed);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The supplied units isn't currently supported:" + uom, e);
        }
    }
}

