/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XSDOrdered implements Enumerator
{
    FALSE_LITERAL(0, "false", "false"),
    PARTIAL_LITERAL(1, "partial", "partial"),
    TOTAL_LITERAL(2, "total", "total");

    public static final int FALSE = 0;
    public static final int PARTIAL = 1;
    public static final int TOTAL = 2;
    private static final XSDOrdered[] VALUES_ARRAY;
    public static final List<XSDOrdered> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDOrdered[]{FALSE_LITERAL, PARTIAL_LITERAL, TOTAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDOrdered get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDOrdered result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDOrdered getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDOrdered result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDOrdered get(int value) {
        switch (value) {
            case 0: {
                return FALSE_LITERAL;
            }
            case 1: {
                return PARTIAL_LITERAL;
            }
            case 2: {
                return TOTAL_LITERAL;
            }
        }
        return null;
    }

    private XSDOrdered(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

