/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.geotools.io.ExpandedTabWriter;

public final class GraphicsUtilities {
    private static final int TAB_WIDTH = 4;

    private GraphicsUtilities() {
    }

    public static void paintStackTrace(Graphics2D graphics, Rectangle widgetBounds, Throwable exception) {
        GlyphVector line;
        Rectangle2D rect;
        String message = GraphicsUtilities.printStackTrace(exception);
        double width = 0.0;
        double height = 0.0;
        ArrayList<GlyphVector> glyphs = new ArrayList<GlyphVector>();
        ArrayList<Rectangle2D> bounds = new ArrayList<Rectangle2D>();
        int length = message.length();
        Font font = graphics.getFont();
        FontRenderContext context = graphics.getFontRenderContext();
        int i = 0;
        while (i < length) {
            int irn;
            double w;
            int ir = message.indexOf(13, i);
            int in = message.indexOf(10, i);
            if (ir < 0) {
                ir = length;
            }
            if (in < 0) {
                in = length;
            }
            if ((w = (rect = (line = font.createGlyphVector(context, message.substring(i, irn = Math.min(ir, in)))).getVisualBounds()).getWidth()) > width) {
                width = w;
            }
            height += rect.getHeight();
            glyphs.add(line);
            bounds.add(rect);
            i = (Math.abs(ir - in) <= 1 ? Math.max(ir, in) : irn) + 1;
        }
        float xpos = (float)(0.5 * ((double)widgetBounds.width - width));
        float ypos = (float)(0.5 * ((double)widgetBounds.height - height));
        int size = glyphs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            line = (GlyphVector)glyphs.get(i2);
            rect = (Rectangle2D)bounds.get(i2);
            ypos = (float)((double)ypos + rect.getHeight());
            graphics.drawGlyphVector(line, xpos, ypos);
        }
    }

    public static String printStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(new ExpandedTabWriter(writer, 4)));
        return writer.toString();
    }
}

