/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.resources.image.ImageUtilities;

class DisposableGridCoverage
extends GridCoverage2D {
    private static final long serialVersionUID = 1L;
    GridCoverage2D delegate;

    public DisposableGridCoverage(GridCoverage2D coverage) {
        super((CharSequence)coverage.getName(), coverage);
        this.delegate = coverage;
    }

    @Override
    public synchronized boolean dispose(boolean force) {
        try {
            this.delegate.dispose(force);
            RenderedImage image = this.delegate.getRenderedImage();
            if (image instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)image);
            }
        }
        finally {
            return super.dispose(force);
        }
    }
}

