/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import org.geotools.referencing.factory.wms.Code;
import org.geotools.referencing.factory.wms.Factlet;
import org.opengis.parameter.ParameterValueGroup;

final class Auto42001
extends Factlet {
    public static final Auto42001 DEFAULT = new Auto42001();

    private Auto42001() {
    }

    @Override
    public int code() {
        return 42001;
    }

    @Override
    public String getName() {
        return "WGS 84 / Auto UTM";
    }

    @Override
    public String getClassification() {
        return "Transverse_Mercator";
    }

    @Override
    protected void setProjectionParameters(ParameterValueGroup parameters, Code code) {
        double zone = Math.min(Math.floor((code.longitude + 180.0) / 6.0) + 1.0, 60.0);
        double centralMeridian = -183.0 + zone * 6.0;
        double falseNorthing = code.latitude >= 0.0 ? 0.0 : 1.0E7;
        parameters.parameter("latitude_of_origin").setValue(0.0);
        parameters.parameter("central_meridian").setValue(centralMeridian);
        parameters.parameter("false_easting").setValue(500000.0);
        parameters.parameter("false_northing").setValue(falseNorthing);
        parameters.parameter("scale_factor").setValue(0.9996);
    }
}

