/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml3.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;

public class PointTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public PointTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    @Override
    public QName getTarget() {
        return GML.PointType;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    @Override
    public Class getType() {
        return Point.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (node.hasChild(DirectPosition.class)) {
            DirectPosition dp = (DirectPosition)node.getChildValue(DirectPosition.class);
            if (dp instanceof DirectPosition2D) {
                return this.gFactory.createPoint(new Coordinate(dp.getOrdinate(0), dp.getOrdinate(1)));
            }
            return this.gFactory.createPoint(new Coordinate(dp.getOrdinate(0), dp.getOrdinate(1), dp.getOrdinate(2)));
        }
        if (node.hasChild(Coordinate.class)) {
            return this.gFactory.createPoint((Coordinate)node.getChildValue(Coordinate.class));
        }
        if (node.hasChild(CoordinateSequence.class)) {
            return this.gFactory.createPoint((CoordinateSequence)node.getChildValue(CoordinateSequence.class));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        Geometry geometry = (Geometry)object;
        if (geometry.isEmpty()) {
            return null;
        }
        if ("pos".equals(name.getLocalPart())) {
            Point point = (Point)object;
            return point.getCoordinateSequence();
        }
        return null;
    }
}

