/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSDFacetImpl
extends XSDComponentImpl
implements XSDFacet {
    protected static final String LEXICAL_VALUE_EDEFAULT = null;
    protected String lexicalValue = LEXICAL_VALUE_EDEFAULT;
    protected static final String FACET_NAME_EDEFAULT = null;
    protected static final Object EFFECTIVE_VALUE_EDEFAULT = null;
    protected XSDAnnotation annotation;

    protected XSDFacetImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_FACET;
    }

    @Override
    public String getLexicalValue() {
        return this.lexicalValue;
    }

    @Override
    public void setLexicalValue(String newLexicalValue) {
        String oldLexicalValue = this.lexicalValue;
        this.lexicalValue = newLexicalValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldLexicalValue, (Object)this.lexicalValue));
        }
    }

    @Override
    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkComplexContent("annotated", "http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement);
        }
        this.validateValue();
    }

    protected void validateValue() {
    }

    @Override
    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement.hasAttributeNS(null, "value")) {
            String newLexicalValue = changedElement.getAttributeNS(null, "value");
            if (newLexicalValue == null || !newLexicalValue.equals(this.getLexicalValue())) {
                this.setLexicalValue(newLexicalValue);
            }
        } else if (this.getLexicalValue() != null) {
            this.setLexicalValue(null);
        }
    }

    @Override
    protected void handleUnreconciledElement(Element child, List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        if (XSDConstants.nodeType(child) == 1) {
            XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
            newContents.add(xsdAnnotation);
        }
    }

    @Override
    protected void handleReconciliation(List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.Literals.XSD_FACET__ANNOTATION, newContents, remainingContents);
    }

    @Override
    protected void changeAttribute(EAttribute eAttribute) {
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (theElement != null && (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE)) {
            this.niceSetAttribute(theElement, "value", this.getLexicalValue());
        }
    }

    @Override
    public String getFacetName() {
        String name = this.eClass().getName();
        return String.valueOf(Character.toLowerCase(name.charAt(3))) + name.substring(4, name.length() - 5);
    }

    @Override
    public Object getEffectiveValue() {
        return null;
    }

    @Override
    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)((Object)this.annotation)).eInverseRemove(this, -9, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)((Object)newAnnotation)).eInverseAdd(this, -9, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    @Override
    public XSDSimpleTypeDefinition getSimpleTypeDefinition() {
        XSDConcreteComponent result = this.getContainer();
        return result instanceof XSDSimpleTypeDefinition ? (XSDSimpleTypeDefinition)result : null;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return this.basicSetAnnotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (lexicalValue: ");
        result.append(this.lexicalValue);
        result.append(')');
        return result.toString();
    }
}

