/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.interpolators;

import it.geosolutions.jaiext.interpolators.InterpolationNoData;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RasterAccessor;
import javax.media.jai.iterator.RandomIter;

public class InterpolationBicubic
extends InterpolationTable
implements InterpolationNoData {
    private static final long serialVersionUID = -3699824574811467489L;
    public static final int PRECISION_BITS = 8;
    private int round;
    private Range noDataRange;
    private Rectangle roiBounds;
    private boolean useROIAccessor;
    private double destinationNoData;
    private int black;
    private int dataType;
    private boolean isNotPointRange;
    private boolean isBicubic2;

    public InterpolationBicubic(int subsampleBits, Range noDataRange, boolean useROIAccessor, double destinationNoData, int dataType, boolean bicubic2Disabled, int precisionBits) {
        super(1, 1, 4, 4, subsampleBits, subsampleBits, precisionBits, InterpolationBicubic.dataHelper(subsampleBits, bicubic2Disabled), (float[])null);
        if (noDataRange != null) {
            this.noDataRange = noDataRange;
            this.isNotPointRange = !noDataRange.isPoint();
        }
        this.useROIAccessor = useROIAccessor;
        this.destinationNoData = destinationNoData;
        this.black = (int)destinationNoData & 1;
        this.dataType = dataType;
        if (precisionBits > 0) {
            this.round = 1 << precisionBits - 1;
        }
        this.isBicubic2 = !bicubic2Disabled;
    }

    public void setROIBounds(Rectangle roiBounds) {
        this.roiBounds = roiBounds;
    }

    public double getDestinationNoData() {
        return this.destinationNoData;
    }

    public void setDestinationNoData(double destinationNoData) {
        this.destinationNoData = destinationNoData;
    }

    public Range getNoDataRange() {
        return this.noDataRange;
    }

    public void setNoDataRange(Range noDataRange) {
        if (noDataRange != null) {
            this.noDataRange = noDataRange;
            this.isNotPointRange = !noDataRange.isPoint();
        }
    }

    public boolean getUseROIAccessor() {
        return this.useROIAccessor;
    }

    public void setUseROIAccessor(boolean useROIAccessor) {
        this.useROIAccessor = useROIAccessor;
    }

    public boolean isBicubic2() {
        return this.isBicubic2;
    }

    public int getDataType() {
        return this.dataType;
    }

    public static float[] dataHelper(int subsampleBits, boolean bicubic2Disabled) {
        int one = 1 << subsampleBits;
        int arrayLength = one * 4;
        float[] tableValues = new float[arrayLength];
        float onef = one;
        int count = 0;
        for (int i = 0; i < one; ++i) {
            float f = (float)i / onef;
            tableValues[count++] = InterpolationBicubic.bicubic(f + 1.0f, bicubic2Disabled);
            tableValues[count++] = InterpolationBicubic.bicubic(f, bicubic2Disabled);
            tableValues[count++] = InterpolationBicubic.bicubic(f - 1.0f, bicubic2Disabled);
            tableValues[count++] = InterpolationBicubic.bicubic(f - 2.0f, bicubic2Disabled);
        }
        return tableValues;
    }

    public static float bicubic(float x, boolean bicubic2Disabled) {
        if (x < 0.0f) {
            x = -x;
        }
        float A = 0.0f;
        A = bicubic2Disabled ? -0.5f : -1.0f;
        float A3 = A + 2.0f;
        float A2 = -(A + 3.0f);
        float A0 = 1.0f;
        float B3 = A;
        float B2 = -(5.0f * A);
        float B1 = 8.0f * A;
        float B0 = -(4.0f * A);
        if (x >= 1.0f) {
            return ((B3 * x + B2) * x + B1) * x + B0;
        }
        return (A3 * x + A2) * x * x + A0;
    }

    public Number interpolate(RasterAccessor src, int bandIndex, int dnumbands, int posx, int posy, Number[] fracValues, Integer yValueROI, RasterAccessor roi, RandomIter roiIter, boolean setNoData) {
        int j;
        int i;
        int i2;
        if (setNoData) {
            return this.destinationNoData;
        }
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int posxlow = posx - srcPixelStride;
        int posxhigh = posx + srcPixelStride;
        int posxhigh2 = posxhigh + srcPixelStride;
        int posylow = posy - srcScanlineStride;
        int posyhigh = posy + srcScanlineStride;
        int posyhigh2 = posyhigh + srcScanlineStride;
        int s__ = 0;
        int s_0 = 0;
        int s_1 = 0;
        int s_2 = 0;
        int s0_ = 0;
        int s00 = 0;
        int s01 = 0;
        int s02 = 0;
        int s1_ = 0;
        int s10 = 0;
        int s11 = 0;
        int s12 = 0;
        int s2_ = 0;
        int s20 = 0;
        int s21 = 0;
        int s22 = 0;
        float s__f = 0.0f;
        float s_0f = 0.0f;
        float s_1f = 0.0f;
        float s_2f = 0.0f;
        float s0_f = 0.0f;
        float s00f = 0.0f;
        float s01f = 0.0f;
        float s02f = 0.0f;
        float s1_f = 0.0f;
        float s10f = 0.0f;
        float s11f = 0.0f;
        float s12f = 0.0f;
        float s2_f = 0.0f;
        float s20f = 0.0f;
        float s21f = 0.0f;
        float s22f = 0.0f;
        double s__d = 0.0;
        double s_0d = 0.0;
        double s_1d = 0.0;
        double s_2d = 0.0;
        double s0_d = 0.0;
        double s00d = 0.0;
        double s01d = 0.0;
        double s02d = 0.0;
        double s1_d = 0.0;
        double s10d = 0.0;
        double s11d = 0.0;
        double s12d = 0.0;
        double s2_d = 0.0;
        double s20d = 0.0;
        double s21d = 0.0;
        double s22d = 0.0;
        int xfrac = 0;
        int yfrac = 0;
        int offsetX = 0;
        int offsetY = 0;
        int[][] kernelArray = new int[4][4];
        float[][] kernelArrayF = new float[4][4];
        double[][] kernelArrayD = new double[4][4];
        switch (this.dataType) {
            case 0: {
                byte[] srcDataByte = src.getByteDataArray(bandIndex);
                kernelArray[0][0] = s__ = srcDataByte[posxlow + posylow] & 0xFF;
                kernelArray[0][1] = s_0 = srcDataByte[posx + posylow] & 0xFF;
                kernelArray[0][2] = s_1 = srcDataByte[posxhigh + posylow] & 0xFF;
                kernelArray[0][3] = s_2 = srcDataByte[posxhigh2 + posylow] & 0xFF;
                kernelArray[1][0] = s0_ = srcDataByte[posxlow + posy] & 0xFF;
                kernelArray[1][1] = s00 = srcDataByte[posx + posy] & 0xFF;
                kernelArray[1][2] = s01 = srcDataByte[posxhigh + posy] & 0xFF;
                kernelArray[1][3] = s02 = srcDataByte[posxhigh2 + posy] & 0xFF;
                kernelArray[2][0] = s1_ = srcDataByte[posxlow + posyhigh] & 0xFF;
                kernelArray[2][1] = s10 = srcDataByte[posx + posyhigh] & 0xFF;
                kernelArray[2][2] = s11 = srcDataByte[posxhigh + posyhigh] & 0xFF;
                kernelArray[2][3] = s12 = srcDataByte[posxhigh2 + posyhigh] & 0xFF;
                kernelArray[3][0] = s2_ = srcDataByte[posxlow + posyhigh2] & 0xFF;
                kernelArray[3][1] = s20 = srcDataByte[posx + posyhigh2] & 0xFF;
                kernelArray[3][2] = s21 = srcDataByte[posxhigh + posyhigh2] & 0xFF;
                kernelArray[3][3] = s22 = srcDataByte[posxhigh2 + posyhigh2] & 0xFF;
                xfrac = fracValues[0].intValue();
                yfrac = fracValues[1].intValue();
                offsetX = 4 * xfrac;
                offsetY = 4 * yfrac;
                break;
            }
            case 1: {
                short[] srcDataShort = src.getShortDataArray(bandIndex);
                kernelArray[0][0] = s__ = srcDataShort[posxlow + posylow] & 0xFFFF;
                kernelArray[0][1] = s_0 = srcDataShort[posx + posylow] & 0xFFFF;
                kernelArray[0][2] = s_1 = srcDataShort[posxhigh + posylow] & 0xFFFF;
                kernelArray[0][3] = s_2 = srcDataShort[posxhigh2 + posylow] & 0xFFFF;
                kernelArray[1][0] = s0_ = srcDataShort[posxlow + posy] & 0xFFFF;
                kernelArray[1][1] = s00 = srcDataShort[posx + posy] & 0xFFFF;
                kernelArray[1][2] = s01 = srcDataShort[posxhigh + posy] & 0xFFFF;
                kernelArray[1][3] = s02 = srcDataShort[posxhigh2 + posy] & 0xFFFF;
                kernelArray[2][0] = s1_ = srcDataShort[posxlow + posyhigh] & 0xFFFF;
                kernelArray[2][1] = s10 = srcDataShort[posx + posyhigh] & 0xFFFF;
                kernelArray[2][2] = s11 = srcDataShort[posxhigh + posyhigh] & 0xFFFF;
                kernelArray[2][3] = s12 = srcDataShort[posxhigh2 + posyhigh] & 0xFFFF;
                kernelArray[3][0] = s2_ = srcDataShort[posxlow + posyhigh2] & 0xFFFF;
                kernelArray[3][1] = s20 = srcDataShort[posx + posyhigh2] & 0xFFFF;
                kernelArray[3][2] = s21 = srcDataShort[posxhigh + posyhigh2] & 0xFFFF;
                kernelArray[3][3] = s22 = srcDataShort[posxhigh2 + posyhigh2] & 0xFFFF;
                xfrac = fracValues[0].intValue();
                yfrac = fracValues[1].intValue();
                offsetX = 4 * xfrac;
                offsetY = 4 * yfrac;
                break;
            }
            case 2: {
                short[] srcDataShort = src.getShortDataArray(bandIndex);
                kernelArray[0][0] = s__ = srcDataShort[posxlow + posylow];
                kernelArray[0][1] = s_0 = srcDataShort[posx + posylow];
                kernelArray[0][2] = s_1 = srcDataShort[posxhigh + posylow];
                kernelArray[0][3] = s_2 = srcDataShort[posxhigh2 + posylow];
                kernelArray[1][0] = s0_ = srcDataShort[posxlow + posy];
                kernelArray[1][1] = s00 = srcDataShort[posx + posy];
                kernelArray[1][2] = s01 = srcDataShort[posxhigh + posy];
                kernelArray[1][3] = s02 = srcDataShort[posxhigh2 + posy];
                kernelArray[2][0] = s1_ = srcDataShort[posxlow + posyhigh];
                kernelArray[2][1] = s10 = srcDataShort[posx + posyhigh];
                kernelArray[2][2] = s11 = srcDataShort[posxhigh + posyhigh];
                kernelArray[2][3] = s12 = srcDataShort[posxhigh2 + posyhigh];
                kernelArray[3][0] = s2_ = srcDataShort[posxlow + posyhigh2];
                kernelArray[3][1] = s20 = srcDataShort[posx + posyhigh2];
                kernelArray[3][2] = s21 = srcDataShort[posxhigh + posyhigh2];
                kernelArray[3][3] = s22 = srcDataShort[posxhigh2 + posyhigh2];
                xfrac = fracValues[0].intValue();
                yfrac = fracValues[1].intValue();
                offsetX = 4 * xfrac;
                offsetY = 4 * yfrac;
                break;
            }
            case 3: {
                int[] srcDataInt = src.getIntDataArray(bandIndex);
                kernelArray[0][0] = s__ = srcDataInt[posxlow + posylow];
                kernelArray[0][1] = s_0 = srcDataInt[posx + posylow];
                kernelArray[0][2] = s_1 = srcDataInt[posxhigh + posylow];
                kernelArray[0][3] = s_2 = srcDataInt[posxhigh2 + posylow];
                kernelArray[1][0] = s0_ = srcDataInt[posxlow + posy];
                kernelArray[1][1] = s00 = srcDataInt[posx + posy];
                kernelArray[1][2] = s01 = srcDataInt[posxhigh + posy];
                kernelArray[1][3] = s02 = srcDataInt[posxhigh2 + posy];
                kernelArray[2][0] = s1_ = srcDataInt[posxlow + posyhigh];
                kernelArray[2][1] = s10 = srcDataInt[posx + posyhigh];
                kernelArray[2][2] = s11 = srcDataInt[posxhigh + posyhigh];
                kernelArray[2][3] = s12 = srcDataInt[posxhigh2 + posyhigh];
                kernelArray[3][0] = s2_ = srcDataInt[posxlow + posyhigh2];
                kernelArray[3][1] = s20 = srcDataInt[posx + posyhigh2];
                kernelArray[3][2] = s21 = srcDataInt[posxhigh + posyhigh2];
                kernelArray[3][3] = s22 = srcDataInt[posxhigh2 + posyhigh2];
                long xfracL = fracValues[0].longValue();
                long yfracL = fracValues[1].longValue();
                offsetX = (int)(4L * xfracL);
                offsetY = (int)(4L * yfracL);
                break;
            }
            case 4: {
                float[] srcDataFloat = src.getFloatDataArray(bandIndex);
                kernelArrayF[0][0] = s__f = srcDataFloat[posxlow + posylow];
                kernelArrayF[0][1] = s_0f = srcDataFloat[posx + posylow];
                kernelArrayF[0][2] = s_1f = srcDataFloat[posxhigh + posylow];
                kernelArrayF[0][3] = s_2f = srcDataFloat[posxhigh2 + posylow];
                kernelArrayF[1][0] = s0_f = srcDataFloat[posxlow + posy];
                kernelArrayF[1][1] = s00f = srcDataFloat[posx + posy];
                kernelArrayF[1][2] = s01f = srcDataFloat[posxhigh + posy];
                kernelArrayF[1][3] = s02f = srcDataFloat[posxhigh2 + posy];
                kernelArrayF[2][0] = s1_f = srcDataFloat[posxlow + posyhigh];
                kernelArrayF[2][1] = s10f = srcDataFloat[posx + posyhigh];
                kernelArrayF[2][2] = s11f = srcDataFloat[posxhigh + posyhigh];
                kernelArrayF[2][3] = s12f = srcDataFloat[posxhigh2 + posyhigh];
                kernelArrayF[3][0] = s2_f = srcDataFloat[posxlow + posyhigh2];
                kernelArrayF[3][1] = s20f = srcDataFloat[posx + posyhigh2];
                kernelArrayF[3][2] = s21f = srcDataFloat[posxhigh + posyhigh2];
                kernelArrayF[3][3] = s22f = srcDataFloat[posxhigh2 + posyhigh2];
                xfrac = (int)(fracValues[0].floatValue() * (float)this.subsampleBitsH);
                yfrac = (int)(fracValues[1].floatValue() * (float)this.subsampleBitsH);
                offsetX = 4 * xfrac;
                offsetY = 4 * yfrac;
                break;
            }
            case 5: {
                double[] srcDataDouble = src.getDoubleDataArray(bandIndex);
                kernelArrayD[0][0] = s__d = srcDataDouble[posxlow + posylow];
                kernelArrayD[0][1] = s_0d = srcDataDouble[posx + posylow];
                kernelArrayD[0][2] = s_1d = srcDataDouble[posxhigh + posylow];
                kernelArrayD[0][3] = s_2d = srcDataDouble[posxhigh2 + posylow];
                kernelArrayD[1][0] = s0_d = srcDataDouble[posxlow + posy];
                kernelArrayD[1][1] = s00d = srcDataDouble[posx + posy];
                kernelArrayD[1][2] = s01d = srcDataDouble[posxhigh + posy];
                kernelArrayD[1][3] = s02d = srcDataDouble[posxhigh2 + posy];
                kernelArrayD[2][0] = s1_d = srcDataDouble[posxlow + posyhigh];
                kernelArrayD[2][1] = s10d = srcDataDouble[posx + posyhigh];
                kernelArrayD[2][2] = s11d = srcDataDouble[posxhigh + posyhigh];
                kernelArrayD[2][3] = s12d = srcDataDouble[posxhigh2 + posyhigh];
                kernelArrayD[3][0] = s2_d = srcDataDouble[posxlow + posyhigh2];
                kernelArrayD[3][1] = s20d = srcDataDouble[posx + posyhigh2];
                kernelArrayD[3][2] = s21d = srcDataDouble[posxhigh + posyhigh2];
                kernelArrayD[3][3] = s22d = srcDataDouble[posxhigh2 + posyhigh2];
                xfrac = (int)(fracValues[0].doubleValue() * (double)this.subsampleBitsH);
                yfrac = (int)(fracValues[1].doubleValue() * (double)this.subsampleBitsH);
                offsetX = 4 * xfrac;
                offsetY = 4 * yfrac;
                break;
            }
        }
        double[][] weightArray = new double[4][4];
        int weightArrayLength = weightArray.length;
        byte tempValueB = 0;
        short tempValueS = 0;
        double tempValueD = 0.0;
        if (this.useROIAccessor) {
            if (yValueROI == null || roi == null) {
                throw new IllegalArgumentException("If rasterAccessor is set, ROI value must be provided");
            }
            int roiScanLineStride = roi.getScanlineStride();
            int[][] weightArrayIndex = new int[4][4];
            int baseIndex = posx / dnumbands + yValueROI;
            for (i2 = 0; i2 < weightArrayIndex.length; ++i2) {
                for (int j2 = 0; j2 < weightArrayIndex.length; ++j2) {
                    weightArrayIndex[i2][j2] = baseIndex - 1 + j2 + (i2 - 1) * roiScanLineStride;
                }
            }
            int roiDataLength = 0;
            byte[] roiDataArrayByte = roi.getByteDataArray(0);
            roiDataLength = roiDataArrayByte.length;
            if (baseIndex > roiDataLength || roiDataArrayByte[baseIndex] == 0) {
                return this.destinationNoData;
            }
            switch (this.dataType) {
                case 0: {
                    for (i = 0; i < weightArrayIndex.length; ++i) {
                        for (j = 0; j < weightArrayIndex.length; ++j) {
                            if (weightArrayIndex[i][j] < roiDataLength) {
                                tempValueB = (byte)(roiDataArrayByte[weightArrayIndex[i][j]] & 0xFF);
                                weightArray[i][j] = tempValueB != 0 ? 1 : 0;
                                continue;
                            }
                            weightArray[i][j] = 0.0;
                        }
                    }
                    break;
                }
                case 1: {
                    for (i = 0; i < weightArrayIndex.length; ++i) {
                        for (j = 0; j < weightArrayIndex.length; ++j) {
                            if (weightArrayIndex[i][j] < roiDataLength) {
                                tempValueS = (short)(roiDataArrayByte[weightArrayIndex[i][j]] & 0xFFFF);
                                weightArray[i][j] = tempValueS != 0 ? 1 : 0;
                                continue;
                            }
                            weightArray[i][j] = 0.0;
                        }
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    for (i = 0; i < weightArrayIndex.length; ++i) {
                        for (j = 0; j < weightArrayIndex.length; ++j) {
                            if (weightArrayIndex[i][j] < roiDataLength) {
                                tempValueD = roiDataArrayByte[weightArrayIndex[i][j]];
                                weightArray[i][j] = tempValueD != 0.0 ? 1 : 0;
                                continue;
                            }
                            weightArray[i][j] = 0.0;
                        }
                    }
                    break;
                }
            }
            if (this.sumZero(weightArray) == 0.0) {
                return this.destinationNoData;
            }
        } else if (this.roiBounds != null) {
            int y0;
            int srcBandOffset = src.getBandOffset(bandIndex);
            int x0 = src.getX() + posx / srcPixelStride;
            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - srcBandOffset) / srcScanlineStride)) {
                switch (this.dataType) {
                    case 0: {
                        int j3;
                        for (i2 = 0; i2 < weightArray.length; ++i2) {
                            for (j3 = 0; j3 < weightArray.length; ++j3) {
                                tempValueB = (byte)(roiIter.getSample(x0 + j3 - 1, y0 + i2 - 1, 0) & 0xFF);
                                weightArray[i2][j3] = tempValueB != 0 ? 1 : 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        int j3;
                        for (i2 = 0; i2 < weightArray.length; ++i2) {
                            for (j3 = 0; j3 < weightArray.length; ++j3) {
                                tempValueS = (short)(roiIter.getSample(x0 + j3 - 1, y0 + i2 - 1, 0) & 0xFFFF);
                                weightArray[i2][j3] = tempValueS != 0 ? 1 : 0;
                            }
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int j3;
                        for (i2 = 0; i2 < weightArray.length; ++i2) {
                            for (j3 = 0; j3 < weightArray.length; ++j3) {
                                tempValueD = roiIter.getSample(x0 + j3 - 1, y0 + i2 - 1, 0);
                                weightArray[i2][j3] = tempValueD != 0.0 ? 1 : 0;
                            }
                        }
                        break;
                    }
                }
                if (this.sumZero(weightArray) == 0.0) {
                    return this.destinationNoData;
                }
            } else {
                return this.destinationNoData;
            }
        }
        for (int i3 = 0; i3 < weightArrayLength; ++i3) {
            for (int j4 = 0; j4 < weightArrayLength; ++j4) {
                weightArray[i3][j4] = 1.0;
            }
        }
        if (this.noDataRange != null) {
            switch (this.dataType) {
                case 0: {
                    Range rangeB = this.noDataRange;
                    for (int i4 = 0; i4 < weightArrayLength; ++i4) {
                        for (int j5 = 0; j5 < weightArrayLength; ++j5) {
                            if (!rangeB.contains((byte)kernelArray[i4][j5])) continue;
                            double[] dArray = weightArray[i4];
                            int n = j5;
                            dArray[n] = dArray[n] * 0.0;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    Range rangeS = this.noDataRange;
                    for (int i5 = 0; i5 < weightArrayLength; ++i5) {
                        for (int j6 = 0; j6 < weightArrayLength; ++j6) {
                            if (!rangeS.contains((short)kernelArray[i5][j6])) continue;
                            double[] dArray = weightArray[i5];
                            int n = j6;
                            dArray[n] = dArray[n] * 0.0;
                        }
                    }
                    break;
                }
                case 3: {
                    Range rangeI = this.noDataRange;
                    for (i2 = 0; i2 < weightArrayLength; ++i2) {
                        for (int j7 = 0; j7 < weightArrayLength; ++j7) {
                            if (!rangeI.contains(kernelArray[i2][j7])) continue;
                            double[] dArray = weightArray[i2];
                            int n = j7;
                            dArray[n] = dArray[n] * 0.0;
                        }
                    }
                    break;
                }
                case 4: {
                    Range rangeF = this.noDataRange;
                    for (int i6 = 0; i6 < weightArrayLength; ++i6) {
                        for (int j8 = 0; j8 < weightArrayLength; ++j8) {
                            if (!rangeF.contains(kernelArrayF[i6][j8]) && (!this.isNotPointRange || !Float.isNaN(kernelArrayF[i6][j8]))) continue;
                            double[] dArray = weightArray[i6];
                            int n = j8;
                            dArray[n] = dArray[n] * 0.0;
                        }
                    }
                    break;
                }
                case 5: {
                    Range rangeD = this.noDataRange;
                    for (i = 0; i < weightArrayLength; ++i) {
                        for (j = 0; j < weightArrayLength; ++j) {
                            if (!rangeD.contains(kernelArrayD[i][j]) && (!this.isNotPointRange || !Double.isNaN(kernelArrayD[i][j]))) continue;
                            double[] dArray = weightArray[i];
                            int n = j;
                            dArray[n] = dArray[n] * 0.0;
                        }
                    }
                    break;
                }
            }
        }
        if (this.sumZero(weightArray) == 0.0) {
            return this.destinationNoData;
        }
        long sum = 0L;
        double sumd = 0.0;
        int offsetX1 = offsetX + 1;
        int offsetX2 = offsetX + 2;
        int offsetX3 = offsetX + 3;
        int offsetY1 = offsetY + 1;
        int offsetY2 = offsetY + 2;
        int offsetY3 = offsetY + 3;
        boolean[] weight0 = new boolean[4];
        for (int ii = 0; ii < 4; ++ii) {
            double[][] lineArray = new double[][]{weightArray[ii]};
            weight0[ii] = this.sumZero(lineArray) == 0.0;
        }
        switch (this.dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                long[] valueArray_ = this.bicubicInpainting(s__, s_0, s_1, s_2, weightArray[0], null);
                long[] valueArray0 = this.bicubicInpainting(s0_, s00, s01, s02, weightArray[1], null);
                long[] valueArray1 = this.bicubicInpainting(s1_, s10, s11, s12, weightArray[2], null);
                long[] valueArray2 = this.bicubicInpainting(s2_, s20, s21, s22, weightArray[3], null);
                long sum_ = (long)this.dataHi[offsetX] * valueArray_[0];
                sum_ += (long)this.dataHi[offsetX1] * valueArray_[1];
                sum_ += (long)this.dataHi[offsetX2] * valueArray_[2];
                sum_ += (long)this.dataHi[offsetX3] * valueArray_[3];
                long sum0 = (long)this.dataHi[offsetX] * valueArray0[0];
                sum0 += (long)this.dataHi[offsetX1] * valueArray0[1];
                sum0 += (long)this.dataHi[offsetX2] * valueArray0[2];
                sum0 += (long)this.dataHi[offsetX3] * valueArray0[3];
                long sum1 = (long)this.dataHi[offsetX] * valueArray1[0];
                sum1 += (long)this.dataHi[offsetX1] * valueArray1[1];
                sum1 += (long)this.dataHi[offsetX2] * valueArray1[2];
                sum1 += (long)this.dataHi[offsetX3] * valueArray1[3];
                long sum2 = (long)this.dataHi[offsetX] * valueArray2[0];
                sum2 += (long)this.dataHi[offsetX1] * valueArray2[1];
                sum2 += (long)this.dataHi[offsetX2] * valueArray2[2];
                sum2 += (long)this.dataHi[offsetX3] * valueArray2[3];
                sum_ = sum_ + (long)this.round >> this.precisionBits;
                sum0 = sum0 + (long)this.round >> this.precisionBits;
                sum1 = sum1 + (long)this.round >> this.precisionBits;
                sum2 = sum2 + (long)this.round >> this.precisionBits;
                long[] valueArrayV = this.bicubicInpainting(sum_, sum0, sum1, sum2, null, weight0);
                sum = (long)this.dataVi[offsetY] * valueArrayV[0];
                sum += (long)this.dataVi[offsetY1] * valueArrayV[1];
                sum += (long)this.dataVi[offsetY2] * valueArrayV[2];
                sum += (long)this.dataVi[offsetY3] * valueArrayV[3];
                break;
            }
            case 4: {
                float[] valueArrayf_ = this.bicubicInpaintingFloat(s__f, s_0f, s_1f, s_2f, weightArray[0], null);
                float[] valueArrayf0 = this.bicubicInpaintingFloat(s0_f, s00f, s01f, s02f, weightArray[1], null);
                float[] valueArrayf1 = this.bicubicInpaintingFloat(s1_f, s10f, s11f, s12f, weightArray[2], null);
                float[] valueArrayf2 = this.bicubicInpaintingFloat(s2_f, s20f, s21f, s22f, weightArray[3], null);
                double sum_f = this.dataHf[offsetX] * valueArrayf_[0];
                sum_f += (double)(this.dataHf[offsetX1] * valueArrayf_[1]);
                sum_f += (double)(this.dataHf[offsetX2] * valueArrayf_[2]);
                sum_f += (double)(this.dataHf[offsetX3] * valueArrayf_[3]);
                double sum0f = this.dataHf[offsetX] * valueArrayf0[0];
                sum0f += (double)(this.dataHf[offsetX1] * valueArrayf0[1]);
                sum0f += (double)(this.dataHf[offsetX2] * valueArrayf0[2]);
                sum0f += (double)(this.dataHf[offsetX3] * valueArrayf0[3]);
                double sum1f = this.dataHf[offsetX] * valueArrayf1[0];
                sum1f += (double)(this.dataHf[offsetX1] * valueArrayf1[1]);
                sum1f += (double)(this.dataHf[offsetX2] * valueArrayf1[2]);
                double sum2f = this.dataHf[offsetX] * valueArrayf2[0];
                sum2f += (double)(this.dataHf[offsetX1] * valueArrayf2[1]);
                sum2f += (double)(this.dataHf[offsetX2] * valueArrayf2[2]);
                double[] valueArrayVf = this.bicubicInpaintingDouble(sum_f, sum0f, sum1f += (double)(this.dataHf[offsetX3] * valueArrayf1[3]), sum2f += (double)(this.dataHf[offsetX3] * valueArrayf2[3]), null, weight0);
                sumd = (double)this.dataVf[offsetY] * valueArrayVf[0];
                sumd += (double)this.dataVf[offsetY + 1] * valueArrayVf[1];
                sumd += (double)this.dataVf[offsetY + 2] * valueArrayVf[2];
                sumd += (double)this.dataVf[offsetY + 3] * valueArrayVf[3];
                if (sumd > 3.4028234663852886E38) {
                    sumd = 3.4028234663852886E38;
                } else if (sumd < -3.4028234663852886E38) {
                    sumd = -3.4028234663852886E38;
                }
                return sumd;
            }
            case 5: {
                double[] valueArrayd_ = this.bicubicInpaintingDouble(s__d, s_0d, s_1d, s_2d, weightArray[0], null);
                double[] valueArrayd0 = this.bicubicInpaintingDouble(s0_d, s00d, s01d, s02d, weightArray[0], null);
                double[] valueArrayd1 = this.bicubicInpaintingDouble(s1_d, s10d, s11d, s12d, weightArray[0], null);
                double[] valueArrayd2 = this.bicubicInpaintingDouble(s2_d, s20d, s21d, s22d, weightArray[0], null);
                double sum_d = this.dataHd[offsetX] * valueArrayd_[0];
                sum_d += this.dataHd[offsetX1] * valueArrayd_[1];
                sum_d += this.dataHd[offsetX2] * valueArrayd_[2];
                sum_d += this.dataHd[offsetX3] * valueArrayd_[3];
                double sum0d = this.dataHd[offsetX] * valueArrayd0[0];
                sum0d += this.dataHd[offsetX1] * valueArrayd0[1];
                sum0d += this.dataHd[offsetX2] * valueArrayd0[2];
                sum0d += this.dataHd[offsetX3] * valueArrayd0[3];
                double sum1d = this.dataHd[offsetX] * valueArrayd1[0];
                sum1d += this.dataHd[offsetX1] * valueArrayd1[1];
                sum1d += this.dataHd[offsetX2] * valueArrayd1[2];
                double sum2d = this.dataHd[offsetX] * valueArrayd2[0];
                sum2d += this.dataHd[offsetX1] * valueArrayd2[1];
                sum2d += this.dataHd[offsetX2] * valueArrayd2[2];
                double[] valueArrayVd = this.bicubicInpaintingDouble(sum_d, sum0d, sum1d += this.dataHd[offsetX3] * valueArrayd1[3], sum2d += this.dataHd[offsetX3] * valueArrayd2[3], null, weight0);
                sumd = this.dataVd[offsetY] * valueArrayVd[0];
                sumd += this.dataVd[offsetY + 1] * valueArrayVd[1];
                sumd += this.dataVd[offsetY + 2] * valueArrayVd[2];
                return sumd += this.dataVd[offsetY + 3] * valueArrayVd[3];
            }
        }
        int s = (int)(sum + (long)this.round >> this.precisionBits);
        switch (this.dataType) {
            case 0: {
                if (s > 255) {
                    s = 255;
                    break;
                }
                if (s >= 0) break;
                s = 0;
                break;
            }
            case 1: {
                if (s > 65536) {
                    s = 65536;
                    break;
                }
                if (s >= 0) break;
                s = 0;
                break;
            }
            case 2: {
                if (s > Short.MAX_VALUE) {
                    s = Short.MAX_VALUE;
                    break;
                }
                if (s >= Short.MIN_VALUE) break;
                s = Short.MIN_VALUE;
                break;
            }
        }
        return s;
    }

    private long[] bicubicInpainting(long s_, long s0, long s1, long s2, double[] weightArray, boolean[] weight0) {
        if (weightArray == null) {
            weightArray = new double[]{s_ == 0L && weight0[0] ? 0.0 : 1.0, s0 == 0L && weight0[1] ? 0.0 : 1.0, s1 == 0L && weight0[2] ? 0.0 : 1.0, s2 == 0L && weight0[3] ? 0.0 : 1.0};
        }
        double[][] array = new double[][]{weightArray};
        long[] emptyArray = new long[4];
        int sum = (int)this.sumZero(array);
        long meanValue = 0L;
        switch (sum) {
            case 0: {
                return emptyArray;
            }
            case 1: {
                long validData = 0L;
                validData = weightArray[0] == 1.0 ? s_ : (weightArray[1] == 1.0 ? s0 : (weightArray[2] == 1.0 ? s1 : s2));
                emptyArray[0] = validData;
                emptyArray[1] = validData;
                emptyArray[2] = validData;
                emptyArray[3] = validData;
                return emptyArray;
            }
            case 2: {
                if (weightArray[0] == 0.0 && weightArray[1] == 0.0) {
                    emptyArray[0] = s1;
                    emptyArray[1] = s1;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0.0 && weightArray[2] == 0.0) {
                    meanValue = (s0 + s2) / 2L;
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0.0 && weightArray[3] == 0.0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else if (weightArray[1] == 0.0 && weightArray[2] == 0.0) {
                    meanValue = (s_ + s2) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0.0 && weightArray[3] == 0.0) {
                    meanValue = (s_ + s1) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s0;
                    emptyArray[3] = s0;
                }
                return emptyArray;
            }
            case 3: {
                if (weightArray[0] == 0.0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0.0) {
                    meanValue = (s_ + s1) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[2] == 0.0) {
                    meanValue = (s0 + s2) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                }
                return emptyArray;
            }
            case 4: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                return emptyArray;
            }
        }
        throw new IllegalArgumentException("The input array cannot have more than 4 pixels");
    }

    private float[] bicubicInpaintingFloat(float s_, float s0, float s1, float s2, double[] weightArray, boolean[] weight0) {
        if (weightArray == null) {
            weightArray = new double[]{s_ == 0.0f && weight0[0] ? 0.0 : 1.0, s0 == 0.0f && weight0[1] ? 0.0 : 1.0, s1 == 0.0f && weight0[2] ? 0.0 : 1.0, s2 == 0.0f && weight0[3] ? 0.0 : 1.0};
        }
        double[][] array = new double[][]{weightArray};
        float[] emptyArray = new float[4];
        int sum = (int)this.sumZero(array);
        float meanValue = 0.0f;
        switch (sum) {
            case 0: {
                return emptyArray;
            }
            case 1: {
                float validData = 0.0f;
                validData = weightArray[0] == 1.0 ? s_ : (weightArray[1] == 1.0 ? s0 : (weightArray[2] == 1.0 ? s1 : s2));
                emptyArray[0] = validData;
                emptyArray[1] = validData;
                emptyArray[2] = validData;
                emptyArray[3] = validData;
                return emptyArray;
            }
            case 2: {
                if (weightArray[0] == 0.0 && weightArray[1] == 0.0) {
                    emptyArray[0] = s1;
                    emptyArray[1] = s1;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0.0 && weightArray[2] == 0.0) {
                    meanValue = (s0 + s2) / 2.0f;
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0.0 && weightArray[3] == 0.0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else if (weightArray[1] == 0.0 && weightArray[2] == 0.0) {
                    meanValue = (s_ + s2) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0.0 && weightArray[3] == 0.0) {
                    meanValue = (s_ + s1) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s0;
                    emptyArray[3] = s0;
                }
                return emptyArray;
            }
            case 3: {
                if (weightArray[0] == 0.0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0.0) {
                    meanValue = (s_ + s1) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[2] == 0.0) {
                    meanValue = (s0 + s2) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                }
                return emptyArray;
            }
            case 4: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                return emptyArray;
            }
        }
        throw new IllegalArgumentException("The input array cannot have more than 4 pixels");
    }

    private double[] bicubicInpaintingDouble(double s_, double s0, double s1, double s2, double[] weightArray, boolean[] weight0) {
        if (weightArray == null) {
            weightArray = new double[]{s_ == 0.0 && weight0[0] ? 0.0 : 1.0, s0 == 0.0 && weight0[1] ? 0.0 : 1.0, s1 == 0.0 && weight0[2] ? 0.0 : 1.0, s2 == 0.0 && weight0[3] ? 0.0 : 1.0};
        }
        double[][] array = new double[][]{weightArray};
        double[] emptyArray = new double[4];
        int sum = (int)this.sumZero(array);
        double meanValue = 0.0;
        switch (sum) {
            case 0: {
                return emptyArray;
            }
            case 1: {
                double validData = 0.0;
                validData = weightArray[0] == 1.0 ? s_ : (weightArray[1] == 1.0 ? s0 : (weightArray[2] == 1.0 ? s1 : s2));
                emptyArray[0] = validData;
                emptyArray[1] = validData;
                emptyArray[2] = validData;
                emptyArray[3] = validData;
                return emptyArray;
            }
            case 2: {
                if (weightArray[0] == 0.0 && weightArray[1] == 0.0) {
                    emptyArray[0] = s1;
                    emptyArray[1] = s1;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0.0 && weightArray[2] == 0.0) {
                    meanValue = (s0 + s2) / 2.0;
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0.0 && weightArray[3] == 0.0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else if (weightArray[1] == 0.0 && weightArray[2] == 0.0) {
                    meanValue = (s_ + s2) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0.0 && weightArray[3] == 0.0) {
                    meanValue = (s_ + s1) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s0;
                    emptyArray[3] = s0;
                }
                return emptyArray;
            }
            case 3: {
                if (weightArray[0] == 0.0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0.0) {
                    meanValue = (s_ + s1) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[2] == 0.0) {
                    meanValue = (s0 + s2) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                }
                return emptyArray;
            }
            case 4: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                return emptyArray;
            }
        }
        throw new IllegalArgumentException("The input array cannot have more than 4 pixels");
    }

    private double sumZero(double[][] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                sum += values[i][j];
            }
        }
        return sum;
    }

    public int interpolateBinary(int xNextBitNo, Number[] sourceData, int xfrac, int yfrac, int sourceYOffset, int sourceScanlineStride, int[] coordinates, int[] roiDataArray, int roiYOffset, int roiScanlineStride, RandomIter roiIter) {
        int j;
        int i;
        int sum;
        int[][] bitArray = new int[4][4];
        int[] byteshift = null;
        int[] shortshift = null;
        int[] intshift = null;
        int sbitnum = xNextBitNo - 1;
        int xBeforeBitNo = sbitnum - 1;
        int xNextBitNo2 = sbitnum + 2;
        int[] bitshift = new int[4];
        int offsetX = 0;
        int offsetY = 0;
        switch (this.dataType) {
            case 0: {
                int j2;
                int i2;
                byteshift = new int[4];
                bitshift[1] = 7 - (sbitnum & 7);
                byteshift[1] = sbitnum >> 3;
                bitshift[2] = 7 - (xNextBitNo & 7);
                byteshift[2] = xNextBitNo >> 3;
                bitshift[0] = 7 - (xBeforeBitNo & 7);
                byteshift[0] = xBeforeBitNo >> 3;
                bitshift[3] = 7 - (xNextBitNo2 & 7);
                byteshift[3] = xNextBitNo2 >> 3;
                for (i2 = 0; i2 < bitArray.length; ++i2) {
                    for (j2 = 0; j2 < bitArray.length; ++j2) {
                        bitArray[i2][j2] = sourceData[sourceYOffset + (i2 - 1) * sourceScanlineStride + byteshift[j2]].byteValue() >> bitshift[j2] & 1;
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                int j2;
                int i2;
                shortshift = new int[4];
                bitshift[1] = 15 - (sbitnum & 0xF);
                shortshift[1] = sbitnum >> 4;
                bitshift[2] = 15 - (xNextBitNo & 0xF);
                shortshift[2] = xNextBitNo >> 4;
                bitshift[0] = 15 - (xBeforeBitNo & 0xF);
                shortshift[0] = xBeforeBitNo >> 4;
                bitshift[3] = 15 - (xNextBitNo2 & 0xF);
                shortshift[3] = xNextBitNo2 >> 4;
                for (i2 = 0; i2 < bitArray.length; ++i2) {
                    for (j2 = 0; j2 < bitArray.length; ++j2) {
                        bitArray[i2][j2] = sourceData[sourceYOffset + (i2 - 1) * sourceScanlineStride + shortshift[j2]].shortValue() >> bitshift[j2] & 1;
                    }
                }
                break;
            }
            case 3: {
                int j2;
                int i2;
                intshift = new int[4];
                bitshift[1] = 31 - (sbitnum & 0x1F);
                intshift[1] = sbitnum >> 5;
                bitshift[2] = 31 - (xNextBitNo & 0x1F);
                intshift[2] = xNextBitNo >> 5;
                bitshift[0] = 31 - (xBeforeBitNo & 0x1F);
                intshift[0] = xBeforeBitNo >> 5;
                bitshift[3] = 31 - (xNextBitNo2 & 0x1F);
                intshift[3] = xNextBitNo2 >> 5;
                for (i2 = 0; i2 < bitArray.length; ++i2) {
                    for (j2 = 0; j2 < bitArray.length; ++j2) {
                        bitArray[i2][j2] = sourceData[sourceYOffset + (i2 - 1) * sourceScanlineStride + intshift[j2]].intValue() >> bitshift[j2] & 1;
                    }
                }
                break;
            }
        }
        int[][] weightArray = new int[4][4];
        for (int i3 = 0; i3 < weightArray.length; ++i3) {
            for (int j3 = 0; j3 < weightArray.length; ++j3) {
                weightArray[i3][j3] = 1;
            }
        }
        if (this.useROIAccessor) {
            int roiDataLength = roiDataArray.length;
            int[] sbyteShortIntShift = null;
            switch (this.dataType) {
                case 0: {
                    sbyteShortIntShift = byteshift;
                    break;
                }
                case 1: 
                case 2: {
                    sbyteShortIntShift = shortshift;
                    break;
                }
                case 3: {
                    sbyteShortIntShift = intshift;
                }
            }
            sum = 0;
            for (i = 0; i < weightArray.length; ++i) {
                for (j = 0; j < weightArray.length; ++j) {
                    int windex = roiYOffset + sbyteShortIntShift[j] + (i - 1) * roiScanlineStride;
                    if ((windex > roiDataLength || (roiDataArray[windex] >> bitshift[j] & 1) == 0) && i == 1 && j == 1) {
                        return this.black;
                    }
                    weightArray[i][j] = windex < roiDataLength ? roiDataArray[windex] >> bitshift[j] & 1 : 0;
                    sum += weightArray[i][j];
                }
            }
            if (sum == 0) {
                return this.black;
            }
        } else if (coordinates != null && this.roiBounds != null) {
            int x0 = coordinates[0];
            int y0 = coordinates[1];
            if (this.roiBounds.contains(x0, y0)) {
                sum = 0;
                int valueIter = 0;
                for (int i4 = 0; i4 < weightArray.length; ++i4) {
                    for (int j4 = 0; j4 < weightArray.length; ++j4) {
                        valueIter = roiIter.getSample(x0 + j4 - 1, y0 + i4 - 1, 0) & 1;
                        sum += valueIter;
                        weightArray[i4][j4] = valueIter;
                    }
                }
                if (sum == 0) {
                    return this.black;
                }
            } else {
                return this.black;
            }
        }
        long[] sumH = new long[4];
        long sum2 = 0L;
        for (i = 0; i < sumH.length; ++i) {
            sumH[i] = 0L;
            for (j = 0; j < sumH.length; ++j) {
                int n = i;
                sumH[n] = sumH[n] + (long)this.dataHi[offsetX + j] * (long)bitArray[i][j];
            }
            sumH[i] = sumH[i] + (long)this.round >> this.precisionBits;
            sum2 += (long)this.dataVi[offsetY + i] * sumH[i];
        }
        return (int)(sum2 + (long)this.round >> this.precisionBits);
    }
}

