/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.DelaunayEdge;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;

public class PoissonClusterer {
    private static double threshold = 1.0E-10;

    public static Graph findClusters(Graph incoming, Expression base, Expression target, double meanRate, int distance) {
        Collection nodes = incoming.getNodes();
        Iterator nodeIt = nodes.iterator();
        Vector clusterNodes = new Vector();
        Vector clusterEdges = new Vector();
        System.out.println("x, y, actual, expected, probability");
        while (nodeIt.hasNext()) {
            DelaunayNode next = (DelaunayNode)nodeIt.next();
            SimpleFeature nextFeature = next.getFeature();
            Object baseObj = base.evaluate(nextFeature);
            if (!(baseObj instanceof Number)) {
                throw new RuntimeException("Expression " + base + " must evaluate to a number on feature " + nextFeature);
            }
            Object targetObj = target.evaluate(nextFeature);
            if (!(targetObj instanceof Number)) {
                throw new RuntimeException("Expression " + target + " must evaluate to a number on feature " + nextFeature);
            }
            double totalBase = ((Number)baseObj).doubleValue();
            double totalTarget = ((Number)targetObj).doubleValue();
            List newEdges = new Vector();
            Vector<DelaunayNode> newNodes = new Vector<DelaunayNode>();
            newNodes.add(next);
            if (distance == 1) {
                newEdges = next.getEdges();
                Iterator edgeIt = newEdges.iterator();
                Vector<DelaunayEdge> removals = new Vector<DelaunayEdge>();
                while (edgeIt.hasNext()) {
                    DelaunayEdge nextEdge = (DelaunayEdge)edgeIt.next();
                    if (nextEdge.getEuclideanDistance() > 30.0) {
                        removals.add(nextEdge);
                        continue;
                    }
                    DelaunayNode neighbor = (DelaunayNode)nextEdge.getOtherNode(next);
                    if (neighbor == null) {
                        throw new RuntimeException("We have a problem.  " + next + " and " + neighbor + " should be neighbors via " + nextEdge + ", but aren't.");
                    }
                    SimpleFeature neighborFeature = neighbor.getFeature();
                    newNodes.add(neighbor);
                    Object neighborsBaseObj = base.evaluate(nextFeature);
                    if (!(baseObj instanceof Number)) {
                        throw new RuntimeException("Expression " + base + " must evaluate to a number on feature " + neighborFeature);
                    }
                    Object neighborsTargetObj = target.evaluate(nextFeature);
                    if (!(targetObj instanceof Number)) {
                        throw new RuntimeException("Expression " + target + " must evaluate to a number on feature " + neighborFeature);
                    }
                    totalBase += ((Number)baseObj).doubleValue();
                    totalTarget += ((Number)targetObj).doubleValue();
                }
                newEdges.removeAll(removals);
            } else {
                for (int i = 0; i <= distance; ++i) {
                    Iterator nodeIt2 = newNodes.iterator();
                    Vector<DelaunayNode> nodesToAdd = new Vector<DelaunayNode>();
                    Vector<DelaunayEdge> edgesToAdd = new Vector<DelaunayEdge>();
                    while (nodeIt2.hasNext()) {
                        DelaunayNode next2 = (DelaunayNode)nodeIt2.next();
                        List edges = next2.getEdges();
                        newEdges.addAll(edges);
                        for (DelaunayEdge nextEdge : edges) {
                            DelaunayNode farNode = (DelaunayNode)nextEdge.getOtherNode(next2);
                            if (newNodes.contains(farNode)) continue;
                            nodesToAdd.add(farNode);
                            edgesToAdd.add(nextEdge);
                        }
                    }
                    newNodes.addAll(nodesToAdd);
                    newEdges.addAll(edgesToAdd);
                }
                totalTarget = 0.0;
                totalBase = 0.0;
                for (DelaunayNode nextNode : newNodes) {
                    SimpleFeature nextFeature2 = nextNode.getFeature();
                    Object neighborsBaseObj = base.evaluate(nextFeature2);
                    if (!(baseObj instanceof Number)) {
                        throw new RuntimeException("Expression " + base + " must evaluate to a number on feature " + nextFeature2);
                    }
                    Object neighborsTargetObj = target.evaluate(nextFeature2);
                    if (!(targetObj instanceof Number)) {
                        throw new RuntimeException("Expression " + target + " must evaluate to a number on feature " + nextFeature2);
                    }
                    totalBase += ((Number)baseObj).doubleValue();
                    totalTarget += ((Number)targetObj).doubleValue();
                }
            }
            double expectedTarget = meanRate * totalBase;
            double top = Math.pow(Math.E, 0.0 - expectedTarget) * Math.pow(expectedTarget, totalTarget);
            double bottom = PoissonClusterer.fact((int)Math.round(totalTarget));
            double poissonProb = top / bottom;
            System.out.println(next.getCoordinate().x + ", " + next.getCoordinate().y + ", " + totalTarget + ", " + expectedTarget + ", " + poissonProb);
            if (!(poissonProb < threshold)) continue;
            clusterNodes.addAll(newNodes);
            clusterEdges.addAll(newEdges);
        }
        return new BasicGraph(clusterNodes, clusterEdges);
    }

    private static double iterFact(int i, int f) {
        if (i == 0 || i == 1) {
            return f;
        }
        return PoissonClusterer.iterFact(i - 1, i * f);
    }

    public static double fact(int i) {
        return PoissonClusterer.iterFact(i, 1);
    }
}

