/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.EmptyIntersectionException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.coverage.IntersectUtils;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Crop
extends Operation2D {
    private static final long serialVersionUID = 4466072819239413456L;
    public static final double EPS = 0.001;
    private static final GeometryFactory GFACTORY;
    public static final String PARAMNAME_ENVELOPE = "Envelope";
    public static final String PARAMNAME_ROI = "ROI";
    public static final String PARAMNAME_ROITOLERANCE = "ROITolerance";
    public static final String PARAMNAME_FORCEMOSAIC = "ForceMosaic";
    public static final String PARAMNAME_NODATA = "NoData";
    public static final String PARAMNAME_DEST_NODATA = "destNoData";
    public static final ParameterDescriptor<org.opengis.geometry.Envelope> CROP_ENVELOPE;
    public static final ParameterDescriptor<Geometry> CROP_ROI;
    public static final ParameterDescriptor<Double> ROI_OPTIMISATION_TOLERANCE;
    public static final ParameterDescriptor<Boolean> FORCE_MOSAIC;
    public static final ParameterDescriptor<Range> NODATA;
    public static final ParameterDescriptor<double[]> DEST_NODATA;

    public Crop() {
        super(new DefaultParameterDescriptorGroup(Citations.JAI, "CoverageCrop", new ParameterDescriptor[]{SOURCE_0, CROP_ENVELOPE, CROP_ROI, ROI_OPTIMISATION_TOLERANCE, FORCE_MOSAIC, NODATA, DEST_NODATA}));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        Polygon jis;
        Geometry cropRoi;
        GeneralEnvelope cropEnvelope = null;
        double roiTolerance = parameters.parameter(PARAMNAME_ROITOLERANCE).doubleValue();
        boolean forceMosaic = parameters.parameter(PARAMNAME_FORCEMOSAIC).booleanValue();
        Range nodata = (Range)parameters.parameter(PARAMNAME_NODATA).getValue();
        double[] destnodata = (double[])parameters.parameter(PARAMNAME_DEST_NODATA).getValue();
        ParameterValue<?> sourceParameter = parameters.parameter("Source");
        if (sourceParameter == null || !(sourceParameter.getValue() instanceof GridCoverage2D)) {
            throw new CannotCropException(Errors.format(146, "Source", GridCoverage2D.class.toString()));
        }
        GridCoverage2D source = (GridCoverage2D)sourceParameter.getValue();
        if (nodata == null) {
            NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty(source);
            nodata = noDataProperty != null ? noDataProperty.getAsRange() : null;
        }
        ParameterValue<?> envelopeParameter = parameters.parameter(PARAMNAME_ENVELOPE);
        ParameterValue<?> roiParameter = parameters.parameter(PARAMNAME_ROI);
        if (!(envelopeParameter != null && envelopeParameter.getValue() != null || roiParameter != null && roiParameter.getValue() != null)) {
            throw new CannotCropException(Errors.format(146, PARAMNAME_ENVELOPE, GeneralEnvelope.class.toString()));
        }
        Object envelope = envelopeParameter.getValue();
        if (envelope != null) {
            if (envelope instanceof GeneralEnvelope) {
                cropEnvelope = (GeneralEnvelope)envelope;
            } else if (envelope instanceof org.opengis.geometry.Envelope) {
                cropEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelope);
            }
        }
        try {
            cropRoi = IntersectUtils.unrollGeometries((Geometry)roiParameter.getValue());
        }
        catch (IllegalArgumentException ex) {
            throw new CannotCropException(Errors.format(58, PARAMNAME_ROI, ex.getMessage()), ex);
        }
        if (cropRoi != null && cropEnvelope == null) {
            Envelope2D e2d = JTS.getEnvelope2D(cropRoi.getEnvelopeInternal(), source.getCoordinateReferenceSystem());
            cropEnvelope = new GeneralEnvelope(e2d);
        }
        Envelope2D sourceEnvelope = source.getEnvelope2D();
        Envelope2D destinationEnvelope = new Envelope2D(cropEnvelope);
        CoordinateReferenceSystem sourceCRS = sourceEnvelope.getCoordinateReferenceSystem();
        CoordinateReferenceSystem destinationCRS = destinationEnvelope.getCoordinateReferenceSystem();
        if (destinationCRS == null) {
            Envelope2D ge = new Envelope2D(destinationEnvelope);
            destinationCRS = source.getCoordinateReferenceSystem2D();
            ge.setCoordinateReferenceSystem(destinationCRS);
            destinationEnvelope = ge;
        }
        if (!CRS.equalsIgnoreMetadata(sourceCRS, destinationCRS)) {
            throw new CannotCropException(Errors.format(95, sourceCRS.getName().getCode(), destinationCRS.getName().getCode()));
        }
        if (cropRoi != null) {
            // empty if block
        }
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope(destinationEnvelope);
        intersectionEnvelope.setCoordinateReferenceSystem(source.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect(sourceEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            throw new EmptyIntersectionException("Crop envelope does not intersect in model space");
        }
        if (cropRoi != null && !IntersectUtils.intersects(cropRoi, (Geometry)(jis = JTS.toGeometry((Envelope)new ReferencedEnvelope(intersectionEnvelope))))) {
            throw new CannotCropException(Errors.format(25));
        }
        ROI internalROI = CoverageUtilities.getROIProperty(source);
        AffineTransform sourceCornerGridToWorld = (AffineTransform)((Object)source.getGridGeometry().getGridToCRS(PixelInCell.CELL_CORNER));
        double tolerance = XAffineTransform.getScale(sourceCornerGridToWorld);
        if (cropRoi != null || !intersectionEnvelope.equals(sourceEnvelope, tolerance / 2.0, false)) {
            cropEnvelope = intersectionEnvelope.clone();
            return Crop.buildResult(internalROI, nodata, destnodata, cropEnvelope, cropRoi, roiTolerance, forceMosaic, hints instanceof Hints ? hints : new Hints(hints), source, sourceCornerGridToWorld);
        }
        return source;
    }

    private static GridCoverage2D buildResult(ROI internalROI, Range nodata, double[] destnodata, GeneralEnvelope cropEnvelope, Geometry cropROI, double roiTolerance, boolean forceMosaic, Hints hints, GridCoverage2D sourceCoverage, AffineTransform sourceGridToWorldTransform) {
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        GridGeometry2D sourceGridGeometry = sourceCoverage.getGridGeometry();
        GridEnvelope2D sourceGridRange = sourceGridGeometry.getGridRange2D();
        boolean isSimpleTransform = CoverageUtilities.isSimpleGridToWorldTransform(sourceGridToWorldTransform, 0.001);
        boolean actionTaken = false;
        RenderingHints targetHints = new RenderingHints(null);
        if (hints != null) {
            targetHints.add(hints);
        }
        ImageLayout layout = Crop.initLayout(sourceImage, targetHints);
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        try {
            if (cropROI != null) {
                Polygon modelSpaceROI = FeatureUtilities.getPolygon(cropEnvelope, GFACTORY);
                Geometry intersection = IntersectUtils.intersection(cropROI, (Geometry)modelSpaceROI);
                Envelope2D e2d = JTS.getEnvelope2D(intersection.getEnvelopeInternal(), cropEnvelope.getCoordinateReferenceSystem());
                GeneralEnvelope ge = new GeneralEnvelope(e2d);
                cropEnvelope.setEnvelope(ge);
            }
            AffineTransform sourceWorldToGridTransform = sourceGridToWorldTransform.createInverse();
            Rectangle2D finalRasterAreaDouble = XAffineTransform.transform(sourceWorldToGridTransform, cropEnvelope.toRectangle2D(), null);
            Rectangle finalRasterArea = finalRasterAreaDouble.getBounds();
            Rectangle.intersect(finalRasterArea, sourceGridRange, finalRasterArea);
            if (finalRasterArea.isEmpty()) {
                throw new EmptyIntersectionException("Crop envelope intersects in model space, but not in raster space");
            }
            if (finalRasterArea.equals(sourceGridRange) && isSimpleTransform && cropROI == null) {
                return sourceCoverage;
            }
            double minX = finalRasterArea.getMinX();
            double minY = finalRasterArea.getMinY();
            double width = finalRasterArea.getWidth();
            double height = finalRasterArea.getHeight();
            ImageWorker worker = new ImageWorker();
            java.awt.Polygon rasterSpaceROI = null;
            double[] background = destnodata != null ? destnodata : CoverageUtilities.getBackgroundValues(sourceCoverage);
            String operatioName = null;
            if (!isSimpleTransform || cropROI != null) {
                Polygon modelSpaceROI = FeatureUtilities.getPolygon(cropEnvelope, GFACTORY);
                ArrayList<Point2D> points = new ArrayList<Point2D>(5);
                rasterSpaceROI = FeatureUtilities.convertPolygonToPointArray(modelSpaceROI, ProjectiveTransform.create(sourceWorldToGridTransform), points);
                if (isSimpleTransform && cropROI == null) {
                    rasterSpaceROI = Crop.rectangleToPolygon(finalRasterArea);
                }
                if ((rasterSpaceROI == null || rasterSpaceROI.getBounds().isEmpty()) && finalRasterArea.isEmpty()) {
                    throw new CannotCropException(Errors.format(25));
                }
                if (forceMosaic || cropROI != null || internalROI != null || nodata != null) {
                    Range[] rangeArray;
                    ROI[] roiarr = null;
                    if (cropROI != null) {
                        Geometry txROI = JTS.transform(cropROI, (MathTransform)ProjectiveTransform.create(sourceWorldToGridTransform));
                        if (!Crop.hasIntegerBounds(JTS.toRectangle2D(txROI.getEnvelopeInternal()))) {
                            Crop.transformGeometry(txROI);
                        }
                        ROI cropRS = Crop.getAsROI(txROI);
                        roiarr = new ROI[]{cropRS};
                    } else if (forceMosaic) {
                        ROI roi = Crop.getAsROI(JTS.toPolygon(rasterSpaceROI));
                        roiarr = new ROI[]{roi};
                    }
                    if (roiarr != null && roiarr[0].getBounds().isEmpty()) {
                        throw new CannotCropException(Errors.format(25));
                    }
                    worker.setBackground(background);
                    worker.setNoData(nodata);
                    Rectangle bounds = rasterSpaceROI.getBounds2D().getBounds();
                    Rectangle.intersect(bounds, sourceGridRange, bounds);
                    if (bounds.isEmpty()) {
                        throw new CannotCropException(Errors.format(25));
                    }
                    if (!forceMosaic && bounds.getBounds().equals(sourceGridRange) && isSimpleTransform && nodata == null) {
                        return sourceCoverage;
                    }
                    Rectangle boundsInt = bounds.getBounds();
                    layout.setMinX(boundsInt.x);
                    layout.setWidth(boundsInt.width);
                    layout.setMinY(boundsInt.y);
                    layout.setHeight(boundsInt.height);
                    operatioName = "Mosaic";
                    worker.setRenderingHints(targetHints);
                    RenderedImage[] renderedImageArray = new RenderedImage[]{sourceImage};
                    double[][] dArray = null;
                    if (nodata != null) {
                        Range[] rangeArray2 = new Range[1];
                        rangeArray = rangeArray2;
                        rangeArray2[0] = nodata;
                    } else {
                        rangeArray = null;
                    }
                    worker.mosaic(renderedImageArray, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, roiarr, dArray, rangeArray);
                }
            }
            if (operatioName == null) {
                worker.setImage(sourceImage);
                worker.setNoData(null);
                worker.setRenderingHints(targetHints);
                worker.crop((float)minX, (float)minY, (float)width, (float)height);
                operatioName = "Crop";
            }
            PlanarImage croppedImage = worker.getPlanarImage();
            Map sourceProperties = sourceCoverage.getProperties();
            HashMap<String, Object> properties = null;
            if (sourceProperties != null && !sourceProperties.isEmpty()) {
                properties = new HashMap<String, Object>(sourceProperties);
            }
            if (rasterSpaceROI != null || internalROI != null) {
                ROI finalROI = null;
                if (rasterSpaceROI != null) {
                    finalROI = Crop.getAsROI(JTS.toPolygon(rasterSpaceROI));
                }
                if (finalROI != null && internalROI != null) {
                    finalROI = finalROI.intersect(internalROI);
                } else if (internalROI != null) {
                    finalROI = internalROI;
                }
                if (properties == null) {
                    properties = new HashMap();
                }
                if (finalROI != null) {
                    CoverageUtilities.setROIProperty(properties, finalROI);
                }
            }
            if (worker.getNoData() != null) {
                if (properties == null) {
                    properties = new HashMap();
                }
                CoverageUtilities.setNoDataProperty(properties, worker.getNoData());
            }
            return new GridCoverageFactory(hints).create((CharSequence)sourceCoverage.getName(), (RenderedImage)croppedImage, new GridGeometry2D(new GridEnvelope2D(croppedImage.getBounds()), (MathTransform)sourceGridGeometry.getGridToCRS2D(PixelOrientation.CENTER), sourceCoverage.getCoordinateReferenceSystem()), actionTaken ? null : (GridSampleDimension[])sourceCoverage.getSampleDimensions().clone(), new GridCoverage[]{sourceCoverage}, properties);
        }
        catch (TransformException e) {
            throw new CannotCropException(Errors.format(25), e);
        }
        catch (NoninvertibleTransformException e) {
            throw new CannotCropException(Errors.format(25), e);
        }
    }

    private static boolean hasIntegerBounds(Rectangle2D rt) {
        if (rt == null || rt.isEmpty()) {
            return true;
        }
        double minx = rt.getMinX();
        double miny = rt.getMinY();
        double maxx = rt.getMaxX();
        double maxy = rt.getMaxY();
        return minx % 1.0 == 0.0 && miny % 1.0 == 0.0 && maxx % 1.0 == 0.0 && maxy % 1.0 == 0.0;
    }

    private static void transformGeometry(Geometry geometry) {
        if (geometry == null) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                Crop.transformGeometry(collection.getGeometryN(i));
            }
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            Crop.transformGeometry(polygon.getExteriorRing());
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                Crop.transformGeometry(polygon.getInteriorRingN(i));
            }
        } else if (geometry instanceof LineString) {
            CoordinateSequence cs = ((LineString)geometry).getCoordinateSequence();
            for (int i = 0; i < cs.size(); ++i) {
                cs.setOrdinate(i, 0, (int)(cs.getOrdinate(i, 0) + 0.5));
                cs.setOrdinate(i, 1, (int)(cs.getOrdinate(i, 1) + 0.5));
            }
        }
        geometry.geometryChanged();
    }

    private static ImageLayout initLayout(RenderedImage sourceImage, RenderingHints hints) {
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        return layout;
    }

    public static java.awt.Polygon rectangleToPolygon(Rectangle rect) {
        java.awt.Polygon result = new java.awt.Polygon();
        result.addPoint(rect.x, rect.y);
        result.addPoint(rect.x + rect.width, rect.y);
        result.addPoint(rect.x + rect.width, rect.y + rect.height);
        result.addPoint(rect.x, rect.y + rect.height);
        return result;
    }

    private static ROI getAsROI(Geometry theGeom) {
        Envelope env = theGeom.getEnvelopeInternal();
        int x = (int)Math.floor(env.getMinX());
        int y = (int)Math.floor(env.getMinY());
        int w = (int)Math.ceil(env.getMaxX()) - x;
        int h = (int)Math.ceil(env.getMaxY()) - y;
        ParameterBlockJAI pb = new ParameterBlockJAI("VectorBinarize");
        pb.setParameter("minx", x);
        pb.setParameter("miny", y);
        pb.setParameter("width", w);
        pb.setParameter("height", h);
        pb.setParameter("geometry", PreparedGeometryFactory.prepare(theGeom));
        pb.setParameter("antiAliasing", true);
        RenderedOp roiImage = JAI.create("VectorBinarize", pb, null);
        return new ROI(roiImage);
    }

    static {
        Hints defaultHints = GeoTools.getDefaultHints();
        Object o = defaultHints.get(Hints.JTS_PRECISION_MODEL);
        PrecisionModel pm = o != null ? (PrecisionModel)o : new PrecisionModel();
        GFACTORY = new GeometryFactory(pm, 0);
        CROP_ENVELOPE = new DefaultParameterDescriptor<Object>(Citations.GEOTOOLS, PARAMNAME_ENVELOPE, org.opengis.geometry.Envelope.class, null, null, null, null, null, true);
        CROP_ROI = new DefaultParameterDescriptor<Object>(Citations.JAI, PARAMNAME_ROI, Geometry.class, null, null, null, null, null, true);
        ROI_OPTIMISATION_TOLERANCE = new DefaultParameterDescriptor<Double>(Citations.GEOTOOLS, PARAMNAME_ROITOLERANCE, Double.class, null, 0.6, Double.valueOf(0.0), Double.valueOf(1.0), null, true);
        FORCE_MOSAIC = new DefaultParameterDescriptor<Boolean>(Citations.GEOTOOLS, PARAMNAME_FORCEMOSAIC, Boolean.class, null, false, null, null, null, true);
        NODATA = new DefaultParameterDescriptor<Object>(Citations.JAI, PARAMNAME_NODATA, Range.class, null, null, null, null, null, true);
        DEST_NODATA = new DefaultParameterDescriptor<Object>(Citations.JAI, PARAMNAME_DEST_NODATA, double[].class, null, null, null, null, null, true);
    }
}

