/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class BandMerge
extends OperationJAI {
    public static final String TRANSFORM_CHOICE = "transform_choice";
    public static final String COVERAGE_INDEX = "coverage_idx";
    public static final String GEOMETRY = "geometry";
    public static final ParameterDescriptor SOURCES = new DefaultParameterDescriptor<Object>(Citations.JAI, "Sources", Collection.class, null, null, null, null, null, true);
    public static final ParameterDescriptor TRANSFORM_CHOICE_PARAM = new DefaultParameterDescriptor<Object>(Citations.JAI, "transform_choice", String.class, null, null, null, null, null, false);
    public static final ParameterDescriptor INDEX = new DefaultParameterDescriptor<Integer>(Citations.JAI, "coverage_idx", Integer.class, null, 0, Integer.valueOf(0), null, null, false);
    public static final ParameterDescriptor GEOMETRY_PARAM = new DefaultParameterDescriptor<Object>(Citations.JAI, "geometry", Geometry.class, null, null, null, null, null, false);
    private static final Logger LOGGER = Logging.getLogger(BandMerge.class);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public BandMerge() {
        super(BandMerge.getOperationDescriptor("BandMerge"), new ImagingParameterDescriptors(BandMerge.getOperationDescriptor("BandMerge"), REPLACED_DESCRIPTORS));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) throws CoverageProcessingException {
        ParameterBlockJAI block;
        ArrayList<GridCoverage2D> sourceCollection = new ArrayList<GridCoverage2D>();
        this.extractSources(parameters, sourceCollection);
        GridCoverage2D coverage = (GridCoverage2D)sourceCollection.iterator().next();
        CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem2D();
        Envelope2D globalBbox = new Envelope2D();
        String transChoice = (String)parameters.parameter(TRANSFORM_CHOICE).getValue();
        TransformList choice = TransformList.FIRST;
        if (transChoice != null && !transChoice.isEmpty()) {
            choice = TransformList.getTransformList(transChoice);
        }
        int size = sourceCollection.size();
        ArrayList<GridGeometry2D> gg2D = new ArrayList<GridGeometry2D>(size);
        for (GridCoverage2D source : sourceCollection) {
            if (source == null) {
                --size;
                continue;
            }
            globalBbox.include(source.getEnvelope2D());
            gg2D.add(source.getGridGeometry());
        }
        List<AffineTransform> tr = choice.getTransformationList(gg2D, this.getIndex(parameters));
        AffineTransform2D gridToCRS = new AffineTransform2D(choice.getGridToCRS2D(gg2D, this.getIndex(parameters)));
        AffineTransform2D crsToGrid = new AffineTransform2D(choice.getCRStoGrid2D(gg2D, this.getIndex(parameters)));
        GridCoverage2D[] sources = new GridCoverage2D[size];
        sourceCollection.toArray(sources);
        try {
            block = this.prepareParameters(parameters, sources, tr, crsToGrid);
        }
        catch (MismatchedDimensionException e) {
            throw new CoverageProcessingException(e);
        }
        catch (ParameterNotFoundException e) {
            throw new CoverageProcessingException(e);
        }
        catch (TransformException e) {
            throw new CoverageProcessingException(e);
        }
        return this.deriveGridCoverage(sources, new BandMergeParams(crs, gridToCRS, globalBbox, block, hints));
    }

    private int getIndex(ParameterValueGroup parameters) {
        Object idx = parameters.parameter(COVERAGE_INDEX).getValue();
        if (idx != null && idx instanceof Integer) {
            return (Integer)idx;
        }
        return 0;
    }

    protected void extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources) throws ParameterNotFoundException, InvalidParameterValueException {
        Utilities.ensureNonNull("parameters", parameters);
        Utilities.ensureNonNull("sources", sources);
        Object srcCoverages = parameters.parameter("sources").getValue();
        if (!(srcCoverages instanceof Collection) || ((Collection)srcCoverages).isEmpty() || !(((Collection)srcCoverages).iterator().next() instanceof GridCoverage2D)) {
            throw new InvalidParameterValueException(Errors.format(57, "sources"), "sources", srcCoverages);
        }
        Collection sourceCoverages = (Collection)srcCoverages;
        for (GridCoverage2D source : sourceCoverages) {
            sources.add(source);
        }
    }

    private GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, BandMergeParams parameters) {
        GridCoverage2D primarySource = sources[0];
        GridSampleDimension[][] list = new GridSampleDimension[sources.length][];
        for (int i = 0; i < list.length; ++i) {
            if (sources[i] == null) continue;
            list[i] = sources[i].getSampleDimensions();
        }
        GridSampleDimension[] sampleDims = this.deriveSampleDimension(list, null);
        int primarySourceIndex = 0;
        RenderingHints hints = ImageUtilities.getRenderingHints(parameters.getSource());
        ImageLayout layout = hints != null ? (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT) : null;
        Envelope2D bbox = parameters.bbox;
        if (layout != null) {
            if (bbox != null) {
                this.updateLayout(parameters, layout, bbox);
            }
            if (hints == null) {
                hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            } else {
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        } else if (bbox != null) {
            layout = new ImageLayout2();
            this.updateLayout(parameters, layout, bbox);
            if (hints == null) {
                hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            } else {
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (parameters.hints != null) {
            if (hints != null) {
                hints.add(parameters.hints);
            } else {
                hints = parameters.hints;
            }
        }
        InternationalString name = this.deriveName(sources, primarySourceIndex, null);
        CoordinateReferenceSystem crs = primarySource.getCoordinateReferenceSystem();
        AffineTransform2D toCRS = parameters.gridToCRS;
        RenderedImage data = this.createRenderedImage(parameters.parameters, hints);
        Map properties = this.getProperties(data, crs, name, (MathTransform)toCRS, sources, parameters);
        GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage(data).getBounds()), PixelInCell.CELL_CORNER, (MathTransform)toCRS, crs, parameters.hints);
        return BandMerge.getFactory(parameters.hints).create((CharSequence)name, data, gridGeometry2D, sampleDims, (GridCoverage[])sources, properties);
    }

    private void updateLayout(BandMergeParams parameters, ImageLayout layout, Envelope2D bbox) {
        GridGeometry2D gg2D = new GridGeometry2D(PixelInCell.CELL_CORNER, parameters.gridToCRS, bbox, null);
        GridEnvelope2D gridRange2D = gg2D.getGridRange2D();
        layout.setMinX(gridRange2D.x);
        layout.setMinY(gridRange2D.y);
        layout.setWidth(gridRange2D.width);
        layout.setHeight(gridRange2D.height);
    }

    protected Map getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform toCRS, GridCoverage2D[] sources, BandMergeParams parameters) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (GridCoverage2D cov : sources) {
            if (cov == null || cov.getProperties() == null) continue;
            properties.putAll(cov.getProperties());
        }
        if (JAIExt.isJAIExtOperation("BandMerge")) {
            ParameterBlockJAI pb = parameters.parameters;
            CoverageUtilities.setROIProperty(properties, (ROI)pb.getObjectParameter(3));
            CoverageUtilities.setNoDataProperty(properties, pb.getObjectParameter(1));
        }
        return properties;
    }

    @Override
    protected GridSampleDimension[] deriveSampleDimension(GridSampleDimension[][] list, OperationJAI.Parameters parameters) {
        int numDim = 0;
        for (GridSampleDimension[] array : list) {
            numDim += array.length;
        }
        if (numDim == 0) {
            return null;
        }
        ArrayList<GridSampleDimension> sampleDims = new ArrayList<GridSampleDimension>(numDim);
        GridSampleDimension[][] gridSampleDimensionArray = list;
        int n = gridSampleDimensionArray.length;
        for (int i = 0; i < n; ++i) {
            GridSampleDimension[] array;
            for (GridSampleDimension sample : array = gridSampleDimensionArray[i]) {
                sampleDims.add(sample);
            }
        }
        GridSampleDimension[] dims = new GridSampleDimension[numDim];
        return sampleDims.toArray(dims);
    }

    private ParameterBlockJAI prepareParameters(ParameterValueGroup parameters, GridCoverage2D[] sources, List<AffineTransform> tr, AffineTransform2D crsToGRID) throws MismatchedDimensionException, ParameterNotFoundException, TransformException {
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockJAI block = (ParameterBlockJAI)copy.parameters;
        Range[] nodata = new Range[sources.length];
        int dataType = sources[0].getRenderedImage().getSampleModel().getDataType();
        for (int i = 0; i < sources.length; ++i) {
            GridCoverage2D cov = sources[i];
            block.setSource(cov.getRenderedImage(), i);
            int dataTypeCov = cov.getRenderedImage().getSampleModel().getDataType();
            if (dataType != dataTypeCov) {
                throw new IllegalArgumentException("Input Coverages must have the same data type");
            }
            nodata[i] = this.createNoDataRange(cov, dataType);
        }
        if (JAIExt.isJAIExtOperation("BandMerge")) {
            block.setParameter("noData", nodata);
            block.setParameter("transformations", tr);
            ROI roi = null;
            if (parameters.parameter(GEOMETRY).getValue() != null) {
                roi = new ROIGeometry(JTS.transform((Geometry)parameters.parameter(GEOMETRY).getValue(), (MathTransform)crsToGRID));
            }
            for (int i = 0; i < sources.length; ++i) {
                GridCoverage2D cov = sources[i];
                ROI covROI = CoverageUtilities.getROIProperty(cov);
                if (covROI == null) continue;
                ROI newROI = null;
                if (tr != null) {
                    try {
                        AffineTransform trans = tr.get(i).createInverse();
                        newROI = covROI.transform(trans);
                    }
                    catch (NoninvertibleTransformException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    newROI = covROI;
                }
                roi = roi == null ? newROI : ((ROI)roi).intersect(newROI);
            }
            if (roi != null) {
                block.setParameter("roi", roi);
            }
            block.setParameter("destinationNoData", nodata[this.getIndex(parameters)].getMin().doubleValue());
        }
        return block;
    }

    private Range createNoDataRange(GridCoverage2D cov, int dataType) {
        NoDataContainer container = CoverageUtilities.getNoDataProperty(cov);
        if (container != null) {
            return container.getAsRange();
        }
        double[] nodatas = CoverageUtilities.getBackgroundValues(cov);
        if (nodatas != null && nodatas.length > 0) {
            Range noData = RangeFactory.convert(RangeFactory.create(nodatas[0], nodatas[0]), dataType);
            return noData;
        }
        return null;
    }

    static {
        HashSet<ParameterDescriptor> replacedDescriptors = new HashSet<ParameterDescriptor>();
        replacedDescriptors.add(SOURCES);
        replacedDescriptors.add(INDEX);
        replacedDescriptors.add(TRANSFORM_CHOICE_PARAM);
        replacedDescriptors.add(GEOMETRY_PARAM);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }

    static class BandMergeParams {
        public final CoordinateReferenceSystem crs;
        public final AffineTransform2D gridToCRS;
        public final ParameterBlockJAI parameters;
        public final Hints hints;
        public Envelope2D bbox;

        BandMergeParams(CoordinateReferenceSystem crs, AffineTransform2D gridToCRS, Envelope2D bbox, ParameterBlockJAI parameters, Hints hints) {
            this.crs = crs;
            this.gridToCRS = gridToCRS;
            this.bbox = bbox;
            this.parameters = parameters;
            this.hints = hints;
        }

        final RenderedImage getSource() {
            int n = this.parameters.getNumSources();
            for (int i = 0; i < n; ++i) {
                Object source = this.parameters.getSource(i);
                if (!(source instanceof RenderedImage)) continue;
                return (RenderedImage)source;
            }
            return null;
        }
    }

    public static enum TransformList {
        FIRST("first"){

            @Override
            public AffineTransform getGridToCRS2D(List<GridGeometry2D> list, int index) {
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("No Affine Transformation found");
                }
                return TransformList.getAffineTransform(list.get(0), true);
            }

            @Override
            public AffineTransform getCRStoGrid2D(List<GridGeometry2D> list, int index) {
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("No Affine Transformation found");
                }
                return TransformList.getAffineTransform(list.get(0), false);
            }
        }
        ,
        LAST("last"){

            @Override
            public AffineTransform getGridToCRS2D(List<GridGeometry2D> list, int index) {
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("No Affine Transformation found");
                }
                return TransformList.getAffineTransform(list.get(list.size() - 1), true);
            }

            @Override
            public AffineTransform getCRStoGrid2D(List<GridGeometry2D> list, int index) {
                if (list.isEmpty()) {
                    throw new IllegalArgumentException("No Affine Transformation found");
                }
                return TransformList.getAffineTransform(list.get(list.size() - 1), false);
            }
        }
        ,
        INDEX("index"){

            @Override
            public AffineTransform getGridToCRS2D(List<GridGeometry2D> list, int index) {
                if (index < 0) {
                    return FIRST.getGridToCRS2D(list, index);
                }
                if (index >= list.size()) {
                    return LAST.getGridToCRS2D(list, index);
                }
                return TransformList.getAffineTransform(list.get(index), true);
            }

            @Override
            public AffineTransform getCRStoGrid2D(List<GridGeometry2D> list, int index) {
                if (index < 0) {
                    return FIRST.getCRStoGrid2D(list, index);
                }
                if (index >= list.size()) {
                    return LAST.getCRStoGrid2D(list, index);
                }
                return TransformList.getAffineTransform(list.get(index), false);
            }
        };

        private String name;

        public List<AffineTransform> getTransformationList(List<GridGeometry2D> list, int index) {
            ArrayList<AffineTransform> transforms = new ArrayList<AffineTransform>();
            AffineTransform g2w = this.getGridToCRS2D(list, index);
            for (GridGeometry2D gg2D : list) {
                AffineTransform tr = new AffineTransform(TransformList.getAffineTransform(gg2D, false));
                tr.concatenate(g2w);
                transforms.add(tr);
            }
            return transforms;
        }

        private TransformList(String name) {
            this.name = name;
        }

        public abstract AffineTransform getGridToCRS2D(List<GridGeometry2D> var1, int var2);

        public abstract AffineTransform getCRStoGrid2D(List<GridGeometry2D> var1, int var2);

        public static TransformList getTransformList(String choice) {
            if (choice.equalsIgnoreCase(TransformList.LAST.name)) {
                return LAST;
            }
            if (choice.equalsIgnoreCase(TransformList.INDEX.name)) {
                return INDEX;
            }
            return FIRST;
        }

        private static AffineTransform getAffineTransform(GridGeometry2D gg2D, boolean grid2crs) {
            MathTransform2D tr = null;
            tr = grid2crs ? gg2D.getGridToCRS2D(PixelOrientation.UPPER_LEFT) : gg2D.getCRSToGrid2D(PixelOrientation.UPPER_LEFT);
            if (tr instanceof AffineTransform2D) {
                return (AffineTransform2D)tr;
            }
            throw new IllegalArgumentException(tr.toString() + " is not an AffineTransform");
        }
    }
}

