/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public abstract class AbstractGridFormat
implements Format {
    protected Map<String, String> mInfo;
    protected ParameterValueGroup readParameters;
    protected ParameterValueGroup writeParameters;
    private static CoordinateReferenceSystem crs = CartesianAuthorityFactory.GENERIC_2D;
    public static final DefaultParameterDescriptor<GridGeometry2D> READ_GRIDGEOMETRY2D = new DefaultParameterDescriptor<Object>("ReadGridGeometry2D", GridGeometry2D.class, null, null);
    public static final DefaultParameterDescriptor<ProgressListener> PROGRESS_LISTENER = new DefaultParameterDescriptor<Object>("Listener", ProgressListener.class, null, null);
    public static final DefaultParameterDescriptor<GeoToolsWriteParams> GEOTOOLS_WRITE_PARAMS = new DefaultParameterDescriptor<Object>("WriteParameters", GeoToolsWriteParams.class, null, null);
    public static final DefaultParameterDescriptor<Boolean> USE_JAI_IMAGEREAD = new DefaultParameterDescriptor<Boolean>(Hints.USE_JAI_IMAGEREAD.toString(), Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.TRUE);
    public static final DefaultParameterDescriptor<OverviewPolicy> OVERVIEW_POLICY = new DefaultParameterDescriptor<OverviewPolicy>(Hints.OVERVIEW_POLICY.toString(), OverviewPolicy.class, new OverviewPolicy[]{OverviewPolicy.IGNORE, OverviewPolicy.NEAREST, OverviewPolicy.QUALITY, OverviewPolicy.SPEED}, OverviewPolicy.QUALITY);
    public static final ParameterDescriptor<DecimationPolicy> DECIMATION_POLICY = new DefaultParameterDescriptor<DecimationPolicy>(Hints.DECIMATION_POLICY.toString(), DecimationPolicy.class, new DecimationPolicy[]{DecimationPolicy.ALLOW, DecimationPolicy.DISALLOW}, DecimationPolicy.ALLOW);
    private static final String SUGGESTED_TILESIZE = "SUGGESTED_TILE_SIZE";
    public static final DefaultParameterDescriptor<String> SUGGESTED_TILE_SIZE = new DefaultParameterDescriptor<String>("SUGGESTED_TILE_SIZE", String.class, null, "512,512");
    public static final DefaultParameterDescriptor<int[]> BANDS = new DefaultParameterDescriptor<Object>("Bands", int[].class, null, null);
    public static final String TILE_SIZE_SEPARATOR = ",";
    public static final ParameterDescriptor<Color> INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor<Object>("InputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Color> BACKGROUND_COLOR = new DefaultParameterDescriptor<Object>("BackgroundColor", Color.class, null, null);
    public static final ParameterDescriptor<List> TIME = DefaultParameterDescriptor.create("TIME", "A list of time objects", List.class, null, false);
    public static final ParameterDescriptor<List> ELEVATION = DefaultParameterDescriptor.create("ELEVATION", "An elevation value", List.class, null, false);
    static final Interpolation DEFAULT_INTERPOLATION = new InterpolationNearest();
    public static final ParameterDescriptor<Interpolation> INTERPOLATION = new DefaultParameterDescriptor<Interpolation>("Interpolation", Interpolation.class, null, DEFAULT_INTERPOLATION);
    public static final ParameterDescriptor<String> FOOTPRINT_BEHAVIOR = new DefaultParameterDescriptor<String>("FootprintBehavior", String.class, FootprintBehavior.valuesAsStrings(), FootprintBehavior.None.name());

    @Override
    public String getName() {
        return this.mInfo.get("name");
    }

    @Override
    public String getDescription() {
        return this.mInfo.get("description");
    }

    @Override
    public String getVendor() {
        return this.mInfo.get("vendor");
    }

    @Override
    public String getDocURL() {
        return this.mInfo.get("docURL");
    }

    @Override
    public String getVersion() {
        return this.mInfo.get("version");
    }

    public abstract AbstractGridCoverage2DReader getReader(Object var1);

    public abstract AbstractGridCoverage2DReader getReader(Object var1, Hints var2);

    public abstract GridCoverageWriter getWriter(Object var1);

    public boolean accepts(Object source) {
        return this.accepts(source, GeoTools.getDefaultHints());
    }

    public abstract boolean accepts(Object var1, Hints var2);

    public boolean equals(Format f) {
        return f.getClass() == this.getClass();
    }

    @Override
    public ParameterValueGroup getReadParameters() {
        if (this.readParameters == null) {
            throw new UnsupportedOperationException("This format does not support usage of read parameters.");
        }
        return this.readParameters.clone();
    }

    @Override
    public ParameterValueGroup getWriteParameters() {
        if (this.writeParameters == null) {
            throw new UnsupportedOperationException("This format does not support usage of write parameters.");
        }
        return this.writeParameters.clone();
    }

    public static CoordinateReferenceSystem getDefaultCRS() {
        return crs;
    }

    public abstract GeoToolsWriteParams getDefaultImageIOWriteParameters();

    public abstract GridCoverageWriter getWriter(Object var1, Hints var2);
}

