/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.GeoMath;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.GeodesicLine;
import net.sf.geographiclib.GeographicErr;
import net.sf.geographiclib.Pair;

public class Geodesic {
    protected static final int GEOGRAPHICLIB_GEODESIC_ORDER = 6;
    protected static final int nA1_ = 6;
    protected static final int nC1_ = 6;
    protected static final int nC1p_ = 6;
    protected static final int nA2_ = 6;
    protected static final int nC2_ = 6;
    protected static final int nA3_ = 6;
    protected static final int nA3x_ = 6;
    protected static final int nC3_ = 6;
    protected static final int nC3x_ = 15;
    protected static final int nC4_ = 6;
    protected static final int nC4x_ = 21;
    private static final int maxit1_ = 20;
    private static final int maxit2_ = 83;
    protected static final double tiny_ = Math.sqrt(GeoMath.min);
    private static final double tol0_ = GeoMath.epsilon;
    private static final double tol1_ = 200.0 * tol0_;
    private static final double tol2_ = Math.sqrt(tol0_);
    private static final double tolb_ = tol0_ * tol2_;
    private static final double xthresh_ = 1000.0 * tol2_;
    protected double _a;
    protected double _f;
    protected double _f1;
    protected double _e2;
    protected double _ep2;
    protected double _b;
    protected double _c2;
    private double _n;
    private double _etol2;
    private double[] _A3x;
    private double[] _C3x;
    private double[] _C4x;
    public static final Geodesic WGS84 = new Geodesic(6378137.0, 0.0033528106647474805);

    public Geodesic(double a, double f) {
        this._a = a;
        this._f = f <= 1.0 ? f : 1.0 / f;
        this._f1 = 1.0 - this._f;
        this._e2 = this._f * (2.0 - this._f);
        this._ep2 = this._e2 / GeoMath.sq(this._f1);
        this._n = this._f / (2.0 - this._f);
        this._b = this._a * this._f1;
        this._c2 = (GeoMath.sq(this._a) + GeoMath.sq(this._b) * (this._e2 == 0.0 ? 1.0 : (this._e2 > 0.0 ? GeoMath.atanh(Math.sqrt(this._e2)) : Math.atan(Math.sqrt(-this._e2))) / Math.sqrt(Math.abs(this._e2)))) / 2.0;
        this._etol2 = 0.1 * tol2_ / Math.sqrt(Math.max(0.001, Math.abs(this._f)) * Math.min(1.0, 1.0 - this._f / 2.0) / 2.0);
        if (!GeoMath.isfinite(this._a) || !(this._a > 0.0)) {
            throw new GeographicErr("Major radius is not positive");
        }
        if (!GeoMath.isfinite(this._b) || !(this._b > 0.0)) {
            throw new GeographicErr("Minor radius is not positive");
        }
        this._A3x = new double[6];
        this._C3x = new double[15];
        this._C4x = new double[21];
        this.A3coeff();
        this.C3coeff();
        this.C4coeff();
    }

    public GeodesicData Direct(double lat1, double lon1, double azi1, double s12) {
        return this.Direct(lat1, lon1, azi1, false, s12, 904);
    }

    public GeodesicData Direct(double lat1, double lon1, double azi1, double s12, int outmask) {
        return this.Direct(lat1, lon1, azi1, false, s12, outmask);
    }

    public GeodesicData ArcDirect(double lat1, double lon1, double azi1, double a12) {
        return this.Direct(lat1, lon1, azi1, true, a12, 1929);
    }

    public GeodesicData ArcDirect(double lat1, double lon1, double azi1, double a12, int outmask) {
        return this.Direct(lat1, lon1, azi1, true, a12, outmask);
    }

    public GeodesicData Direct(double lat1, double lon1, double azi1, boolean arcmode, double s12_a12, int outmask) {
        return new GeodesicLine(this, lat1, lon1, azi1, outmask | (arcmode ? 0 : 2051)).Position(arcmode, s12_a12, outmask);
    }

    public GeodesicData Inverse(double lat1, double lon1, double lat2, double lon2) {
        return this.Inverse(lat1, lon1, lat2, lon2, 1537);
    }

    public GeodesicData Inverse(double lat1, double lon1, double lat2, double lon2, int outmask) {
        boolean meridian;
        int swapp;
        outmask &= 0xFF80;
        GeodesicData r = new GeodesicData();
        r.lat1 = lat1 = GeoMath.LatFix(lat1);
        r.lat2 = lat2 = GeoMath.LatFix(lat2);
        lat1 = GeoMath.AngRound(lat1);
        lat2 = GeoMath.AngRound(lat2);
        double lon12 = GeoMath.AngDiff(lon1, lon2);
        if ((outmask & 0x8000) != 0) {
            r.lon1 = lon1;
            r.lon2 = lon1 + lon12;
        } else {
            r.lon1 = GeoMath.AngNormalize(lon1);
            r.lon2 = GeoMath.AngNormalize(lon2);
        }
        lon12 = GeoMath.AngRound(lon12);
        int lonsign = lon12 >= 0.0 ? 1 : -1;
        lon12 *= (double)lonsign;
        int n = swapp = Math.abs(lat1) >= Math.abs(lat2) ? 1 : -1;
        if (swapp < 0) {
            lonsign *= -1;
            double t = lat1;
            lat1 = lat2;
            lat2 = t;
        }
        int latsign = lat1 < 0.0 ? 1 : -1;
        lat2 *= (double)latsign;
        double m12x = Double.NaN;
        double s12x = Double.NaN;
        Pair p = GeoMath.sincosd(lat1 *= (double)latsign);
        double sbet1 = this._f1 * p.first;
        double cbet1 = p.second;
        p = GeoMath.norm(sbet1, cbet1);
        sbet1 = p.first;
        cbet1 = p.second;
        cbet1 = Math.max(tiny_, cbet1);
        p = GeoMath.sincosd(lat2);
        double sbet2 = this._f1 * p.first;
        double cbet2 = p.second;
        p = GeoMath.norm(sbet2, cbet2);
        sbet2 = p.first;
        cbet2 = p.second;
        cbet2 = Math.max(tiny_, cbet2);
        if (cbet1 < -sbet1) {
            if (cbet2 == cbet1) {
                sbet2 = sbet2 < 0.0 ? sbet1 : -sbet1;
            }
        } else if (Math.abs(sbet2) == -sbet1) {
            cbet2 = cbet1;
        }
        double dn1 = Math.sqrt(1.0 + this._ep2 * GeoMath.sq(sbet1));
        double dn2 = Math.sqrt(1.0 + this._ep2 * GeoMath.sq(sbet2));
        double lam12 = lon12 * (Math.PI / 180);
        Pair p2 = GeoMath.sincosd(lon12);
        double slam12 = p2.first;
        double clam12 = p2.second;
        double salp2 = Double.NaN;
        double calp2 = Double.NaN;
        double salp1 = Double.NaN;
        double calp1 = Double.NaN;
        double sig12 = Double.NaN;
        double a12 = Double.NaN;
        double[] C1a = new double[7];
        double[] C2a = new double[7];
        double[] C3a = new double[6];
        boolean bl = meridian = lat1 == -90.0 || slam12 == 0.0;
        if (meridian) {
            calp1 = clam12;
            salp1 = slam12;
            calp2 = 1.0;
            salp2 = 0.0;
            double ssig1 = sbet1;
            double csig1 = calp1 * cbet1;
            double ssig2 = sbet2;
            double csig2 = calp2 * cbet2;
            sig12 = Math.atan2(Math.max(csig1 * ssig2 - ssig1 * csig2, 0.0), csig1 * csig2 + ssig1 * ssig2);
            LengthsV v = this.Lengths(this._n, sig12, ssig1, csig1, dn1, ssig2, csig2, dn2, cbet1, cbet2, outmask | 0x401 | 0x1005, C1a, C2a);
            s12x = v.s12b;
            m12x = v.m12b;
            if ((outmask & 0x2005) != 0) {
                r.M12 = v.M12;
                r.M21 = v.M21;
            }
            if (sig12 < 1.0 || m12x >= 0.0) {
                if (sig12 < 3.0 * tiny_) {
                    s12x = 0.0;
                    m12x = 0.0;
                    sig12 = 0.0;
                }
                m12x *= this._b;
                s12x *= this._b;
                a12 = sig12 / (Math.PI / 180);
            } else {
                meridian = false;
            }
        }
        double omg12 = Double.NaN;
        if (!meridian && sbet1 == 0.0 && (this._f <= 0.0 || lam12 <= Math.PI - this._f * Math.PI)) {
            calp2 = 0.0;
            calp1 = 0.0;
            salp2 = 1.0;
            salp1 = 1.0;
            s12x = this._a * lam12;
            sig12 = omg12 = lam12 / this._f1;
            m12x = this._b * Math.sin(sig12);
            if ((outmask & 0x2005) != 0) {
                r.M12 = r.M21 = Math.cos(sig12);
            }
            a12 = lon12 / this._f1;
        } else if (!meridian) {
            InverseStartV v = this.InverseStart(sbet1, cbet1, dn1, sbet2, cbet2, dn2, lam12, C1a, C2a);
            sig12 = v.sig12;
            salp1 = v.salp1;
            calp1 = v.calp1;
            salp2 = v.salp2;
            calp2 = v.calp2;
            double dnm = v.dnm;
            if (sig12 >= 0.0) {
                s12x = sig12 * this._b * dnm;
                m12x = GeoMath.sq(dnm) * this._b * Math.sin(sig12 / dnm);
                if ((outmask & 0x2005) != 0) {
                    r.M12 = r.M21 = Math.cos(sig12 / dnm);
                }
                a12 = sig12 / (Math.PI / 180);
                omg12 = lam12 / (this._f1 * dnm);
            } else {
                double eps = Double.NaN;
                double csig2 = Double.NaN;
                double ssig2 = Double.NaN;
                double csig1 = Double.NaN;
                double ssig1 = Double.NaN;
                double salp1a = tiny_;
                double calp1a = 1.0;
                double salp1b = tiny_;
                double calp1b = -1.0;
                boolean tripn = false;
                boolean tripb = false;
                for (int numit = 0; numit < 83; ++numit) {
                    Lambda12V w = this.Lambda12(sbet1, cbet1, dn1, sbet2, cbet2, dn2, salp1, calp1, numit < 20, C1a, C2a, C3a);
                    double v2 = w.lam12 - lam12;
                    salp2 = w.salp2;
                    calp2 = w.calp2;
                    sig12 = w.sig12;
                    ssig1 = w.ssig1;
                    csig1 = w.csig1;
                    ssig2 = w.ssig2;
                    csig2 = w.csig2;
                    eps = w.eps;
                    omg12 = w.domg12;
                    double dv = w.dlam12;
                    if (tripb) break;
                    double d = Math.abs(v2);
                    int n2 = tripn ? 8 : 2;
                    if (!(d >= (double)n2 * tol0_)) break;
                    if (v2 > 0.0 && (numit > 20 || calp1 / salp1 > calp1b / salp1b)) {
                        salp1b = salp1;
                        calp1b = calp1;
                    } else if (v2 < 0.0 && (numit > 20 || calp1 / salp1 < calp1a / salp1a)) {
                        salp1a = salp1;
                        calp1a = calp1;
                    }
                    if (numit < 20 && dv > 0.0) {
                        double dalp1 = -v2 / dv;
                        double sdalp1 = Math.sin(dalp1);
                        double cdalp1 = Math.cos(dalp1);
                        double nsalp1 = salp1 * cdalp1 + calp1 * sdalp1;
                        if (nsalp1 > 0.0 && Math.abs(dalp1) < Math.PI) {
                            calp1 = calp1 * cdalp1 - salp1 * sdalp1;
                            salp1 = nsalp1;
                            Pair p3 = GeoMath.norm(salp1, calp1);
                            salp1 = p3.first;
                            calp1 = p3.second;
                            tripn = Math.abs(v2) <= 16.0 * tol0_;
                            continue;
                        }
                    }
                    salp1 = (salp1a + salp1b) / 2.0;
                    calp1 = (calp1a + calp1b) / 2.0;
                    Pair p4 = GeoMath.norm(salp1, calp1);
                    salp1 = p4.first;
                    calp1 = p4.second;
                    tripn = false;
                    tripb = Math.abs(salp1a - salp1) + (calp1a - calp1) < tolb_ || Math.abs(salp1 - salp1b) + (calp1 - calp1b) < tolb_;
                }
                int lengthmask = outmask | ((outmask & 0x3005) != 0 ? 1025 : 0);
                LengthsV v3 = this.Lengths(eps, sig12, ssig1, csig1, dn1, ssig2, csig2, dn2, cbet1, cbet2, lengthmask, C1a, C2a);
                s12x = v3.s12b;
                m12x = v3.m12b;
                if ((outmask & 0x2005) != 0) {
                    r.M12 = v3.M12;
                    r.M21 = v3.M21;
                }
                m12x *= this._b;
                s12x *= this._b;
                a12 = sig12 / (Math.PI / 180);
                omg12 = lam12 - omg12;
            }
        }
        if ((outmask & 0x401) != 0) {
            r.s12 = 0.0 + s12x;
        }
        if ((outmask & 0x1005) != 0) {
            r.m12 = 0.0 + m12x;
        }
        if ((outmask & 0x4010) != 0) {
            double alp12;
            double salp0 = salp1 * cbet1;
            double calp0 = GeoMath.hypot(calp1, salp1 * sbet1);
            if (calp0 != 0.0 && salp0 != 0.0) {
                double ssig1 = sbet1;
                double csig1 = calp1 * cbet1;
                double ssig2 = sbet2;
                double csig2 = calp2 * cbet2;
                double k2 = GeoMath.sq(calp0) * this._ep2;
                double eps = k2 / (2.0 * (1.0 + Math.sqrt(1.0 + k2)) + k2);
                double A4 = GeoMath.sq(this._a) * calp0 * salp0 * this._e2;
                Pair p5 = GeoMath.norm(ssig1, csig1);
                ssig1 = p5.first;
                csig1 = p5.second;
                p5 = GeoMath.norm(ssig2, csig2);
                ssig2 = p5.first;
                csig2 = p5.second;
                double[] C4a = new double[6];
                this.C4f(eps, C4a);
                double B41 = Geodesic.SinCosSeries(false, ssig1, csig1, C4a);
                double B42 = Geodesic.SinCosSeries(false, ssig2, csig2, C4a);
                r.S12 = A4 * (B42 - B41);
            } else {
                r.S12 = 0.0;
            }
            if (!meridian && omg12 < 2.356194490192345 && sbet2 - sbet1 < 1.75) {
                double somg12 = Math.sin(omg12);
                double domg12 = 1.0 + Math.cos(omg12);
                double dbet1 = 1.0 + cbet1;
                double dbet2 = 1.0 + cbet2;
                alp12 = 2.0 * Math.atan2(somg12 * (sbet1 * dbet2 + sbet2 * dbet1), domg12 * (sbet1 * sbet2 + dbet1 * dbet2));
            } else {
                double salp12 = salp2 * calp1 - calp2 * salp1;
                double calp12 = calp2 * calp1 + salp2 * salp1;
                if (salp12 == 0.0 && calp12 < 0.0) {
                    salp12 = tiny_ * calp1;
                    calp12 = -1.0;
                }
                alp12 = Math.atan2(salp12, calp12);
            }
            r.S12 += this._c2 * alp12;
            r.S12 *= (double)(swapp * lonsign * latsign);
            r.S12 += 0.0;
        }
        if (swapp < 0) {
            double t = salp1;
            salp1 = salp2;
            salp2 = t;
            t = calp1;
            calp1 = calp2;
            calp2 = t;
            if ((outmask & 0x2005) != 0) {
                t = r.M12;
                r.M12 = r.M21;
                r.M21 = t;
            }
        }
        salp1 *= (double)(swapp * lonsign);
        calp1 *= (double)(swapp * latsign);
        salp2 *= (double)(swapp * lonsign);
        calp2 *= (double)(swapp * latsign);
        if ((outmask & 0x200) != 0) {
            r.azi1 = GeoMath.atan2d(salp1, calp1);
            r.azi2 = GeoMath.atan2d(salp2, calp2);
        }
        r.a12 = a12;
        return r;
    }

    public GeodesicLine Line(double lat1, double lon1, double azi1) {
        return this.Line(lat1, lon1, azi1, 32671);
    }

    public GeodesicLine Line(double lat1, double lon1, double azi1, int caps) {
        return new GeodesicLine(this, lat1, lon1, azi1, caps);
    }

    public double MajorRadius() {
        return this._a;
    }

    public double Flattening() {
        return this._f;
    }

    public double EllipsoidArea() {
        return Math.PI * 4 * this._c2;
    }

    protected static double SinCosSeries(boolean sinp, double sinx, double cosx, double[] c) {
        int k = c.length;
        int n = k - (sinp ? 1 : 0);
        double ar = 2.0 * (cosx - sinx) * (cosx + sinx);
        double y0 = (n & 1) != 0 ? c[--k] : 0.0;
        double y1 = 0.0;
        n /= 2;
        while (n-- != 0) {
            y1 = ar * y0 - y1 + c[--k];
            y0 = ar * y1 - y0 + c[--k];
        }
        return sinp ? 2.0 * sinx * cosx * y0 : cosx * (y0 - y1);
    }

    private LengthsV Lengths(double eps, double sig12, double ssig1, double csig1, double dn1, double ssig2, double csig2, double dn2, double cbet1, double cbet2, int outmask, double[] C1a, double[] C2a) {
        outmask &= 0xFF80;
        LengthsV v = new LengthsV();
        double m0x = 0.0;
        double J12 = 0.0;
        double A1 = 0.0;
        double A2 = 0.0;
        if ((outmask & 0x3405) != 0) {
            A1 = Geodesic.A1m1f(eps);
            Geodesic.C1f(eps, C1a);
            if ((outmask & 0x3005) != 0) {
                A2 = Geodesic.A2m1f(eps);
                Geodesic.C2f(eps, C2a);
                m0x = A1 - A2;
                A2 = 1.0 + A2;
            }
            A1 = 1.0 + A1;
        }
        if ((outmask & 0x401) != 0) {
            double B1 = Geodesic.SinCosSeries(true, ssig2, csig2, C1a) - Geodesic.SinCosSeries(true, ssig1, csig1, C1a);
            v.s12b = A1 * (sig12 + B1);
            if ((outmask & 0x3005) != 0) {
                double B2 = Geodesic.SinCosSeries(true, ssig2, csig2, C2a) - Geodesic.SinCosSeries(true, ssig1, csig1, C2a);
                J12 = m0x * sig12 + (A1 * B1 - A2 * B2);
            }
        } else if ((outmask & 0x3005) != 0) {
            for (int l = 1; l <= 6; ++l) {
                C2a[l] = A1 * C1a[l] - A2 * C2a[l];
            }
            J12 = m0x * sig12 + (Geodesic.SinCosSeries(true, ssig2, csig2, C2a) - Geodesic.SinCosSeries(true, ssig1, csig1, C2a));
        }
        if ((outmask & 0x1005) != 0) {
            v.m0 = m0x;
            v.m12b = dn2 * (csig1 * ssig2) - dn1 * (ssig1 * csig2) - csig1 * csig2 * J12;
        }
        if ((outmask & 0x2005) != 0) {
            double csig12 = csig1 * csig2 + ssig1 * ssig2;
            double t = this._ep2 * (cbet1 - cbet2) * (cbet1 + cbet2) / (dn1 + dn2);
            v.M12 = csig12 + (t * ssig2 - csig2 * J12) * ssig1 / dn1;
            v.M21 = csig12 - (t * ssig1 - csig1 * J12) * ssig2 / dn2;
        }
        return v;
    }

    private static double Astroid(double x, double y) {
        double k;
        double p = GeoMath.sq(x);
        double q = GeoMath.sq(y);
        double r = (p + q - 1.0) / 6.0;
        if (q != 0.0 || !(r <= 0.0)) {
            double S = p * q / 4.0;
            double r2 = GeoMath.sq(r);
            double r3 = r * r2;
            double disc = S * (S + 2.0 * r3);
            double u = r;
            if (disc >= 0.0) {
                double T3;
                double T = GeoMath.cbrt(T3 += (T3 = S + r3) < 0.0 ? -Math.sqrt(disc) : Math.sqrt(disc));
                u += T + (T != 0.0 ? r2 / T : 0.0);
            } else {
                double ang = Math.atan2(Math.sqrt(-disc), -(S + r3));
                u += 2.0 * r * Math.cos(ang / 3.0);
            }
            double v = Math.sqrt(GeoMath.sq(u) + q);
            double uv = u < 0.0 ? q / (v - u) : u + v;
            double w = (uv - q) / (2.0 * v);
            k = uv / (Math.sqrt(uv + GeoMath.sq(w)) + w);
        } else {
            k = 0.0;
        }
        return k;
    }

    private InverseStartV InverseStart(double sbet1, double cbet1, double dn1, double sbet2, double cbet2, double dn2, double lam12, double[] C1a, double[] C2a) {
        Pair p;
        InverseStartV w = new InverseStartV();
        w.sig12 = -1.0;
        double sbet12 = sbet2 * cbet1 - cbet2 * sbet1;
        double cbet12 = cbet2 * cbet1 + sbet2 * sbet1;
        double sbet12a = sbet2 * cbet1 + cbet2 * sbet1;
        boolean shortline = cbet12 >= 0.0 && sbet12 < 0.5 && cbet2 * lam12 < 0.5;
        double omg12 = lam12;
        if (shortline) {
            double sbetm2 = GeoMath.sq(sbet1 + sbet2);
            sbetm2 /= sbetm2 + GeoMath.sq(cbet1 + cbet2);
            w.dnm = Math.sqrt(1.0 + this._ep2 * sbetm2);
            omg12 /= this._f1 * w.dnm;
        }
        double somg12 = Math.sin(omg12);
        double comg12 = Math.cos(omg12);
        w.salp1 = cbet2 * somg12;
        w.calp1 = comg12 >= 0.0 ? sbet12 + cbet2 * sbet1 * GeoMath.sq(somg12) / (1.0 + comg12) : sbet12a - cbet2 * sbet1 * GeoMath.sq(somg12) / (1.0 - comg12);
        double ssig12 = GeoMath.hypot(w.salp1, w.calp1);
        double csig12 = sbet1 * sbet2 + cbet1 * cbet2 * comg12;
        if (shortline && ssig12 < this._etol2) {
            w.salp2 = cbet1 * somg12;
            w.calp2 = sbet12 - cbet1 * sbet2 * (comg12 >= 0.0 ? GeoMath.sq(somg12) / (1.0 + comg12) : 1.0 - comg12);
            p = GeoMath.norm(w.salp2, w.calp2);
            w.salp2 = p.first;
            w.calp2 = p.second;
            w.sig12 = Math.atan2(ssig12, csig12);
        } else if (!(Math.abs(this._n) > 0.1 || csig12 >= 0.0 || ssig12 >= 6.0 * Math.abs(this._n) * Math.PI * GeoMath.sq(cbet1))) {
            double y;
            double x;
            double lamscale;
            if (this._f >= 0.0) {
                double k2 = GeoMath.sq(sbet1) * this._ep2;
                double eps = k2 / (2.0 * (1.0 + Math.sqrt(1.0 + k2)) + k2);
                lamscale = this._f * cbet1 * this.A3f(eps) * Math.PI;
                double betscale = lamscale * cbet1;
                x = (lam12 - Math.PI) / lamscale;
                y = sbet12a / betscale;
            } else {
                double m0;
                double cbet12a = cbet2 * cbet1 - sbet2 * sbet1;
                double bet12a = Math.atan2(sbet12a, cbet12a);
                LengthsV v = this.Lengths(this._n, Math.PI + bet12a, sbet1, -cbet1, dn1, sbet2, cbet2, dn2, cbet1, cbet2, 4101, C1a, C2a);
                double m12b = v.m12b;
                x = -1.0 + m12b / (cbet1 * cbet2 * (m0 = v.m0) * Math.PI);
                double betscale = x < -0.01 ? sbet12a / x : -this._f * GeoMath.sq(cbet1) * Math.PI;
                lamscale = betscale / cbet1;
                y = (lam12 - Math.PI) / lamscale;
            }
            if (y > -tol1_ && x > -1.0 - xthresh_) {
                if (this._f >= 0.0) {
                    w.salp1 = Math.min(1.0, -x);
                    w.calp1 = -Math.sqrt(1.0 - GeoMath.sq(w.salp1));
                } else {
                    w.calp1 = Math.max(x > -Geodesic.tol1_ ? 0.0 : -1.0, x);
                    w.salp1 = Math.sqrt(1.0 - GeoMath.sq(w.calp1));
                }
            } else {
                double k = Geodesic.Astroid(x, y);
                double omg12a = lamscale * (this._f >= 0.0 ? -x * k / (1.0 + k) : -y * (1.0 + k) / k);
                somg12 = Math.sin(omg12a);
                comg12 = -Math.cos(omg12a);
                w.salp1 = cbet2 * somg12;
                w.calp1 = sbet12a - cbet2 * sbet1 * GeoMath.sq(somg12) / (1.0 - comg12);
            }
        }
        if (!(w.salp1 <= 0.0)) {
            p = GeoMath.norm(w.salp1, w.calp1);
            w.salp1 = p.first;
            w.calp1 = p.second;
        } else {
            w.salp1 = 1.0;
            w.calp1 = 0.0;
        }
        return w;
    }

    private Lambda12V Lambda12(double sbet1, double cbet1, double dn1, double sbet2, double cbet2, double dn2, double salp1, double calp1, boolean diffp, double[] C1a, double[] C2a, double[] C3a) {
        Lambda12V w = new Lambda12V();
        if (sbet1 == 0.0 && calp1 == 0.0) {
            calp1 = -tiny_;
        }
        double salp0 = salp1 * cbet1;
        double calp0 = GeoMath.hypot(calp1, salp1 * sbet1);
        w.ssig1 = sbet1;
        double somg1 = salp0 * sbet1;
        double comg1 = calp1 * cbet1;
        w.csig1 = comg1;
        Pair p = GeoMath.norm(w.ssig1, w.csig1);
        w.ssig1 = p.first;
        w.csig1 = p.second;
        w.salp2 = cbet2 != cbet1 ? salp0 / cbet2 : salp1;
        w.calp2 = cbet2 != cbet1 || Math.abs(sbet2) != -sbet1 ? Math.sqrt(GeoMath.sq(calp1 * cbet1) + (cbet1 < -sbet1 ? (cbet2 - cbet1) * (cbet1 + cbet2) : (sbet1 - sbet2) * (sbet1 + sbet2))) / cbet2 : Math.abs(calp1);
        w.ssig2 = sbet2;
        double somg2 = salp0 * sbet2;
        double comg2 = w.calp2 * cbet2;
        w.csig2 = comg2;
        p = GeoMath.norm(w.ssig2, w.csig2);
        w.ssig2 = p.first;
        w.csig2 = p.second;
        w.sig12 = Math.atan2(Math.max(w.csig1 * w.ssig2 - w.ssig1 * w.csig2, 0.0), w.csig1 * w.csig2 + w.ssig1 * w.ssig2);
        double omg12 = Math.atan2(Math.max(comg1 * somg2 - somg1 * comg2, 0.0), comg1 * comg2 + somg1 * somg2);
        double k2 = GeoMath.sq(calp0) * this._ep2;
        w.eps = k2 / (2.0 * (1.0 + Math.sqrt(1.0 + k2)) + k2);
        this.C3f(w.eps, C3a);
        double B312 = Geodesic.SinCosSeries(true, w.ssig2, w.csig2, C3a) - Geodesic.SinCosSeries(true, w.ssig1, w.csig1, C3a);
        double h0 = -this._f * this.A3f(w.eps);
        w.domg12 = salp0 * h0 * (w.sig12 + B312);
        w.lam12 = omg12 + w.domg12;
        if (diffp) {
            if (w.calp2 == 0.0) {
                w.dlam12 = -2.0 * this._f1 * dn1 / sbet1;
            } else {
                LengthsV v = this.Lengths(w.eps, w.sig12, w.ssig1, w.csig1, dn1, w.ssig2, w.csig2, dn2, cbet1, cbet2, 4101, C1a, C2a);
                w.dlam12 = v.m12b;
                Lambda12V lambda12V = w;
                lambda12V.dlam12 = lambda12V.dlam12 * (this._f1 / (w.calp2 * cbet2));
            }
        }
        return w;
    }

    protected double A3f(double eps) {
        return GeoMath.polyval(5, this._A3x, 0, eps);
    }

    protected void C3f(double eps, double[] c) {
        double mult = 1.0;
        int o = 0;
        for (int l = 1; l < 6; ++l) {
            int m = 6 - l - 1;
            c[l] = (mult *= eps) * GeoMath.polyval(m, this._C3x, o, eps);
            o += m + 1;
        }
    }

    protected void C4f(double eps, double[] c) {
        double mult = 1.0;
        int o = 0;
        for (int l = 0; l < 6; ++l) {
            int m = 6 - l - 1;
            c[l] = mult * GeoMath.polyval(m, this._C4x, o, eps);
            o += m + 1;
            mult *= eps;
        }
    }

    protected static double A1m1f(double eps) {
        double[] coeff = new double[]{1.0, 4.0, 64.0, 0.0, 256.0};
        int m = 3;
        double t = GeoMath.polyval(m, coeff, 0, GeoMath.sq(eps)) / coeff[m + 1];
        return (t + eps) / (1.0 - eps);
    }

    protected static void C1f(double eps, double[] c) {
        double[] coeff = new double[]{-1.0, 6.0, -16.0, 32.0, -9.0, 64.0, -128.0, 2048.0, 9.0, -16.0, 768.0, 3.0, -5.0, 512.0, -7.0, 1280.0, -7.0, 2048.0};
        double eps2 = GeoMath.sq(eps);
        double d = eps;
        int o = 0;
        for (int l = 1; l <= 6; ++l) {
            int m = (6 - l) / 2;
            c[l] = d * GeoMath.polyval(m, coeff, o, eps2) / coeff[o + m + 1];
            o += m + 2;
            d *= eps;
        }
    }

    protected static void C1pf(double eps, double[] c) {
        double[] coeff = new double[]{205.0, -432.0, 768.0, 1536.0, 4005.0, -4736.0, 3840.0, 12288.0, -225.0, 116.0, 384.0, -7173.0, 2695.0, 7680.0, 3467.0, 7680.0, 38081.0, 61440.0};
        double eps2 = GeoMath.sq(eps);
        double d = eps;
        int o = 0;
        for (int l = 1; l <= 6; ++l) {
            int m = (6 - l) / 2;
            c[l] = d * GeoMath.polyval(m, coeff, o, eps2) / coeff[o + m + 1];
            o += m + 2;
            d *= eps;
        }
    }

    protected static double A2m1f(double eps) {
        double[] coeff = new double[]{-11.0, -28.0, -192.0, 0.0, 256.0};
        int m = 3;
        double t = GeoMath.polyval(m, coeff, 0, GeoMath.sq(eps)) / coeff[m + 1];
        return (t - eps) / (1.0 + eps);
    }

    protected static void C2f(double eps, double[] c) {
        double[] coeff = new double[]{1.0, 2.0, 16.0, 32.0, 35.0, 64.0, 384.0, 2048.0, 15.0, 80.0, 768.0, 7.0, 35.0, 512.0, 63.0, 1280.0, 77.0, 2048.0};
        double eps2 = GeoMath.sq(eps);
        double d = eps;
        int o = 0;
        for (int l = 1; l <= 6; ++l) {
            int m = (6 - l) / 2;
            c[l] = d * GeoMath.polyval(m, coeff, o, eps2) / coeff[o + m + 1];
            o += m + 2;
            d *= eps;
        }
    }

    protected void A3coeff() {
        double[] coeff = new double[]{-3.0, 128.0, -2.0, -3.0, 64.0, -1.0, -3.0, -1.0, 16.0, 3.0, -1.0, -2.0, 8.0, 1.0, -1.0, 2.0, 1.0, 1.0};
        int o = 0;
        int k = 0;
        for (int j = 5; j >= 0; --j) {
            int m = Math.min(6 - j - 1, j);
            this._A3x[k++] = GeoMath.polyval(m, coeff, o, this._n) / coeff[o + m + 1];
            o += m + 2;
        }
    }

    protected void C3coeff() {
        double[] coeff = new double[]{3.0, 128.0, 2.0, 5.0, 128.0, -1.0, 3.0, 3.0, 64.0, -1.0, 0.0, 1.0, 8.0, -1.0, 1.0, 4.0, 5.0, 256.0, 1.0, 3.0, 128.0, -3.0, -2.0, 3.0, 64.0, 1.0, -3.0, 2.0, 32.0, 7.0, 512.0, -10.0, 9.0, 384.0, 5.0, -9.0, 5.0, 192.0, 7.0, 512.0, -14.0, 7.0, 512.0, 21.0, 2560.0};
        int o = 0;
        int k = 0;
        for (int l = 1; l < 6; ++l) {
            for (int j = 5; j >= l; --j) {
                int m = Math.min(6 - j - 1, j);
                this._C3x[k++] = GeoMath.polyval(m, coeff, o, this._n) / coeff[o + m + 1];
                o += m + 2;
            }
        }
    }

    protected void C4coeff() {
        double[] coeff = new double[]{97.0, 15015.0, 1088.0, 156.0, 45045.0, -224.0, -4784.0, 1573.0, 45045.0, -10656.0, 14144.0, -4576.0, -858.0, 45045.0, 64.0, 624.0, -4576.0, 6864.0, -3003.0, 15015.0, 100.0, 208.0, 572.0, 3432.0, -12012.0, 30030.0, 45045.0, 1.0, 9009.0, -2944.0, 468.0, 135135.0, 5792.0, 1040.0, -1287.0, 135135.0, 5952.0, -11648.0, 9152.0, -2574.0, 135135.0, -64.0, -624.0, 4576.0, -6864.0, 3003.0, 135135.0, 8.0, 10725.0, 1856.0, -936.0, 225225.0, -8448.0, 4992.0, -1144.0, 225225.0, -1440.0, 4160.0, -4576.0, 1716.0, 225225.0, -136.0, 63063.0, 1024.0, -208.0, 105105.0, 3584.0, -3328.0, 1144.0, 315315.0, -128.0, 135135.0, -2560.0, 832.0, 405405.0, 128.0, 99099.0};
        int o = 0;
        int k = 0;
        for (int l = 0; l < 6; ++l) {
            for (int j = 5; j >= l; --j) {
                int m = 6 - j - 1;
                this._C4x[k++] = GeoMath.polyval(m, coeff, o, this._n) / coeff[o + m + 1];
                o += m + 2;
            }
        }
    }

    private class Lambda12V {
        private double lam12;
        private double salp2;
        private double calp2;
        private double sig12;
        private double ssig1;
        private double csig1;
        private double ssig2;
        private double csig2;
        private double eps;
        private double domg12;
        private double dlam12 = Double.NaN;

        private Lambda12V() {
            this.domg12 = Double.NaN;
            this.eps = Double.NaN;
            this.csig2 = Double.NaN;
            this.ssig2 = Double.NaN;
            this.csig1 = Double.NaN;
            this.ssig1 = Double.NaN;
            this.sig12 = Double.NaN;
            this.calp2 = Double.NaN;
            this.salp2 = Double.NaN;
            this.lam12 = Double.NaN;
        }
    }

    private class InverseStartV {
        private double sig12;
        private double salp1;
        private double calp1;
        private double salp2;
        private double calp2;
        private double dnm = Double.NaN;

        private InverseStartV() {
            this.calp2 = Double.NaN;
            this.salp2 = Double.NaN;
            this.calp1 = Double.NaN;
            this.salp1 = Double.NaN;
            this.sig12 = Double.NaN;
        }
    }

    private class LengthsV {
        private double s12b;
        private double m12b;
        private double m0;
        private double M12;
        private double M21 = Double.NaN;

        private LengthsV() {
            this.M12 = Double.NaN;
            this.m0 = Double.NaN;
            this.m12b = Double.NaN;
            this.s12b = Double.NaN;
        }
    }
}

