/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.environmental.data.retriever.model;

import gr.cite.geoanalytics.environmental.data.retriever.model.Data;
import gr.cite.geoanalytics.environmental.data.retriever.model.Unit;

public class Temperature
extends Data {
    public Temperature(Data data) {
        super(data);
    }

    @Override
    public Integer getValueAsInt(Unit unit) {
        if (unit != null && this.value != null) {
            Float value = unit == Unit.CELCIUS ? this.getCelciusTemperature() : this.getKelvinTemperature();
            return value != null ? Integer.valueOf(Math.round(value.floatValue())) : null;
        }
        return null;
    }

    private Float getKelvinTemperature() {
        if (this.value == null || this.value.floatValue() < 0.0f) {
            return null;
        }
        return this.value;
    }

    private Float getCelciusTemperature() {
        if (this.value == null || this.value.floatValue() < 0.0f) {
            return null;
        }
        return Float.valueOf(this.value.floatValue() - 273.15f);
    }
}

