/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.geometry.primitive;

import java.util.List;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Solid;
import org.opengis.geometry.primitive.SolidBoundary;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfacePatch;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface PrimitiveFactory {
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    @UML(identifier="GM_Primitive(GM_Envelope)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Primitive createPrimitive(Envelope var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Point createPoint(double[] var1) throws MismatchedDimensionException;

    @UML(identifier="GM_Point(GM_Position)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Point createPoint(Position var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Curve(GM_CurveSegment[1..n])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Curve createCurve(List<CurveSegment> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Surface(GM_SurfacePatch[1..n])", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Surface createSurface(List<SurfacePatch> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Surface(GM_SurfaceBoundary)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Surface createSurface(SurfaceBoundary var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public SurfaceBoundary createSurfaceBoundary(Ring var1, List<Ring> var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    @UML(identifier="GM_Solid(GM_SolidBoundary)", obligation=Obligation.MANDATORY, specification=Specification.ISO_19107)
    public Solid createSolid(SolidBoundary var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Ring createRing(List<OrientableCurve> var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;
}

