/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.geotools.swing.dialog.AbstractSimpleDialog;
import org.geotools.swing.dialog.DialogUtils;
import org.geotools.swing.dialog.TextReporterListener;
import org.geotools.util.logging.Logging;

public class JTextReporter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.swing");
    private static final long DIALOG_CREATION_TIMEOUT = 1000L;
    public static final int FLAG_MODAL = 1;
    public static final int FLAG_ALWAYS_ON_TOP = 2;
    public static final int FLAG_RESIZABLE = 4;
    public static final int DEFAULT_FLAGS = 6;
    public static final int DEFAULT_TEXTAREA_ROWS = 20;
    public static final int DEFAULT_TEXTAREA_COLS = 50;
    public static String NEWLINE = System.getProperty("line.separator");
    public static final char DEFAULT_SEPARATOR_CHAR = '-';

    public static Connection showDialog(String title) {
        return JTextReporter.showDialog(title, null);
    }

    public static Connection showDialog(String title, String initialText) {
        return JTextReporter.showDialog(title, initialText, 6);
    }

    public static Connection showDialog(String title, String initialText, int flags) {
        return JTextReporter.showDialog(title, initialText, flags, 20, 50);
    }

    public static Connection showDialog(final String title, final String initialText, final int flags, final int textAreaRows, final int textAreaCols) {
        final Connection[] conn = new Connection[1];
        if (SwingUtilities.isEventDispatchThread()) {
            conn[0] = JTextReporter.doShowDialog(title, initialText, flags, textAreaRows, textAreaCols);
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    conn[0] = JTextReporter.doShowDialog(title, initialText, flags, textAreaRows, textAreaCols);
                    latch.countDown();
                }
            });
            try {
                latch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                LOGGER.severe("Thread interrupted while setting up text reporter");
                return null;
            }
        }
        return conn[0];
    }

    private static Connection doShowDialog(String title, String initialText, int flags, int textAreaRows, int textAreaCols) {
        TextDialog dialog = new TextDialog(title, initialText, flags, textAreaRows, textAreaCols);
        Connection conn = new Connection(dialog);
        dialog.setConnection(conn);
        DialogUtils.showCentred(dialog);
        return conn;
    }

    static class FileHelper {
        private static File cwd;

        FileHelper() {
        }

        static File getFile() {
            JFileChooser chooser = new JFileChooser(cwd);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return true;
                }

                @Override
                public String getDescription() {
                    return "All files";
                }
            });
            if (chooser.showSaveDialog(null) != 0) {
                return null;
            }
            cwd = chooser.getCurrentDirectory();
            return chooser.getSelectedFile();
        }
    }

    static class TextDialog
    extends AbstractSimpleDialog {
        private final JTextArea textArea;

        private static boolean isFlagSet(int flags, int testFlag) {
            return (flags & testFlag) > 0;
        }

        private TextDialog(String title, String initialText, int flags, int textAreaRows, int textAreaCols) {
            super((JDialog)null, title, TextDialog.isFlagSet(flags, 1), TextDialog.isFlagSet(flags, 4));
            this.setAlwaysOnTop(TextDialog.isFlagSet(flags, 2));
            this.textArea = new JTextArea(textAreaRows, textAreaCols);
            this.initComponents();
            if (initialText != null && initialText.length() > 0) {
                this.append(initialText);
            }
        }

        private void setConnection(final Connection conn) {
            this.addWindowListener(new WindowAdapter(){
                private boolean flag = false;

                @Override
                public void windowClosing(WindowEvent e) {
                    if (!this.flag) {
                        conn.setDialogClosed();
                        this.flag = true;
                    }
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    if (!this.flag) {
                        conn.setDialogClosed();
                        this.flag = true;
                    }
                }
            });
        }

        @Override
        public JPanel createControlPanel() {
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
            this.textArea.setAutoscrolls(true);
            JScrollPane scrollPane = new JScrollPane(this.textArea);
            JPanel panel = new JPanel(new MigLayout("wrap 1", "[grow]", "[grow][]"));
            panel.add((Component)scrollPane, "grow");
            return panel;
        }

        @Override
        protected JPanel createButtonPanel() {
            JPanel panel = new JPanel(new MigLayout());
            JButton copyBtn = new JButton("Copy to clipboard");
            copyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onCopyToClipboard();
                }
            });
            panel.add((Component)copyBtn, "align center");
            JButton saveBtn = new JButton("Save...");
            saveBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onSave();
                }
            });
            panel.add(saveBtn);
            JButton clearBtn = new JButton("Clear");
            clearBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onClear();
                }
            });
            panel.add(clearBtn);
            JButton closeBtn = new JButton("Close");
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.closeDialog();
                }
            });
            panel.add(closeBtn);
            return panel;
        }

        @Override
        public void onOK() {
            this.closeDialog();
        }

        private void onCopyToClipboard() {
            if (this.textArea.getDocument().getLength() > 0) {
                StringSelection sel = new StringSelection(this.textArea.getText());
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(sel, sel);
            }
        }

        private void onSave() {
            int len = this.textArea.getDocument().getLength();
            if (len > 0) {
                Writer writer = null;
                try {
                    boolean alwaysOnTop = this.isAlwaysOnTop();
                    this.setAlwaysOnTop(false);
                    File file = FileHelper.getFile();
                    this.setAlwaysOnTop(alwaysOnTop);
                    if (file != null) {
                        writer = new BufferedWriter(new FileWriter(file));
                        for (int line = 0; line < this.textArea.getLineCount(); ++line) {
                            int end;
                            int start = this.textArea.getLineStartOffset(line);
                            String lineText = this.textArea.getText(start, (end = this.textArea.getLineEndOffset(line)) - start);
                            if (lineText.endsWith("\n")) {
                                lineText = lineText.substring(0, lineText.length() - 1);
                            }
                            writer.write(lineText);
                            writer.write(NEWLINE);
                        }
                    }
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException("Internal error getting report to save");
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private void onClear() {
            int len = this.textArea.getDocument().getLength();
            if (len > 0) {
                try {
                    this.textArea.getDocument().remove(0, len);
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }

        private void append(String text) {
            this.append(text, 0);
        }

        private void append(String text, int indent) {
            String appendText;
            int startLine = this.textArea.getLineCount();
            if (indent > 0) {
                char[] c = new char[indent];
                Arrays.fill(c, ' ');
                String pad = String.valueOf(c);
                appendText = pad + text.replaceAll("\\n", "\n" + pad);
            } else {
                appendText = text;
            }
            this.textArea.append(appendText);
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        }

        private String getText() {
            return this.textArea.getText();
        }
    }

    public static class Connection {
        private final WeakReference<TextDialog> dialogRef;
        private final List<TextReporterListener> listeners;
        private final ReadWriteLock updateLock;
        private final AtomicBoolean active;

        private Connection(TextDialog dialog) {
            this.dialogRef = new WeakReference<TextDialog>(dialog);
            this.listeners = new ArrayList<TextReporterListener>();
            this.updateLock = new ReentrantReadWriteLock();
            this.active = new AtomicBoolean(true);
        }

        public boolean isOpen() {
            this.updateLock.readLock().lock();
            try {
                boolean bl = this.active.get();
                return bl;
            }
            finally {
                this.updateLock.readLock().unlock();
            }
        }

        public void addListener(TextReporterListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.updateLock.writeLock().lock();
            try {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
            finally {
                this.updateLock.writeLock().unlock();
            }
        }

        public void removeListener(TextReporterListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.updateLock.writeLock().lock();
            try {
                this.listeners.remove(listener);
            }
            finally {
                this.updateLock.writeLock().unlock();
            }
        }

        public void removeAllListeners() {
            this.updateLock.writeLock().lock();
            try {
                this.listeners.clear();
            }
            finally {
                this.updateLock.writeLock().unlock();
            }
        }

        public Connection append(String text) {
            return this.append(text, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection append(String text, int indent) {
            this.updateLock.writeLock().lock();
            try {
                TextDialog dialog = (TextDialog)this.dialogRef.get();
                if (dialog == null) {
                    LOGGER.severe("Appending text to an expired JTextReporter connection");
                } else {
                    if (SwingUtilities.isEventDispatchThread()) {
                        dialog.append(text, indent);
                    } else {
                        this.doAppendOnEDT(dialog, text, indent);
                    }
                    this.fireEvent(StateChange.TEXT_UPDATED);
                }
                Connection connection = this;
                return connection;
            }
            finally {
                this.updateLock.writeLock().unlock();
            }
        }

        public Connection appendSeparatorLine(int n) {
            return this.appendSeparatorLine(n, '-');
        }

        public Connection appendSeparatorLine(int n, char c) {
            char[] carray = new char[n];
            Arrays.fill(carray, c);
            this.append(String.valueOf(carray));
            this.appendNewline();
            return this;
        }

        public Connection appendNewline() {
            this.append(NEWLINE);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText() {
            this.updateLock.readLock().lock();
            final String[] rtnText = new String[1];
            try {
                final TextDialog dialog = (TextDialog)this.dialogRef.get();
                if (dialog == null) {
                    LOGGER.severe("Retrieving text from an expired JTextReporter connection");
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    rtnText[0] = dialog.getText();
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            rtnText[0] = dialog.getText();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    LOGGER.severe("Thread interrupted while getting text from text reporter");
                    rtnText[0] = "";
                }
                catch (InvocationTargetException ex) {
                    LOGGER.log(Level.SEVERE, "Error while trying to get text from text reporter", ex);
                    rtnText[0] = "";
                    return rtnText[0];
                }
            }
            finally {
                this.updateLock.readLock().unlock();
                return rtnText[0];
            }
        }

        public void closeDialog() {
            this.updateLock.writeLock().lock();
            try {
                if (this.active.get()) {
                    final TextDialog dialog = (TextDialog)this.dialogRef.get();
                    if (dialog != null) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                dialog.closeDialog();
                            }
                        });
                    }
                } else {
                    LOGGER.info("This connection has expired");
                }
            }
            catch (InterruptedException ex) {
                LOGGER.severe("Thread interrupted while attmpting to close text reporter");
            }
            catch (InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Error while trying to close text reporter", ex);
            }
            finally {
                if (this.active.get()) {
                    this.setDialogClosed();
                }
                this.updateLock.writeLock().unlock();
            }
        }

        private void doAppendOnEDT(final TextDialog dialog, final String text, final int indent) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dialog.append(text, indent);
                    }
                });
            }
            catch (InterruptedException ex) {
                LOGGER.severe("Interrupted while appending text");
            }
            catch (InvocationTargetException ex) {
                LOGGER.log(Level.SEVERE, "Unable to append text", ex);
            }
        }

        private void setDialogClosed() {
            this.updateLock.writeLock().lock();
            try {
                this.dialogRef.clear();
                this.active.set(false);
                this.fireEvent(StateChange.DIALOG_CLOSED);
            }
            finally {
                this.removeAllListeners();
                this.updateLock.writeLock().unlock();
            }
        }

        private void fireEvent(StateChange type) {
            for (TextReporterListener listener : this.listeners) {
                switch (type) {
                    case DIALOG_CLOSED: {
                        listener.onReporterClosed();
                        break;
                    }
                    case TEXT_UPDATED: {
                        listener.onReporterUpdated();
                    }
                }
            }
        }

        private static enum StateChange {
            TEXT_UPDATED,
            DIALOG_CLOSED;

        }
    }
}

