/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.geotools.swing.dialog.AbstractSimpleDialog;
import org.geotools.swing.dialog.DialogUtils;
import org.geotools.swing.locale.LocaleUtils;

public class JExceptionReporter {
    private JExceptionReporter() {
    }

    public static void showDialog(Throwable exception) {
        JExceptionReporter.showDialog(exception, null);
    }

    public static void showDialog(final Throwable exception, final String message) {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            JExceptionReporter.doShowDialog(exception, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JExceptionReporter.doShowDialog(exception, message);
                }
            });
        }
    }

    private static void doShowDialog(Throwable exception, String message) {
        String title = exception.getClass().getSimpleName();
        if (JExceptionReporter.empty(message) && JExceptionReporter.empty(message = exception.getLocalizedMessage())) {
            message = LocaleUtils.getValue("Common", "UnspecifiedError");
        }
        ReportingDialog dialog = new ReportingDialog(title, message);
        DialogUtils.showCentred(dialog);
    }

    private static boolean empty(String s) {
        return s == null || s.trim().length() == 0;
    }

    static class ReportingDialog
    extends AbstractSimpleDialog {
        private static final int DEFAULT_WIDTH = 400;
        private static final int DEFAULT_HEIGHT = 200;
        private static final int MARGIN = 5;
        private final String message;

        private ReportingDialog(String title, String message) {
            super(title);
            this.message = message;
            this.setDefaultCloseOperation(2);
            this.initComponents();
        }

        @Override
        public JPanel createControlPanel() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            String text = String.format("<html>%s</html>", this.message);
            int w = 390;
            Dimension dim = DialogUtils.getHtmlLabelTextExtent(text, w, true);
            JLabel label = new JLabel(text);
            label.setPreferredSize(dim);
            panel.add(label);
            panel.setPreferredSize(new Dimension(400, dim.height + 20));
            return panel;
        }

        @Override
        protected JPanel createButtonPanel() {
            JPanel panel = new JPanel();
            JButton button = new JButton("Close");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onOK();
                }
            });
            panel.add(button);
            return panel;
        }

        @Override
        public void onOK() {
            this.closeDialog();
        }
    }
}

