/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public abstract class AbstractSimpleDialog
extends JDialog {
    private boolean initialized = false;

    public AbstractSimpleDialog(String title) {
        this((JFrame)null, title);
    }

    public AbstractSimpleDialog(JFrame parent, String title) {
        this(parent, title, true, false);
    }

    public AbstractSimpleDialog(JDialog parent, String title) {
        this(parent, title, true, false);
    }

    public AbstractSimpleDialog(JFrame parent, String title, boolean modal, boolean resizable) {
        super((Frame)parent, title);
        this.commonInit(modal, resizable);
    }

    public AbstractSimpleDialog(JDialog parent, String title, boolean modal, boolean resizable) {
        super((Dialog)parent, title);
        this.commonInit(modal, resizable);
    }

    private void commonInit(boolean modal, boolean resizable) {
        if (modal) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        } else {
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
        this.setResizable(resizable);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.initialized) {
            throw new IllegalStateException("Sub-class did not call initComponents() before showing dialog");
        }
        super.setVisible(b);
    }

    protected void initComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createControlPanel(), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        this.add(panel);
        this.pack();
        this.initialized = true;
    }

    public abstract JPanel createControlPanel();

    public abstract void onOK();

    public void onCancel() {
        this.closeDialog();
    }

    public void closeDialog() {
        this.dispose();
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel(new MigLayout());
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimpleDialog.this.onOK();
            }
        });
        panel.add((Component)okBtn, "align center");
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimpleDialog.this.onCancel();
            }
        });
        panel.add(cancelBtn);
        return panel;
    }
}

