/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.opengis.feature.simple.SimpleFeature;

public class RenderingTask
implements Callable<Boolean>,
RenderListener {
    private final Graphics2D destinationGraphics;
    private final Rectangle deviceArea;
    private final ReferencedEnvelope worldArea;
    private final AffineTransform worldToScreenTransform;
    private final GTRenderer renderer;
    private final AtomicBoolean running;
    private final AtomicBoolean failed;
    private final AtomicBoolean cancelled;

    public RenderingTask(MapContent mapContent, Graphics2D destinationGraphics, GTRenderer renderer) {
        if (mapContent == null) {
            throw new IllegalArgumentException("mapContent must not be null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer must not be null");
        }
        if (destinationGraphics == null) {
            throw new IllegalArgumentException("graphics must not be null");
        }
        this.destinationGraphics = destinationGraphics;
        this.deviceArea = mapContent.getViewport().getScreenArea();
        this.worldArea = mapContent.getViewport().getBounds();
        this.worldToScreenTransform = mapContent.getViewport().getWorldToScreen();
        this.renderer = renderer;
        this.running = new AtomicBoolean(false);
        this.failed = new AtomicBoolean(false);
        this.cancelled = new AtomicBoolean(false);
    }

    public void cancel() {
        if (this.running.get()) {
            this.renderer.stopRendering();
        }
        this.cancelled.set(true);
    }

    @Override
    public Boolean call() throws Exception {
        if (!this.cancelled.get()) {
            try {
                this.renderer.addRenderListener(this);
                this.running.set(true);
                this.renderer.paint(this.destinationGraphics, this.deviceArea, this.worldArea, this.worldToScreenTransform);
            }
            finally {
                this.renderer.removeRenderListener(this);
                this.running.set(false);
            }
        }
        return !this.isFailed() && !this.isCancelled();
    }

    @Override
    public void featureRenderer(SimpleFeature feature) {
    }

    @Override
    public void errorOccurred(Exception e) {
        this.running.set(false);
        this.failed.set(true);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }
}

