/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Literal;
import org.picocontainer.MutablePicoContainer;

public class SLDColorMapEntryBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;
    FilterFactory filterFactory;

    public SLDColorMapEntryBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
    }

    @Override
    public QName getTarget() {
        return SLD.COLORMAPENTRY;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return ColorMapEntry.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ColorMapEntry entry = this.styleFactory.createColorMapEntry();
        Literal color = this.filterFactory.literal((String)node.getAttributeValue("color"));
        entry.setColor(color);
        if (node.getAttributeValue("opacity") != null) {
            Double opacity = (Double)node.getAttributeValue("opacity");
            entry.setOpacity(this.filterFactory.literal(opacity));
        }
        if (node.getAttributeValue("quantity") != null) {
            Double quantity = (Double)node.getAttributeValue("quantity");
            entry.setQuantity(this.filterFactory.literal(quantity));
        }
        if (node.getAttributeValue("label") != null) {
            String label = (String)node.getAttributeValue("label");
            entry.setLabel(label);
        }
        return entry;
    }
}

