/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.simple.FeatureCollectionEncoderDelegate;
import org.geotools.gml2.simple.GMLDelegate;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.EnvelopeEncoder;
import org.geotools.gml3.simple.GeometryCollectionEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.XSD;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class GML3FeatureCollectionEncoderDelegate
extends FeatureCollectionEncoderDelegate {
    public GML3FeatureCollectionEncoderDelegate(SimpleFeatureCollection features, Encoder encoder) {
        super(features, encoder, new GML3Delegate(encoder));
    }

    static class GML3Delegate
    implements GMLDelegate {
        SrsSyntax srsSyntax;
        static final QualifiedName FEATURE_MEMBERS = new QualifiedName("http://www.opengis.net/gml", GML.featureMembers.getLocalPart(), "gml");
        static final QualifiedName FEATURE_MEMBER = new QualifiedName("http://www.opengis.net/gml", GML.featureMember.getLocalPart(), "gml");
        QualifiedName featureMembers;
        QualifiedName featureMember;
        private String gmlPrefix;
        private String gmlUri;
        private int numDecimals;
        private boolean encodeSeparateMember;

        public GML3Delegate(Encoder encoder) {
            this.gmlPrefix = this.findGMLPrefix(encoder);
            String gmlURI = encoder.getNamespaces().getURI(this.gmlPrefix);
            this.gmlUri = gmlURI != null ? gmlURI : "http://www.opengis.net/gml";
            this.featureMembers = FEATURE_MEMBERS.derive(this.gmlPrefix, gmlURI);
            this.featureMember = FEATURE_MEMBER.derive(this.gmlPrefix, gmlURI);
            this.srsSyntax = (SrsSyntax)((Object)encoder.getContext().getComponentInstanceOfType(SrsSyntax.class));
            this.numDecimals = this.getNumDecimals(encoder.getConfiguration());
            this.encodeSeparateMember = encoder.getConfiguration().hasProperty(GMLConfiguration.ENCODE_FEATURE_MEMBER);
        }

        String findGMLPrefix(Encoder encoder) {
            NamespaceSupport ns = encoder.getNamespaces();
            Enumeration<String> p = ns.getPrefixes();
            while (p.hasMoreElements()) {
                String prefix = p.nextElement();
                String uri = ns.getURI(prefix);
                if (!uri.startsWith("http://www.opengis.net/gml")) continue;
                return prefix;
            }
            return "gml";
        }

        private int getNumDecimals(Configuration configuration) {
            GMLConfiguration config = configuration instanceof GMLConfiguration ? (GMLConfiguration)configuration : configuration.getDependency(GMLConfiguration.class);
            if (config == null) {
                return 6;
            }
            return config.getNumDecimals();
        }

        @Override
        public List getFeatureProperties(SimpleFeature f, XSDElementDeclaration element, Encoder e) {
            return GML3EncodingUtils.INSTANCE.AbstractFeatureTypeGetProperties(f, element, e.getSchemaIndex(), e.getConfiguration());
        }

        @Override
        public EnvelopeEncoder createEnvelopeEncoder(Encoder e) {
            return new EnvelopeEncoder(e, this.gmlPrefix, this.gmlUri);
        }

        @Override
        public void setSrsNameAttribute(AttributesImpl atts, CoordinateReferenceSystem crs) {
            atts.addAttribute(null, "srsName", "srsName", null, GML3EncodingUtils.toURI(crs, this.srsSyntax).toString());
        }

        @Override
        public void setGeometryDimensionAttribute(AttributesImpl atts, int dimension) {
            atts.addAttribute(null, "srsDimension", "srsDimension", null, String.valueOf(dimension));
        }

        @Override
        public void initFidAttribute(AttributesImpl atts) {
            atts.addAttribute("http://www.opengis.net/gml", "id", "gml:id", null, "");
        }

        @Override
        public void startFeatures(GMLWriter handler) throws Exception {
            if (!this.encodeSeparateMember) {
                handler.startElement(this.featureMembers, null);
            }
        }

        @Override
        public void startFeature(GMLWriter handler) throws Exception {
            if (this.encodeSeparateMember) {
                handler.startElement(this.featureMember, null);
            }
        }

        @Override
        public void endFeature(GMLWriter handler) throws Exception {
            if (this.encodeSeparateMember) {
                handler.endElement(this.featureMember);
            }
        }

        @Override
        public void endFeatures(GMLWriter handler) throws Exception {
            if (!this.encodeSeparateMember) {
                handler.endElement(this.featureMembers);
            }
        }

        @Override
        public void registerGeometryEncoders(Map<Class, GeometryEncoder> encoders, Encoder encoder) {
            encoders.put(Point.class, new PointEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(MultiPoint.class, new MultiPointEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(LineString.class, new LineStringEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(LinearRing.class, new LinearRingEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(MultiLineString.class, new MultiLineStringEncoder(encoder, this.gmlPrefix, this.gmlUri, false));
            encoders.put(MultiCurve.class, new MultiLineStringEncoder(encoder, this.gmlPrefix, this.gmlUri, true));
            encoders.put(Polygon.class, new PolygonEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(MultiPolygon.class, new MultiPolygonEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CircularString.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CompoundCurve.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CircularRing.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CompoundRing.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(GeometryCollection.class, new GeometryCollectionEncoder(encoder, this.gmlPrefix, this.gmlUri));
        }

        @Override
        public String getGmlPrefix() throws Exception {
            return this.gmlPrefix;
        }

        @Override
        public boolean supportsTuples() {
            return false;
        }

        @Override
        public void startTuple(GMLWriter output) {
        }

        @Override
        public void endTuple(GMLWriter output) {
        }

        @Override
        public XSD getSchema() {
            return GML.getInstance();
        }

        @Override
        public int getNumDecimals() {
            return this.numDecimals;
        }

        @Override
        public boolean forceDecimalEncoding() {
            return false;
        }
    }
}

