/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.AttributeReader;
import org.opengis.feature.type.AttributeDescriptor;

public class JoiningAttributeReader
implements AttributeReader {
    private AttributeReader[] readers;
    private int[] index;
    private AttributeDescriptor[] metaData;

    public JoiningAttributeReader(AttributeReader[] readers) {
        this.readers = readers;
        this.metaData = this.joinMetaData(readers);
    }

    private AttributeDescriptor[] joinMetaData(AttributeReader[] readers) {
        int total = 0;
        this.index = new int[readers.length];
        int ii = readers.length;
        for (int i = 0; i < ii; ++i) {
            this.index[i] = total;
            total += readers[i].getAttributeCount();
        }
        AttributeDescriptor[] md = new AttributeDescriptor[total];
        int idx = 0;
        int ii2 = readers.length;
        for (int i = 0; i < ii2; ++i) {
            int jj = readers[i].getAttributeCount();
            for (int j = 0; j < jj; ++j) {
                md[idx] = readers[i].getAttributeType(j);
                ++idx;
            }
        }
        return md;
    }

    @Override
    public void close() throws IOException {
        IOException dse = null;
        int ii = this.readers.length;
        for (int i = 0; i < ii; ++i) {
            try {
                this.readers[i].close();
                continue;
            }
            catch (IOException e) {
                dse = e;
            }
        }
        if (dse != null) {
            throw dse;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        int ii = this.readers.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.readers[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void next() throws IOException {
        int ii = this.readers.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.readers[i].hasNext()) continue;
            this.readers[i].next();
        }
    }

    @Override
    public Object read(int idx) throws IOException {
        AttributeReader reader = null;
        for (int i = this.index.length - 1; i >= 0; --i) {
            if (idx < this.index[i]) continue;
            idx -= this.index[i];
            reader = this.readers[i];
            break;
        }
        if (reader == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return reader.read(idx);
    }

    @Override
    public int getAttributeCount() {
        return this.metaData.length;
    }

    @Override
    public AttributeDescriptor getAttributeType(int i) {
        return this.metaData[i];
    }
}

