/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicType;

public class MosaicDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = 2718297230579888333L;
    private static final String[][] resources = new String[][]{{"GlobalName", "Mosaic"}, {"LocalName", "Mosaic"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "A different mosaic operation which supports noData and doesn't supports threshold"}, {"DocURL", "wiki github non already available"}, {"Version", "1.0"}, {"arg0Desc", "Mosaic Type"}, {"arg1Desc", "The source Alpha bands"}, {"arg2Desc", "The source ROIs"}, {"arg3Desc", "Thresholds used for the mosaic"}, {"arg4Desc", "Background values"}, {"arg5Desc", "No data  Values"}};
    private static final Class[] paramClasses = new Class[]{MosaicType.class, PlanarImage[].class, ROI[].class, double[][].class, double[].class, Range[].class};
    private static final String[] paramNames = new String[]{"mosaicType", "sourceAlpha", "sourceROI", "sourceThreshold", "backgroundValues", "nodata"};
    private static final Object[] paramDefaults = new Object[]{javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, new double[][]{{1.0}}, new double[]{0.0}, null};

    public MosaicDescriptor() {
        super(resources, new String[]{"rendered"}, 0, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public static RenderedOp create(RenderedImage[] sources, MosaicType mosaicType, PlanarImage[] sourceAlpha, ROI[] sourceROI, double[][] sourceThreshold, double[] backgroundValues, Range[] nodata, RenderingHints renderingHints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Mosaic", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            pb.addSource(sources[i]);
        }
        pb.setParameter("mosaicType", mosaicType);
        pb.setParameter("sourceAlpha", sourceAlpha);
        pb.setParameter("sourceROI", sourceROI);
        pb.setParameter("sourceThreshold", sourceThreshold);
        pb.setParameter("backgroundValues", backgroundValues);
        pb.setParameter("nodata", nodata);
        return JAI.create("Mosaic", pb, renderingHints);
    }
}

