/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.environmental.data.retriever;

import com.vividsolutions.jts.util.Assert;
import gr.cite.geoanalytics.environmental.data.retriever.DateResourceResolver;
import gr.cite.geoanalytics.environmental.data.retriever.GeoTiffCoverageRetriever;
import gr.cite.geoanalytics.environmental.data.retriever.model.Data;
import gr.cite.geoanalytics.environmental.data.retriever.model.Unit;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.DirectPosition2D;

public abstract class DataRetriever<T extends Data> {
    private static final Logger logger = LogManager.getLogger(DataRetriever.class);
    private DateResourceResolver dateResourceResolver;
    private GeoTiffCoverageRetriever geotiffCoverageRetriever;

    abstract T castData(Data var1);

    public DataRetriever(String dataFolder, String dataFileExtension) {
        dataFolder = !dataFolder.endsWith("/") ? dataFolder + "/" : dataFolder;
        try {
            this.dateResourceResolver = new DateResourceResolver(dataFolder, dataFileExtension);
            this.geotiffCoverageRetriever = new GeoTiffCoverageRetriever(this.dateResourceResolver);
        }
        catch (Exception e) {
            logger.error("Failed to initialize " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    public T getByDateLatLong(String date, double latitude, double longitude) throws Exception {
        try {
            Assert.isTrue(date != null && date.length() > 0, "Date cannot be empty");
            Assert.isTrue(latitude >= -90.0 && latitude <= 90.0, "Latitude cannot exceed the range [-90, 90]");
            Assert.isTrue(longitude >= -180.0 && longitude <= 180.0, "Longitude cannot exceed the range [-180, 180]");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        date = date.contains("/") ? date.replace("/", "-") : date;
        date = date.contains(".") ? date.replace(".", "-") : date;
        Date formattedDate = null;
        try {
            formattedDate = new SimpleDateFormat("dd-mm-yyyy").parse(date);
        }
        catch (Exception e) {
            throw new Exception("Date " + date + " must match the dd-mm-yyyy format", e);
        }
        Data data = null;
        try {
            if (formattedDate != null) {
                GridCoverage2D coverage = this.geotiffCoverageRetriever.getCoverageByDate(date);
                data = (Data)this.getDataOfCoverage(coverage, date, latitude, longitude);
            }
        }
        catch (Exception e) {
            throw new Exception("Could not retrieve data for requested date: " + date, e);
        }
        if (data != null) {
            // empty if block
        }
        return this.castData(data);
    }

    public Map<String, T> getByLatLong(double latitude, double longitude) throws Exception {
        LinkedHashMap<String, T> results = new LinkedHashMap<String, T>();
        List<String> dates = this.dateResourceResolver.getAllDates();
        for (String date : dates) {
            try {
                T data = this.getByDateLatLong(date, latitude, longitude);
                results.put(date, data);
            }
            catch (Exception e) {
                throw new Exception("Could not retrieve all available data", e);
            }
        }
        return results;
    }

    public Integer[] getByLatLongAsArray(double latitude, double longitude) throws Exception {
        return this.getByLatLongAsArray(latitude, longitude, null);
    }

    public Integer[] getByLatLongAsArray(double latitude, double longitude, Unit unit) throws Exception {
        Map<String, T> results = this.getByLatLong(latitude, longitude);
        Integer[] array = new Integer[24];
        int index = 0;
        for (Data data : results.values()) {
            if (data == null) {
                return null;
            }
            Integer value = data.getValueAsInt(unit);
            if (value == null) {
                return null;
            }
            array[index++] = value;
        }
        return array;
    }

    private T getDataOfCoverage(GridCoverage2D coverage, String date, double latitude, double longitude) throws Exception {
        double minX = this.getBoundingBox(coverage).getMinX();
        double maxX = this.getBoundingBox(coverage).getMaxX();
        double minY = this.getBoundingBox(coverage).getMinY();
        double maxY = this.getBoundingBox(coverage).getMaxY();
        if (latitude <= minY || latitude >= maxY) {
            logger.error("Latitude " + latitude + " is out of bounds! Must be enclosed within [" + minY + ", " + maxY + "]");
            return null;
        }
        if (longitude <= minX || longitude >= maxX) {
            logger.error("Longitude " + longitude + " is out of bounds! Must be enclosed within [" + minX + ", " + maxX + "]");
            return null;
        }
        float value = ((float[])coverage.evaluate(new DirectPosition2D(coverage.getCoordinateReferenceSystem2D(), longitude, latitude)))[0];
        Data data = new Data();
        data.setDate(date);
        data.setLatitude(latitude);
        data.setLongitude(longitude);
        data.setValue(Float.valueOf(value));
        return this.castData(data);
    }

    private Rectangle getBoundingBox(GridCoverage2D coverage) throws Exception {
        return coverage.getEnvelope2D().getBounds();
    }
}

