/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.style;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Style\"")
@JsonIgnoreProperties(value={"creator"})
public class Style
implements Entity,
Identifiable,
Stampable,
Serializable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"STL_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"STL_Name\"", nullable=false, length=250)
    private String name = null;
    @Column(name="\"STL_Description\"", nullable=false, length=1000)
    private String description = null;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"STL_Content\"", columnDefinition="xml", nullable=true)
    private String content = null;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="\"STL_Creator\"", nullable=false)
    private Principal creator = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"STL_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"STL_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Style withID(String id) {
        this.id = UUID.fromString(id);
        return this;
    }

    public Style withName(String name) {
        this.name = name;
        return this;
    }

    public Style withDescription(String description) {
        this.description = description;
        return this;
    }

    public Style withContent(String content) {
        this.content = content;
        return this;
    }

    public Style withCreator(Principal creator) {
        this.creator = creator;
        return this;
    }

    public String toString() {
        return "Style [id=" + this.id + ", name=" + this.name + ", content=" + this.content + ", creator=" + this.creator + ", creationDate=" + this.creationDate + ", lastUpdate=" + this.lastUpdate + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.id.equals(((Style)other).getId());
    }

    public Map<String, String> toMap() {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        styleMap.put("id", this.id.toString());
        styleMap.put("name", this.name);
        styleMap.put("content", this.content);
        styleMap.put("creator", this.creator.getName());
        styleMap.put("creationDate", this.creationDate.toString());
        styleMap.put("lastUpdate", this.lastUpdate.toString());
        return styleMap;
    }
}

