/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping;

import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlSeeAlso(value={AttributeMappingConfig.class})
public class SystemMappingConfig {
    private List<AttributeMappingConfig> mappingConfigs = new ArrayList<AttributeMappingConfig>();
    @XmlTransient
    private Map<String, Map<String, Map<String, AttributeMappingConfig>>> lookup = new HashMap<String, Map<String, Map<String, AttributeMappingConfig>>>();
    @XmlTransient
    private Map<String, Map<String, AttributeMappingConfig>> idLookup = new HashMap<String, Map<String, AttributeMappingConfig>>();

    public List<AttributeMappingConfig> getMappingConfigs() {
        return this.mappingConfigs;
    }

    @XmlElementWrapper(name="mappings")
    public void setMappingConfigs(List<AttributeMappingConfig> mappingConfigs) {
        this.mappingConfigs = mappingConfigs;
        this.lookup = new HashMap<String, Map<String, Map<String, AttributeMappingConfig>>>();
        for (AttributeMappingConfig cfg : mappingConfigs) {
            if (this.lookup.get(cfg.getAttributeName()) == null) {
                this.lookup.put(cfg.getAttributeName(), new HashMap());
            }
            if (this.lookup.get(cfg.getAttributeName()).get(cfg.getAttributeValue() == null ? "" : cfg.getAttributeValue()) == null) {
                this.lookup.get(cfg.getAttributeName()).put(cfg.getAttributeValue() == null ? "" : cfg.getAttributeValue(), new HashMap());
            }
            this.lookup.get(cfg.getAttributeName()).get(cfg.getAttributeValue() == null ? "" : cfg.getAttributeValue()).put(cfg.getLayerTermId() != null ? cfg.getLayerTermId() : "", cfg);
        }
        this.idLookup = new HashMap<String, Map<String, AttributeMappingConfig>>();
        for (AttributeMappingConfig cfg : mappingConfigs) {
            if (this.idLookup.get(cfg.getTermId()) == null) {
                this.idLookup.put(cfg.getTermId(), new HashMap());
            }
            this.idLookup.get(cfg.getTermId()).put(cfg.getLayerTermId() != null ? cfg.getLayerTermId() : "", cfg);
        }
    }

    public List<AttributeMappingConfig> getMappingConfig(String attributeName) {
        ArrayList<AttributeMappingConfig> res = new ArrayList<AttributeMappingConfig>();
        Map<String, Map<String, AttributeMappingConfig>> mcfg = this.lookup.get(attributeName);
        if (mcfg == null) {
            return null;
        }
        for (Map<String, AttributeMappingConfig> c : mcfg.values()) {
            for (AttributeMappingConfig cv : c.values()) {
                res.add(new AttributeMappingConfig(cv));
            }
        }
        return res;
    }

    public List<AttributeMappingConfig> getMappingConfigForLayer(String attributeName, String layerTermId) {
        ArrayList<AttributeMappingConfig> res = new ArrayList<AttributeMappingConfig>();
        Map<String, Map<String, AttributeMappingConfig>> mcfg = this.lookup.get(attributeName);
        if (mcfg == null) {
            return null;
        }
        for (Map<String, AttributeMappingConfig> c : mcfg.values()) {
            AttributeMappingConfig cfg = c.get(layerTermId);
            if (cfg == null) continue;
            res.add(new AttributeMappingConfig(cfg));
        }
        return res;
    }

    public List<AttributeMappingConfig> getMappingConfigForId(String termId) {
        ArrayList<AttributeMappingConfig> mappings = new ArrayList<AttributeMappingConfig>();
        Map<String, AttributeMappingConfig> cfg = this.idLookup.get(termId);
        if (cfg == null) {
            return mappings;
        }
        for (AttributeMappingConfig cv : cfg.values()) {
            mappings.add(new AttributeMappingConfig(cv));
        }
        return mappings;
    }

    public AttributeMappingConfig getMappingConfigForIdAndLayer(String termId, String layerTermId) {
        Map<String, AttributeMappingConfig> c = this.idLookup.get(termId);
        if (c == null) {
            return null;
        }
        AttributeMappingConfig cv = c.get(layerTermId);
        if (cv == null) {
            return null;
        }
        return new AttributeMappingConfig(cv);
    }

    public List<AttributeMappingConfig> getMappingConfigForLayer(String layerTermId) {
        ArrayList<AttributeMappingConfig> attrs = new ArrayList<AttributeMappingConfig>();
        for (Map<String, Map<String, AttributeMappingConfig>> cfg : this.lookup.values()) {
            for (Map<String, AttributeMappingConfig> l : cfg.values()) {
                AttributeMappingConfig mcfg = l.get(layerTermId);
                if (mcfg == null) continue;
                attrs.add(new AttributeMappingConfig(mcfg));
            }
        }
        return attrs;
    }

    public List<AttributeMappingConfig> getMappingConfig(String attributeName, String attributeValue) {
        if (this.lookup.get(attributeName) == null) {
            return null;
        }
        Map<String, Map<String, AttributeMappingConfig>> val = this.lookup.get(attributeName);
        if (val == null) {
            return null;
        }
        Map<String, AttributeMappingConfig> cfgs = val.get(attributeValue != null ? attributeValue : "");
        if (cfgs == null) {
            return null;
        }
        ArrayList<AttributeMappingConfig> ret = new ArrayList<AttributeMappingConfig>();
        for (AttributeMappingConfig cv : cfgs.values()) {
            ret.add(new AttributeMappingConfig(cv));
        }
        return ret;
    }

    public AttributeMappingConfig getMappingConfigForLayer(String attributeName, String attributeValue, String layerTermId) {
        if (this.lookup.get(attributeName) == null) {
            return null;
        }
        Map<String, Map<String, AttributeMappingConfig>> val = this.lookup.get(attributeName);
        if (val == null) {
            return null;
        }
        Map<String, AttributeMappingConfig> cfgs = val.get(attributeValue != null ? attributeValue : "");
        if (cfgs == null) {
            return null;
        }
        return new AttributeMappingConfig(cfgs.get(layerTermId));
    }

    public void removeMappingConfig(String attributeName) {
        Map<String, Map<String, AttributeMappingConfig>> mcfgs = this.lookup.get(attributeName);
        if (mcfgs == null) {
            return;
        }
        this.lookup.remove(attributeName);
        for (Map.Entry<String, Map<String, AttributeMappingConfig>> mcfg : mcfgs.entrySet()) {
            for (Map.Entry<String, AttributeMappingConfig> cfg : mcfg.getValue().entrySet()) {
                this.idLookup.remove(cfg.getValue().getTermId());
                this.mappingConfigs.remove(cfg.getValue());
            }
        }
    }

    public void removeMappingConfigForLayer(String attributeName, String layerTermId) {
        Map<String, Map<String, AttributeMappingConfig>> mcfgs = this.lookup.get(attributeName);
        if (mcfgs == null) {
            return;
        }
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry<String, Map<String, AttributeMappingConfig>> mcfg : mcfgs.entrySet()) {
            mcfg.getValue().remove(layerTermId);
            if (mcfg.getValue().isEmpty()) {
                toDelete.add(mcfg.getKey());
            }
            for (Map.Entry<String, AttributeMappingConfig> cfg : mcfg.getValue().entrySet()) {
                this.idLookup.get(cfg.getValue().getTermId()).remove(layerTermId);
                if (this.idLookup.get(cfg.getValue().getTermId()).isEmpty()) {
                    this.idLookup.remove(cfg.getValue().getTermId());
                }
                this.mappingConfigs.remove(cfg.getValue());
            }
        }
        for (String key : toDelete) {
            mcfgs.remove(key);
            if (!mcfgs.isEmpty()) continue;
            this.lookup.remove(attributeName);
        }
    }

    public void removeMappingConfigForLayer(String layerTermId) {
        ArrayList<String> toDeleteLookup = new ArrayList<String>();
        for (Map.Entry<String, Map<String, Map<String, AttributeMappingConfig>>> mcfgs : this.lookup.entrySet()) {
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Map.Entry<String, Map<String, AttributeMappingConfig>> mcfg : mcfgs.getValue().entrySet()) {
                mcfg.getValue().remove(layerTermId);
                if (mcfg.getValue().isEmpty()) {
                    toDelete.add(mcfg.getKey());
                }
                for (Map.Entry<String, AttributeMappingConfig> cfg : mcfg.getValue().entrySet()) {
                    if (!cfg.getKey().equals(layerTermId)) continue;
                    this.idLookup.get(cfg.getValue().getTermId()).remove(layerTermId);
                    if (this.idLookup.get(cfg.getValue().getTermId()).isEmpty()) {
                        this.idLookup.remove(cfg.getValue().getTermId());
                    }
                    this.mappingConfigs.remove(cfg.getValue());
                }
            }
            for (String key : toDelete) {
                mcfgs.getValue().remove(key);
                if (!mcfgs.getValue().isEmpty()) continue;
                toDeleteLookup.add(mcfgs.getKey());
            }
        }
        for (String key : toDeleteLookup) {
            this.lookup.remove(key);
        }
    }

    public void removeMappingConfig(String attributeName, String attributeValue) {
        Map<String, Map<String, AttributeMappingConfig>> l = this.lookup.get(attributeName);
        if (l == null) {
            return;
        }
        Map<String, AttributeMappingConfig> tmp = l.get(attributeValue);
        if (tmp == null) {
            return;
        }
        l.remove(attributeValue);
        if (l.isEmpty()) {
            this.lookup.remove(attributeName);
        }
        for (AttributeMappingConfig mcfg : tmp.values()) {
            this.idLookup.remove(mcfg.getTermId());
            this.mappingConfigs.remove(mcfg);
        }
    }

    public void removeMappingConfigForLayer(String attributeName, String attributeValue, String layerTermId) {
        attributeValue = attributeValue != null ? attributeValue : "";
        Map<String, Map<String, AttributeMappingConfig>> l = this.lookup.get(attributeName);
        if (l == null) {
            return;
        }
        Map<String, AttributeMappingConfig> tmp = l.get(attributeValue);
        if (tmp == null) {
            return;
        }
        AttributeMappingConfig mcfg = tmp.get(layerTermId);
        if (mcfg == null) {
            return;
        }
        tmp.remove(layerTermId);
        if (tmp.isEmpty()) {
            l.remove(attributeValue);
        }
        if (l.isEmpty()) {
            this.lookup.remove(attributeName);
        }
        this.idLookup.get(mcfg.getTermId()).remove(layerTermId);
        if (this.idLookup.get(mcfg.getTermId()).isEmpty()) {
            this.idLookup.remove(mcfg.getTermId());
        }
        this.mappingConfigs.remove(mcfg);
    }

    public void setMappingConfig(AttributeMappingConfig cfg) {
        Map<String, Map<String, AttributeMappingConfig>> l;
        if (this.lookup.get(cfg.getAttributeName()) == null) {
            this.lookup.put(cfg.getAttributeName(), new HashMap());
        }
        if ((l = this.lookup.get(cfg.getAttributeName())).get(cfg.getAttributeValue() != null ? cfg.getAttributeValue() : "") == null) {
            l.put(cfg.getAttributeValue() != null ? cfg.getAttributeValue() : "", new HashMap());
        }
        l.get(cfg.getAttributeValue() != null ? cfg.getAttributeValue() : "").put(cfg.getLayerTermId() != null ? cfg.getLayerTermId() : "", cfg);
        if (this.idLookup.get(cfg.getTermId()) == null) {
            this.idLookup.put(cfg.getTermId(), new HashMap());
        }
        this.idLookup.get(cfg.getTermId()).put(cfg.getLayerTermId() != null ? cfg.getLayerTermId() : "", cfg);
        int pos = this.mappingConfigs.indexOf(cfg);
        if (pos != -1) {
            this.mappingConfigs.remove(pos);
        }
        this.mappingConfigs.add(pos != -1 ? pos : this.mappingConfigs.size(), cfg);
    }
}

