/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.layer;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.layer.DataSource;
import gr.cite.geoanalytics.dataaccess.entities.layer.LayerTag;
import gr.cite.geoanalytics.dataaccess.entities.layer.LayerTenant;
import gr.cite.geoanalytics.dataaccess.entities.layer.LayerVisualization;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectLayer;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Layer\"")
public class Layer
implements Entity,
Identifiable,
Stampable,
Serializable {
    private static final long serialVersionUID = -403566445767699950L;
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"L_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"L_Name\"", nullable=true, length=200)
    private String name = null;
    @Column(name="\"L_Workspace\"", nullable=true, length=200)
    private String workspace = null;
    @Enumerated(value=EnumType.STRING)
    @Column(name="\"L_DataSource\"", nullable=true, length=100)
    private DataSource dataSource = null;
    @Column(name="\"L_Description\"", nullable=true)
    private String description = null;
    @Column(name="\"L_ExternalGeoserverUrl\"", nullable=true)
    private String externalGeoserverUrl = null;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"L_ExtraData\"", columnDefinition="xml")
    private String extraData;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"L_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"L_EditDate\"", nullable=false)
    private Date lastUpdate = null;
    @Column(name="\"L_RepFactor\"", nullable=false)
    private Integer replicationFactor = null;
    @ManyToOne
    @JoinColumn(name="\"L_Creator\"", nullable=false)
    private Principal creator = null;
    @Column(name="\"L_IsActive\"", nullable=false)
    private Short isActive = 1;
    @Column(name="\"L_IsTemplate\"", nullable=false)
    private Short isTemplate = 0;
    @Column(name="\"L_IsExternal\"", nullable=false)
    private Short isExternal = 0;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="\"L_GeocodeSystem\"", nullable=true)
    private GeocodeSystem geocodeSystem = null;
    @Column(name="\"L_Style\"", nullable=true, length=200)
    private String style = null;
    @Column(name="\"L_Geonetwork\"", nullable=true)
    private Long geonetwork = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="layer", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<LayerTenant> layerTenants = new HashSet<LayerTenant>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="layer", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<LayerTag> layerTags = new HashSet<LayerTag>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="layer", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<LayerVisualization> layerVisualizations = new HashSet<LayerVisualization>(0);
    @OneToMany(fetch=FetchType.LAZY, mappedBy="layer", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProjectLayer> projectLayers = new HashSet<ProjectLayer>(0);

    public Layer() {
    }

    public Layer(UUID layerID) {
        this.id = layerID;
        this.creationDate = new Date();
        this.lastUpdate = new Date();
    }

    public Layer(UUID layerID, String name) {
        this.id = layerID;
        this.name = name;
        this.creationDate = new Date();
        this.lastUpdate = new Date();
    }

    public Layer(UUID layerID, String name, Principal creator, short isActive) {
        this.id = layerID;
        this.name = name;
        this.creator = creator;
        this.isActive = isActive;
    }

    public Layer(UUID layerID, String name, Principal creator, String uri, DataSource dataSource, String extraData, short isActive) {
        this.id = layerID;
        this.name = name;
        this.creator = creator;
        this.externalGeoserverUrl = uri;
        this.dataSource = dataSource;
        this.extraData = extraData;
        this.isActive = isActive;
    }

    public GeocodeSystem getGeocodeSystem() {
        return this.geocodeSystem;
    }

    public void setGeocodeSystem(GeocodeSystem geocodeSystem) {
        this.geocodeSystem = geocodeSystem;
    }

    public short getIsTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(short isTemplate) {
        this.isTemplate = isTemplate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public short getIsActive() {
        return this.isActive;
    }

    public void setIsActive(short isActive) {
        this.isActive = isActive;
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalGeoserverUrl() {
        return this.externalGeoserverUrl;
    }

    public void setExternalGeoserverUrl(String uri) {
        this.externalGeoserverUrl = uri;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Long getGeonetwork() {
        return this.geonetwork;
    }

    public void setGeonetwork(Long geonetwork) {
        this.geonetwork = geonetwork;
    }

    public void setLayerTenants(Set<LayerTenant> layerTenants) {
        this.layerTenants = layerTenants;
    }

    public Set<LayerTenant> getLayerTenants() {
        return this.layerTenants;
    }

    public Set<LayerTag> getLayerTags() {
        return this.layerTags;
    }

    public void setLayerTags(Set<LayerTag> layerTags) {
        this.layerTags = layerTags;
    }

    public Set<LayerVisualization> getLayerVisualizations() {
        return this.layerVisualizations;
    }

    public void setLayerVisualizations(Set<LayerVisualization> layerVisualizations) {
        this.layerVisualizations = layerVisualizations;
    }

    public Set<ProjectLayer> getProjectLayers() {
        return this.projectLayers;
    }

    public void setProjectLayers(Set<ProjectLayer> projectLayers) {
        this.projectLayers = projectLayers;
    }

    public Short getIsExternal() {
        return this.isExternal;
    }

    public void setIsExternal(Short isExternal) {
        this.isExternal = isExternal;
    }

    public boolean isExternal() {
        return this.isExternal == 1;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Layer other = (Layer)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Layer [id=" + this.id + ", name=" + this.name + ", workspace=" + this.workspace + ", dataSource=" + (Object)((Object)this.dataSource) + ", description=" + this.description + ", uri=" + this.externalGeoserverUrl + ", extraData=" + this.extraData + ", creationDate=" + this.creationDate + ", lastUpdate=" + this.lastUpdate + ", replicationFactor=" + this.replicationFactor + ", isActive=" + this.isActive + ", isTemplate=" + this.isTemplate + ", geocodeSystem=" + this.geocodeSystem + ", style=" + this.style + ", geonetwork=" + this.geonetwork + "]";
    }
}

