/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.global;

import com.sun.xml.txw2.annotation.XmlElement;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.SysConfigData;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.global.TaxonomyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlSeeAlso(value={TaxonomyConfig.class})
public class SystemGlobalConfig
implements SysConfigData {
    private boolean systemOnline;
    private Set<String> taxonomyConfigTypes = null;
    private static Set<String> cachedTaxonomyConfigTypes = null;
    private List<TaxonomyConfig> taxonomyConfig;

    public boolean isSystemOnline() {
        return this.systemOnline;
    }

    @XmlElement
    public void setSystemOnline(boolean systemOnline) {
        this.systemOnline = systemOnline;
    }

    public List<TaxonomyConfig> getTaxonomyConfig() {
        if (this.taxonomyConfig == null) {
            return null;
        }
        ArrayList<TaxonomyConfig> ret = new ArrayList<TaxonomyConfig>();
        for (TaxonomyConfig tcfg : this.taxonomyConfig) {
            ret.add(new TaxonomyConfig(tcfg));
        }
        return ret;
    }

    @XmlElementWrapper(name="taxonomyConfigs")
    public void setTaxonomyConfig(List<TaxonomyConfig> taxonomyConfig) {
        this.taxonomyConfig = taxonomyConfig;
    }

    public void setTaxonomyConfig(TaxonomyConfig taxonomyConfig) throws Exception {
        TaxonomyConfig existing = this.getByTaxonomyId(taxonomyConfig.getId());
        if (existing != null && !existing.getType().equals(taxonomyConfig.getType())) {
            throw new Exception("Non-unique taxonomy mapping for " + taxonomyConfig.getType());
        }
        ArrayList<TaxonomyConfig> toDelete = new ArrayList<TaxonomyConfig>();
        for (TaxonomyConfig cfg : this.taxonomyConfig) {
            if (!cfg.getType().equals(taxonomyConfig.getType())) continue;
            toDelete.add(cfg);
        }
        this.taxonomyConfig.removeAll(toDelete);
        this.taxonomyConfig.add(taxonomyConfig);
    }

    public void removeTaxonomyConfig(TaxonomyConfig taxonomyConfig) {
        ArrayList<TaxonomyConfig> toDelete = new ArrayList<TaxonomyConfig>();
        for (TaxonomyConfig cfg : this.taxonomyConfig) {
            if (!cfg.getType().equals(taxonomyConfig.getType())) continue;
            toDelete.add(cfg);
        }
        this.taxonomyConfig.removeAll(toDelete);
    }

    public List<String> getByTaxonomyTag(String t) {
        ArrayList<String> taxonomies = new ArrayList<String>();
        for (TaxonomyConfig c : this.taxonomyConfig) {
            if (!c.getType().equals(t)) continue;
            taxonomies.add(c.getId());
        }
        return taxonomies;
    }

    public TaxonomyConfig getByTaxonomyId(String id) {
        for (TaxonomyConfig c : this.taxonomyConfig) {
            if (!c.getId().equals(id)) continue;
            return new TaxonomyConfig(c);
        }
        return null;
    }

    public Map<String, String> getTaxonomyMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (TaxonomyConfig c : this.taxonomyConfig) {
            if (!c.getType().equals((Object)TaxonomyConfig.Type.ALTGEOGRAPHYTAXONOMY)) continue;
            mappings.put(c.getReferrer(), c.getId());
        }
        return mappings;
    }

    public static Set<String> getCachedTaxonomyConfigTypes() {
        if (cachedTaxonomyConfigTypes == null) {
            return null;
        }
        return new HashSet<String>(cachedTaxonomyConfigTypes);
    }

    public Set<String> getTaxonomyConfigTypes() {
        if (cachedTaxonomyConfigTypes != null) {
            return new HashSet<String>(cachedTaxonomyConfigTypes);
        }
        HashSet<String> types = new HashSet<String>();
        for (TaxonomyConfig.Type t : TaxonomyConfig.Type.values()) {
            types.add(t.toString());
        }
        for (TaxonomyConfig cfg : this.taxonomyConfig) {
            types.add(cfg.getType());
        }
        cachedTaxonomyConfigTypes = new HashSet<String>(types);
        return types;
    }

    public void addTaxonomyConfigType(String type) {
        if (!this.taxonomyConfigTypes.contains(type)) {
            this.taxonomyConfigTypes.add(type);
            cachedTaxonomyConfigTypes.add(type);
        }
    }
}

