/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.auditing;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Auditing\"")
public class Auditing
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"AUD_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"AUD_Type\"", nullable=false)
    private short type = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"AUD_Date\"", nullable=false)
    private Date date = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"AUD_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"AUD_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Column(name="\"AUD_Data\"", columnDefinition="xml")
    private String data = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"AUD_Creator\"", nullable=false)
    private Principal creator = null;
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="\"AUD_Tenant\"")
    private Tenant tenant = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"AUD_Principal\"", nullable=false)
    private Principal principal = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public AuditingType getType() {
        return AuditingType.fromTypeCode(this.type);
    }

    public void setType(AuditingType type) {
        this.type = type.typeCode();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        return "Auditing(id=" + this.getId() + " type=" + (Object)((Object)this.getType()) + " date=" + this.getDate() + " creation=" + this.getCreationDate() + "lastUpdate=" + this.getLastUpdate() + "data=" + this.getData() + " creator=" + (this.creator != null ? this.creator.getId() : null) + " customer=" + (this.tenant != null ? this.tenant.getId() : null) + " user=" + (this.principal != null ? this.principal.getId() : null);
    }

    public static enum AuditingType {
        LastDataUpdate(0),
        LastUserAction(1),
        LayerIllegalAccessAttempt(2),
        LayerZoomIllegalAccessAttempt(3),
        IllegalRequestAttempt(4),
        LastUserLogin(5),
        LastUnsuccessfulUserLogin(6),
        LastUserPasswordRequest(7),
        DOSAttack(8);

        private final short typeCode;
        private static final Map<Short, AuditingType> lookup;

        private AuditingType(short typeCode) {
            this.typeCode = typeCode;
        }

        public short typeCode() {
            return this.typeCode;
        }

        public static AuditingType fromTypeCode(short typeCode) {
            return lookup.get(typeCode);
        }

        static {
            lookup = new HashMap<Short, AuditingType>();
            for (AuditingType t : EnumSet.allOf(AuditingType.class)) {
                lookup.put(t.typeCode(), t);
            }
        }
    }
}

