/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.accounting;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Accounting\"")
public class Accounting
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"ACC_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"ACC_Type\"", nullable=false)
    private short type = 0;
    @Column(name="\"ACC_Units\"", nullable=false)
    private float units = 0.0f;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Column(name="\"ACC_ReferenceData\"", columnDefinition="xml")
    private String referenceData = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"ACC_Date\"", nullable=false)
    private Date date = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"ACC_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"ACC_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"ACC_Creator\"", nullable=false)
    private Principal creator = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"ACC_Tenant\"", nullable=false)
    private Tenant tenant = null;
    @OneToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="\"ACC_Principal\"")
    private Principal principal = null;
    @Column(name="\"ACC_IsValid\"")
    private Short isValid = 1;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public AccountingType getType() {
        return AccountingType.fromTypeCode(this.type);
    }

    public void setType(AccountingType type) {
        this.type = type.typeCode();
    }

    public float getUnits() {
        return this.units;
    }

    public void setUnits(float units) {
        this.units = units;
    }

    public String getReferenceData() {
        return this.referenceData;
    }

    public void setReferenceData(String referenceData) {
        this.referenceData = referenceData;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public boolean getIsValid() {
        if (this.isValid == null) {
            return true;
        }
        return this.isValid != 0;
    }

    public void setIsValid(boolean isValid) {
        this.isValid = (short)(isValid ? 1 : 0);
    }

    public String toString() {
        return "Accounting(id=" + this.getId() + " type=" + (Object)((Object)this.getType()) + " units=" + this.getUnits() + " referenceData=" + this.getReferenceData() + " date=" + this.getDate() + " creation=" + this.getCreationDate() + "lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null) + " customer=" + (this.tenant != null ? this.tenant.getId() : null) + " user=" + (this.principal != null ? this.principal.getId() : null);
    }

    public static enum AccountingType {
        Payment(0);

        private final short typeCode;
        private static final Map<Short, AccountingType> lookup;

        private AccountingType(short typeCode) {
            this.typeCode = typeCode;
        }

        public short typeCode() {
            return this.typeCode;
        }

        public static AccountingType fromTypeCode(short typeCode) {
            return lookup.get(typeCode);
        }

        static {
            lookup = new HashMap<Short, AccountingType>();
            for (AccountingType t : EnumSet.allOf(AccountingType.class)) {
                lookup.put(t.typeCode(), t);
            }
        }
    }
}

