/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"SysConfig\"")
public class SysConfig
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"SYSC_ID\"", nullable=false)
    private UUID id = null;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="\"SYSC_Config\"", nullable=false)
    private String config = null;
    @Column(name="\"SYSC_Class\"", nullable=false)
    private short configClass = (short)-1;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"SYSC_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"SYSC_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"SYSC_Creator\"", nullable=false)
    private Principal creator = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public SysConfigClass getConfigClass() {
        return SysConfigClass.fromConfigClassCode(this.configClass);
    }

    public void setConfigClass(SysConfigClass configClass) {
        this.configClass = configClass.configClassCode();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public String toString() {
        return "SysConfig(id=" + this.getId() + " configClass=" + (Object)((Object)this.getConfigClass()) + " config=" + this.getConfig() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null);
    }

    public static enum SysConfigClass {
        GLOBALCONFIG(0),
        PRESENTATION(1),
        LAYERCONFIG(2),
        ATTRIBUTEMAPPING(3);

        private final short classCode;
        private static final Map<Short, SysConfigClass> lookup;

        private SysConfigClass(short configClassCode) {
            this.classCode = configClassCode;
        }

        public short configClassCode() {
            return this.classCode;
        }

        public static SysConfigClass fromConfigClassCode(short configClassCode) {
            return lookup.get(configClassCode);
        }

        static {
            lookup = new HashMap<Short, SysConfigClass>();
            for (SysConfigClass s : EnumSet.allOf(SysConfigClass.class)) {
                lookup.put(s.configClassCode(), s);
            }
        }
    }
}

