/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.shape;

import com.vividsolutions.jts.geom.Geometry;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.exception.SRSException;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"ShapeImport\"")
public class ShapeImport
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"SHPI_ID\"", nullable=false)
    private UUID id = null;
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"SHPI_Import\"", nullable=false)
    private UUID shapeImport = null;
    @Type(type="org.hibernate.spatial.GeometryType")
    @Column(name="\"SHPI_Geography\"", nullable=false, columnDefinition="Geography")
    private Geometry geography = null;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Column(name="\"SHPI_Data\"", columnDefinition="xml")
    private String data = null;
    @Column(name="\"SHPI_ShapeIdentity\"", length=250)
    private String shapeIdentity = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"SHPI_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"SHPI_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"SHPI_Creator\"", nullable=false)
    private UUID creatorID = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getShapeImport() {
        return this.shapeImport;
    }

    public void setShapeImport(UUID shapeImport) {
        this.shapeImport = shapeImport;
    }

    public Geometry getGeography() {
        return this.geography;
    }

    public void setGeography(Geometry geography) throws Exception {
        this.geography = geography;
        if (this.geography.getSRID() == 8307) {
            this.geography.setSRID(4326);
        }
        if (this.geography.getSRID() != 4326) {
            throw new SRSException("", Integer.toString(geography.getSRID()), null);
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getShapeIdentity() {
        return this.shapeIdentity;
    }

    public void setShapeIdentity(String shapeIdentity) {
        this.shapeIdentity = shapeIdentity;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public UUID getCreatorID() {
        return this.creatorID;
    }

    public void setCreatorID(UUID creatorID) {
        this.creatorID = creatorID;
    }

    public String toString() {
        return "ShapeImport(id=" + this.getId() + " shapeImport=" + this.getShapeImport() + " geography=" + this.getGeography() + "data=" + this.getData() + " shapeIdentity=" + this.getShapeIdentity() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator(id)=" + (this.creatorID != null ? this.creatorID.toString() : null);
    }
}

