package gr.cite.geoanalytics.dataaccess.entities.project;

import java.io.Serializable;
import java.util.UUID;

import org.hibernate.annotations.Type;

public class ProjectDocumentPK implements Serializable
{
	private static final long serialVersionUID = 9184792397628152487L;
	
	@Type(type="org.hibernate.type.PostgresUUIDType")
	private UUID project;
	@Type(type="org.hibernate.type.PostgresUUIDType")
	private UUID document;
	
	public ProjectDocumentPK() { }
	
	public ProjectDocumentPK(UUID project, UUID document)
	{
		this.project = project;
		this.document = document;
	}
	
	@Override
	public boolean equals(Object other)
	{
		if (this == other)
	        return true;
	    if (!(other instanceof ProjectDocumentPK))
	        return false;
	    ProjectDocumentPK castOther = (ProjectDocumentPK) other;
	    return project.equals(castOther.project) && document.equals(castOther.document);
	}
	
	@Override
	public int hashCode() 
	{
	    final int prime = 31;
	    int hash = 17;
	    hash = hash * prime + this.project.hashCode();
	    hash = hash * prime + this.document.hashCode();
	    return hash;
	}
}
