/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.context;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SmtpConfig {
    private static final SMTPAuthentication smtpAuthenticationTypeDefault = SMTPAuthentication.NONE;
    private static final String smtpAuthenticationTypeDefaultStr = "NONE";
    private static final String smtpAlertUserAccountLockDefault = "false";
    private static final String smtpAlertIllegalRequestAttemptDefault = "false";
    private static final String smtpAlertIllegalLayerAccessDefault = "false";
    private static final String smtpAlertIllegalLayerZoomDefault = "false";
    private SMTPAuthentication smtpAuthenticationType = smtpAuthenticationTypeDefault;
    private Map<SMTPAlert, Boolean> smtpAlert = new HashMap<SMTPAlert, Boolean>();
    private String smtpServer = null;
    private String smtpServerPort = null;
    private String smtpServerUsername = null;
    private String smtpServerPassword = null;

    public SMTPAuthentication getSmtpAuthenticationType() {
        return this.smtpAuthenticationType;
    }

    @Value(value="${gr.cite.geoanalytics.app.smtpServerAuthentication:NONE}")
    public void setSmtpAuthenticationType(SMTPAuthentication smtpAuthenticationType) {
        this.smtpAuthenticationType = smtpAuthenticationType;
    }

    public boolean isSmtpAuthenticationEnabled() {
        return this.smtpAuthenticationType != SMTPAuthentication.NONE;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    @Value(value="${gr.cite.geoanalytics.app.smtpServerHost}")
    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getSmtpServerPort() {
        return this.smtpServerPort;
    }

    @Value(value="${gr.cite.geoanalytics.app.smtpServerPort}")
    public void setSmtpServerPort(String smtpServerPort) {
        this.smtpServerPort = smtpServerPort;
    }

    public String getSmtpServerUsername() {
        return this.smtpServerUsername;
    }

    @Value(value="${gr.cite.geoanalytics.app.smtpServerUsername}")
    public void setSmtpServerUsername(String smtpServerUsername) {
        this.smtpServerUsername = smtpServerUsername;
    }

    public String getSmtpServerPassword() {
        return this.smtpServerPassword;
    }

    @Value(value="${gr.cite.geoanalytics.app.smtpServerPassword}")
    public void setSmtpServerPassword(String smtpServerPassword) {
        this.smtpServerPassword = smtpServerPassword;
    }

    public boolean isSmtpAlertEnabled(SMTPAlert alert) {
        Boolean val = this.smtpAlert.get((Object)alert);
        return val != null ? val : false;
    }

    public void setSmtpAlert(String smtpAlert) {
        Map alerts = Splitter.on((String)",").withKeyValueSeparator("=").split((CharSequence)smtpAlert);
        for (Map.Entry e : alerts.entrySet()) {
            this.smtpAlert.put(SMTPAlert.valueOf((String)e.getKey()), Boolean.parseBoolean((String)e.getValue()));
        }
    }

    @Value(value="${gr.cite.geoanalytics.app.smptAlert.userAccountLock:false}")
    public void setUserAccountLockSmtpAlert(boolean value) {
        this.smtpAlert.put(SMTPAlert.UserAccountLock, value);
    }

    @Value(value="${gr.cite.geoanalytics.app.smptAlert.illegalRequestAttempt:false}")
    public void setIllegalRequestAttemptSmtpAlert(boolean value) {
        this.smtpAlert.put(SMTPAlert.IllegalRequestAttempt, value);
    }

    @Value(value="${gr.cite.geoanalytics.app.smptAlert.illegalLayerAccesstAttempt:false}")
    public void setIllegalRequestLayerAccessSmtpAlert(boolean value) {
        this.smtpAlert.put(SMTPAlert.IllegalLayerAccessAttempt, value);
    }

    @Value(value="${gr.cite.geoanalytics.app.smptAlert.illegalLayerZoomAttempt:false}")
    public void setIllegalRequestLayerZoomSmtpAlert(boolean value) {
        this.smtpAlert.put(SMTPAlert.IllegalLayerZoomAttempt, value);
    }

    public static enum SMTPAlert {
        UserAccountLock,
        IllegalRequestAttempt,
        IllegalLayerAccessAttempt,
        IllegalLayerZoomAttempt;

    }

    public static enum SMTPAuthentication {
        NONE,
        PLAIN,
        TLS,
        SSL;

    }
}

