/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.context;

import gr.cite.geoanalytics.context.SmtpConfig;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApplicationConfig {
    private static Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private static final long serverShutdownDelayDefault = 5L;
    private static final TimeUnit serverShutdownDelayUnitDefault = TimeUnit.MINUTES;
    private long serverShutdownDelay = 5L;
    private TimeUnit serverShutdownDelayUnit = serverShutdownDelayUnitDefault;
    private static final int maxUserSearchTermsDefault = 15;
    private static final int maxCustomerSearchTermsDefault = 15;
    private static final int maxTaxonomySearchTermsDefault = 15;
    private static final int maxShapeSearchTermsDefault = 15;
    private static final int maxDocumentSearchTermsDefault = 15;
    private static final String defaultLanguageDefault = "el";
    private int maxUserSearchTerms = 15;
    private int maxCustomerSearchTerms = 15;
    private int maxTaxonomySearchTerms = 15;
    private int maxShapeSearchTerms = 15;
    private int maxDocumentSearchTerms = 15;
    private String defaultLanguage = "el";
    private SmtpConfig smtpConfig = null;

    public long getServerShutdownDelay() {
        return this.serverShutdownDelay;
    }

    public void setServerShutdownDelay(long serverShutdownDelay) {
        this.serverShutdownDelay = serverShutdownDelay;
    }

    public TimeUnit getServerShutdownDelayUnit() {
        return this.serverShutdownDelayUnit;
    }

    public void setServerShutdownDelayUnit(TimeUnit serverShutdownDelayUnit) {
        this.serverShutdownDelayUnit = serverShutdownDelayUnit;
    }

    public int getMaxUserSearchTerms() {
        return this.maxUserSearchTerms;
    }

    public void setMaxUserSearchTerms(String maxUserSearchTermsStr) {
        if (maxUserSearchTermsStr == null) {
            log.trace("Using default maximum number of user search terms: 15");
            this.maxUserSearchTerms = 15;
        } else {
            this.maxUserSearchTerms = maxUserSearchTermsStr.equalsIgnoreCase("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(maxUserSearchTermsStr);
            log.trace("Using maximum number of user search terms: " + maxUserSearchTermsStr);
        }
    }

    public int getMaxCustomerSearchTerms() {
        return this.maxCustomerSearchTerms;
    }

    public void setMaxCustomerSearchTerms(String maxCustomerSearchTermsStr) {
        if (maxCustomerSearchTermsStr == null) {
            log.trace("Using default maximum number of customer search terms: 15");
            this.maxCustomerSearchTerms = 15;
        } else {
            this.maxCustomerSearchTerms = maxCustomerSearchTermsStr.equalsIgnoreCase("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(maxCustomerSearchTermsStr);
            log.trace("Using maximum number of customer search terms: " + maxCustomerSearchTermsStr);
        }
    }

    public int getMaxTaxonomySearchTerms() {
        return this.maxTaxonomySearchTerms;
    }

    public void setMaxTaxonomySearchTerms(String maxTaxonomySearchTermsStr) {
        if (maxTaxonomySearchTermsStr == null) {
            log.trace("Using default maximum number of taxonomy search terms: 15");
            this.maxTaxonomySearchTerms = 15;
        } else {
            this.maxTaxonomySearchTerms = maxTaxonomySearchTermsStr.equalsIgnoreCase("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(maxTaxonomySearchTermsStr);
            log.trace("Using maximum number of taxonomy search terms: " + maxTaxonomySearchTermsStr);
        }
    }

    public int getMaxShapeSearchTerms() {
        return this.maxShapeSearchTerms;
    }

    public void setMaxShapeSearchTerms(String maxShapeSearchTermsStr) {
        if (maxShapeSearchTermsStr == null) {
            log.trace("Using default maximum number of shape search terms: 15");
            this.maxShapeSearchTerms = 15;
        } else {
            this.maxShapeSearchTerms = maxShapeSearchTermsStr.equalsIgnoreCase("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(maxShapeSearchTermsStr);
            log.trace("Using maximum number of shape search terms: " + maxShapeSearchTermsStr);
        }
    }

    public int getMaxDocumentSearchTerms() {
        return this.maxDocumentSearchTerms;
    }

    public void setMaxDocumentSearchTerms(String maxDocumentSearchTermsStr) {
        if (maxDocumentSearchTermsStr == null) {
            log.trace("Using default maximum number of document search terms: 15");
            this.maxDocumentSearchTerms = 15;
        } else {
            this.maxDocumentSearchTerms = maxDocumentSearchTermsStr.equalsIgnoreCase("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(maxDocumentSearchTermsStr);
            log.trace("Using maximum number of document search terms: " + maxDocumentSearchTermsStr);
        }
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        if (defaultLanguage == null) {
            log.trace("Using default value for default language: el");
            this.defaultLanguage = defaultLanguageDefault;
        } else {
            this.defaultLanguage = defaultLanguage;
            log.trace("Using default language: " + defaultLanguage);
        }
    }

    public SmtpConfig getSmtpConfig() {
        return this.smtpConfig;
    }

    public void setSmtpConfig(SmtpConfig smtpConfig) {
        this.smtpConfig = smtpConfig;
    }

    public String toString() {
        return "ApplicationConfig [serverShutdownDelay=" + this.serverShutdownDelay + ", serverShutdownDelayUnit=" + (Object)((Object)this.serverShutdownDelayUnit) + ", maxUserSearchTerms=" + this.maxUserSearchTerms + ", maxCustomerSearchTerms=" + this.maxCustomerSearchTerms + ", maxTaxonomySearchTerms=" + this.maxTaxonomySearchTerms + ", maxShapeSearchTerms=" + this.maxShapeSearchTerms + ", maxDocumentSearchTerms=" + this.maxDocumentSearchTerms + ", defaultLanguage=" + this.defaultLanguage + ", smtpConfig=" + this.smtpConfig + "]";
    }
}

