/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.utilities;

import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.context.i18n.LocaleContextHolder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LayerUtils {
    private static DocumentBuilderFactory dbf = null;
    private static DocumentBuilder db = null;
    private static Object dbLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseDocument(String data, DocumentBuilder db) throws Exception {
        if (db == LayerUtils.db) {
            Object object = dbLock;
            synchronized (object) {
                return db.parse(new ByteArrayInputStream(data.getBytes("UTF-8")));
            }
        }
        return db.parse(new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    public static String storeLocalizedValue(Layer layer, String locale, String value, DocumentBuilder db) throws Exception {
        if (layer.getExtraData() == null || layer.getExtraData().isEmpty()) {
            layer.setExtraData("<extraData></extraData>");
        }
        Document d = LayerUtils.parseDocument(layer.getExtraData(), db);
        NodeList names = d.getElementsByTagName("value");
        boolean found = false;
        for (int i = 0; i < names.getLength(); ++i) {
            if (!((Element)names.item(i)).getAttribute("locale").equals(locale)) continue;
            found = true;
            break;
        }
        if (!found) {
            Element n = d.createElement("value");
            Attr l = d.createAttribute("locale");
            l.setValue(locale);
            n.appendChild(l);
            Text c = d.createTextNode(value);
            n.appendChild(c);
            d.appendChild(n);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer tr = tf.newTransformer();
            StringWriter sw = new StringWriter();
            tr.transform(new DOMSource(d), new StreamResult(sw));
            sw.toString();
            return sw.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveLocalizedValue(Layer layer, String locale) throws Exception {
        if (layer.getExtraData() == null || layer.getExtraData().isEmpty()) {
            return null;
        }
        Object object = dbLock;
        synchronized (object) {
            if (db == null) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
        }
        return LayerUtils.retrieveLocalizedValue(layer, locale, db);
    }

    public static String retrieveLocalizedValue(Layer layer, String locale, DocumentBuilder db) throws Exception {
        if (layer.getExtraData() == null || layer.getExtraData().isEmpty()) {
            return null;
        }
        Document d = LayerUtils.parseDocument(layer.getExtraData(), db);
        NodeList names = d.getElementsByTagName("value");
        for (int i = 0; i < names.getLength(); ++i) {
            if (!((Element)names.item(i)).getAttribute("locale").equals(locale)) continue;
            return names.item(i).getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String getUserCreatedLayerValue(Layer layer, DocumentBuilder db) throws Exception {
        if (layer.getExtraData() == null || layer.getExtraData().isEmpty()) {
            return null;
        }
        Document d = LayerUtils.parseDocument(layer.getExtraData(), db);
        String userCreatedAttr = d.getDocumentElement().getAttribute("userCreated");
        if (userCreatedAttr != null && !userCreatedAttr.isEmpty() && Boolean.parseBoolean(userCreatedAttr)) {
            NodeList nl = d.getDocumentElement().getElementsByTagName("value");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                String localeAttr = el.getAttribute("locale");
                if (localeAttr == null || localeAttr.isEmpty() || !localeAttr.equals(LocaleContextHolder.getLocale().getLanguage())) continue;
                return el.getFirstChild().getNodeValue();
            }
            if (nl.getLength() == 0) {
                return nl.item(0).getFirstChild().getNodeValue();
            }
        }
        return "";
    }
}

