/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.clustermanager.actuators.layers.DataMonitor;
import gr.cite.gaap.datatransferobjects.StyleMessenger;
import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.StyleManagerCommons;
import gr.cite.geoanalytics.dataaccess.entities.style.Style;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.SystemPresentationConfig;
import gr.cite.gos.client.GeoserverManagement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentInitializer {
    public static Logger log = LoggerFactory.getLogger(EnvironmentInitializer.class);
    private GeoserverManagement geoserverManagement = null;
    private DataMonitor dataMonitor = null;
    private ConfigurationManager configurationManager = null;
    @Autowired
    StyleManagerCommons styleManager;
    private static int PREVIOUS_NUM_OF_GOS = -1;

    @Inject
    public void setGeoserverManagement(GeoserverManagement geoserverManagement) {
        this.geoserverManagement = geoserverManagement;
    }

    @Inject
    public void setDataMonitor(DataMonitor dataMonitor) {
        this.dataMonitor = dataMonitor;
    }

    @Inject
    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void asyncInitializeEnvironment() throws Exception {
        ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
        ses.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                int current = EnvironmentInitializer.this.dataMonitor.getAllGosEndpoints().size();
                try {
                    if (current != 0 && PREVIOUS_NUM_OF_GOS != EnvironmentInitializer.this.dataMonitor.getAllGosEndpoints().size()) {
                        EnvironmentInitializer.this.initializeEnvironment();
                    }
                    PREVIOUS_NUM_OF_GOS = current;
                }
                catch (Exception e) {
                    log.error("Error while initializing environment", (Throwable)e);
                }
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public void initializeEnvironment() throws Exception {
        List<LayerConfig> layerConfigs = this.configurationManager.getLayerConfig();
        SystemPresentationConfig systemPresentationConfig = this.configurationManager.getSystemPresentationConfig();
        List<Style> styles = this.styleManager.listAllStyles();
        ArrayList<StyleMessenger> stylesMessenger = new ArrayList<StyleMessenger>();
        for (Style st : styles) {
            StyleMessenger styleMessenger = new StyleMessenger();
            styleMessenger.setName(st.getName());
            styleMessenger.setDescription(st.getContent());
            stylesMessenger.add(styleMessenger);
        }
        this.dataMonitor.getAllGosEndpoints().parallelStream().forEach(gosDefinition -> {
            try {
                log.debug("Initializing the geoserver environment on geoserver of GOS: " + gosDefinition.getGosEndpoint());
                this.geoserverManagement.initializeEnvironment(gosDefinition.getGosEndpoint(), layerConfigs, systemPresentationConfig, stylesMessenger);
            }
            catch (IOException e) {
                log.error("Could not initialize geoserver environment of gos... reason -> " + e);
            }
        });
    }
}

