/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.gaap.datatransferobjects.TaxonomyTermInfo;
import gr.cite.gaap.datatransferobjects.TaxonomyTermLinkInfo;
import gr.cite.gaap.utilities.ExceptionUtils;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.dao.ProjectTermDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDocumentDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermLink;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermLinkPK;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermShape;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermLinkDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermShapeDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.definition.TaxonomyData;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxonomyManager {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyManager.class);
    private TaxonomyDao taxonomyDao;
    private TaxonomyTermDao taxonomyTermDao;
    private TaxonomyTermLinkDao taxonomyTermLinkDao;
    private TaxonomyTermShapeDao taxonomyTermShapeDao;
    private ShapeDocumentDao shapeDocumentDao;
    private ProjectTermDao projectTermDao;
    private Object taxonomyDataCtxLock = new Object();
    private JAXBContext taxonomyDataCtx = null;

    @Inject
    public void setTaxonomyDao(TaxonomyDao taxonomyDao) {
        this.taxonomyDao = taxonomyDao;
    }

    @Inject
    public void setTaxonomyTermDao(TaxonomyTermDao taxonomyTermDao) {
        this.taxonomyTermDao = taxonomyTermDao;
    }

    @Inject
    public void setTaxonomyTermLinkDao(TaxonomyTermLinkDao taxonomyTermLinkDao) {
        this.taxonomyTermLinkDao = taxonomyTermLinkDao;
    }

    @Inject
    public void setTaxonomyTermShapeDao(TaxonomyTermShapeDao taxonomyTermShapeDao) {
        this.taxonomyTermShapeDao = taxonomyTermShapeDao;
    }

    @Inject
    public void setProjectTermDao(ProjectTermDao projectTermDao) {
        this.projectTermDao = projectTermDao;
    }

    @Inject
    public void setShapeDocumentDao(ShapeDocumentDao shapeDocumentDao) {
        this.shapeDocumentDao = shapeDocumentDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unmarshaller getTaxonomyDataUnmarshaller() throws JAXBException {
        Object object = this.taxonomyDataCtxLock;
        synchronized (object) {
            if (this.taxonomyDataCtx == null) {
                this.taxonomyDataCtx = JAXBContext.newInstance((Class[])new Class[]{TaxonomyData.class});
            }
            return this.taxonomyDataCtx.createUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Marshaller getTaxonomyDataMarshaller() throws JAXBException {
        Object object = this.taxonomyDataCtxLock;
        synchronized (object) {
            if (this.taxonomyDataCtx == null) {
                this.taxonomyDataCtx = JAXBContext.newInstance((Class[])new Class[]{TaxonomyData.class});
            }
            Marshaller marshaller = this.taxonomyDataCtx.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            return marshaller;
        }
    }

    public TaxonomyData unmarshalTaxonomyData(String data) {
        return (TaxonomyData)ExceptionUtils.wrap(() -> (TaxonomyData)this.getTaxonomyDataUnmarshaller().unmarshal((Reader)new StringReader(data))).get();
    }

    public String marshalTaxonomyData(TaxonomyData data) {
        return (String)ExceptionUtils.wrap(() -> {
            StringWriter sw = new StringWriter();
            Marshaller marshaller = this.getTaxonomyDataMarshaller();
            marshaller.marshal((Object)data, (Writer)sw);
            return sw.toString().replace("\r\n", "\n").replace("\n", "&#10;");
        }).get();
    }

    private void getTaxonomyDetails(Taxonomy t) {
        t.getCreator().getPrincipalData().getFullName();
        if (t.getTaxonomyClass() != null) {
            t.getTaxonomyClass().getName();
        }
    }

    private void getTaxonomyDetails(List<Taxonomy> ts) {
        for (Taxonomy t : ts) {
            this.getTaxonomyDetails(t);
        }
    }

    public void getTermDetails(TaxonomyTerm t) {
        t.getCreator().getPrincipalData().getFullName();
        t.getTaxonomy().getName();
        if (t.getTaxonomyTermClass() != null) {
            t.getTaxonomyTermClass().getName();
            t.getTaxonomyTermClass().getTaxonomy().getName();
        }
        if (t.getParent() != null) {
            t.getParent().getName();
            t.getParent().getTaxonomy().getName();
        }
        t.getExtraData();
    }

    private void getTermDetails(List<TaxonomyTerm> ts) {
        for (TaxonomyTerm t : ts) {
            this.getTermDetails(t);
        }
    }

    private void getTermLinkDetails(List<TaxonomyTermLink> ttls) {
        for (TaxonomyTermLink ttl : ttls) {
            this.getTermDetails(ttl.getSourceTerm());
            this.getTermDetails(ttl.getDestinationTerm());
        }
    }

    @Transactional(readOnly=true)
    public Taxonomy findTaxonomyById(String id, boolean loadDetails) {
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (loadDetails) {
            this.getTaxonomyDetails(Collections.singletonList(t));
        }
        return t;
    }

    @Transactional(readOnly=true)
    public TaxonomyTerm findTermById(String id, boolean loadDetails) {
        TaxonomyTerm tt = (TaxonomyTerm)this.taxonomyTermDao.read((Serializable)UUID.fromString(id));
        if (loadDetails) {
            this.getTermDetails(Collections.singletonList(tt));
        }
        return tt;
    }

    @Transactional(readOnly=true)
    public Taxonomy findTaxonomyByName(String name, boolean loadDetails) {
        List res = this.taxonomyDao.findByName(name);
        if (res != null && res.size() > 1) {
            throw new IllegalArgumentException("More than one taxonomies with name \"" + name + "\" were found");
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (loadDetails) {
            this.getTaxonomyDetails(res);
        }
        return (Taxonomy)res.get(0);
    }

    @Transactional(readOnly=true)
    public TaxonomyTerm findTermByName(String name, boolean loadDetails) throws Exception {
        List res = this.taxonomyTermDao.findByName(name);
        if (res != null && res.size() > 1) {
            throw new Exception("More than one taxonomy terms with name \"" + name + "\" were found");
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return (TaxonomyTerm)res.get(0);
    }

    @Transactional(readOnly=true)
    public TaxonomyTerm findTermByNameAndTaxonomy(String name, String taxonomyName, boolean loadDetails) {
        Taxonomy t = this.findTaxonomyByName(taxonomyName, false);
        if (t == null) {
            throw new IllegalArgumentException("Taxonomy " + taxonomyName + " was not found");
        }
        List res = this.taxonomyTermDao.findByNameAndTaxonomy(name, t);
        if (res != null && res.size() > 1) {
            throw new IllegalArgumentException("More than one taxonomy terms with name \"" + name + "\" were found");
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        res.forEach(x -> x.getTaxonomy().getName());
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return (TaxonomyTerm)res.get(0);
    }

    @Transactional(readOnly=true)
    public TaxonomyTerm findTermByNameAndTaxonomies(String taxonomyTermName, List<String> taxonomyNames, boolean loadDetails) throws Exception {
        ArrayList<Taxonomy> taxonomies = new ArrayList<Taxonomy>();
        for (String taxonomyName : taxonomyNames) {
            Taxonomy taxonomy = this.findTaxonomyByName(taxonomyName, loadDetails);
            if (taxonomy == null) {
                throw new Exception("Taxonomy " + taxonomyName + " was not found.");
            }
            taxonomies.add(taxonomy);
        }
        List taxonomyTerms = this.taxonomyTermDao.findByNameAndTaxonomies(taxonomyTermName, taxonomies);
        if (taxonomyTerms != null && taxonomyTerms.size() > 1) {
            throw new Exception("More than one taxonomy terms with name \"" + taxonomyTermName + "\" were found");
        }
        if (taxonomyTerms == null || taxonomyTerms.isEmpty()) {
            return null;
        }
        if (loadDetails) {
            this.getTermDetails(taxonomyTerms);
        }
        return (TaxonomyTerm)taxonomyTerms.get(0);
    }

    @Transactional(readOnly=true)
    public TaxonomyTerm findTermByNameAndTaxonomies(String taxonomyTermName, List<Taxonomy> taxonomies) throws Exception {
        List taxonomyTerms = this.taxonomyTermDao.findByNameAndTaxonomies(taxonomyTermName, taxonomies);
        if (taxonomyTerms != null && taxonomyTerms.size() > 1) {
            throw new Exception("More than one taxonomy terms with name \"" + taxonomyTermName + "\" were found");
        }
        if (taxonomyTerms == null || taxonomyTerms.isEmpty()) {
            return null;
        }
        return (TaxonomyTerm)taxonomyTerms.get(0);
    }

    @Transactional(readOnly=true)
    public Map<String, TaxonomyTerm> findTermByNameAndTaxonomies(List<Taxonomy> taxonomies) throws Exception {
        List taxonomyTerms = this.taxonomyTermDao.findAllTermsByTaxonomies(taxonomies);
        if (taxonomyTerms == null || taxonomyTerms.isEmpty()) {
            throw new Exception("No Taxonomy Terms were found");
        }
        HashMap<String, TaxonomyTerm> results = new HashMap<String, TaxonomyTerm>();
        for (TaxonomyTerm taxonomyTerm : taxonomyTerms) {
            results.put(taxonomyTerm.getName(), taxonomyTerm);
        }
        return results;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> findAutoCreatedWithParent(String parentTaxonomyName, boolean loadDetails) throws Exception {
        Taxonomy t = this.findTaxonomyByName(parentTaxonomyName, false);
        if (t == null) {
            throw new Exception("Taxonomy " + parentTaxonomyName + " not found");
        }
        List res = this.taxonomyTermDao.findAutoCreatedWithParent(t);
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Taxonomy> allTaxonomies(boolean loadDetails) throws Exception {
        List res = this.taxonomyDao.getAll();
        if (loadDetails) {
            this.getTaxonomyDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Taxonomy> activeTaxonomies(boolean loadDetails) throws Exception {
        List res = this.taxonomyDao.getActive();
        if (loadDetails) {
            this.getTaxonomyDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> allTerms(boolean loadDetails) throws Exception {
        List res = this.taxonomyTermDao.getAll();
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<String> listTaxonomies(boolean active) throws Exception {
        if (!active) {
            return this.taxonomyDao.listNames();
        }
        return this.taxonomyDao.listNamesOfActive();
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getTermsOfTaxonomy(String id, boolean active, boolean loadDetails) throws Exception {
        List res = null;
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = !active ? this.taxonomyDao.getTerms(t) : this.taxonomyDao.getActiveTerms(t);
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Taxonomy> getClassDescendantsOfTaxonomy(String id, boolean active, boolean loadDetails) throws Exception {
        List<Taxonomy> res = null;
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = this.taxonomyDao.getInstances(t);
        if (active) {
            res = this.filterTaxonomyByActive(res);
        }
        if (loadDetails) {
            this.getTaxonomyDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getTopmostTermsOfTaxonomy(String id, boolean loadDetails) {
        List res = null;
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new IllegalArgumentException("Taxonomy " + id + " does not exist");
        }
        res = this.taxonomyDao.getTopmostTerms(t);
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getBottomTermsOfTaxonomy(String id, boolean loadDetails) throws Exception {
        List res = null;
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = this.taxonomyDao.getBottomTerms(t);
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    private List<TaxonomyTerm> filterTermByActive(List<TaxonomyTerm> tts) {
        ArrayList<TaxonomyTerm> res = new ArrayList<TaxonomyTerm>();
        for (TaxonomyTerm tt : tts) {
            if (!tt.getIsActive()) continue;
            res.add(tt);
        }
        return res;
    }

    private List<Taxonomy> filterTaxonomyByActive(List<Taxonomy> ts) {
        ArrayList<Taxonomy> res = new ArrayList<Taxonomy>();
        for (Taxonomy t : ts) {
            if (!t.getIsActive()) continue;
            res.add(t);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getChildrenOfTerm(String id, boolean active, boolean loadDetails) {
        List<TaxonomyTerm> res = null;
        TaxonomyTerm t = (TaxonomyTerm)this.taxonomyTermDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new RuntimeException("Taxonomy term " + id + " does not exist");
        }
        res = this.taxonomyTermDao.getChildren(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getSiblingsOfTerm(String id, boolean active, boolean loadDetails) throws Exception {
        List<TaxonomyTerm> res = null;
        TaxonomyTerm t = (TaxonomyTerm)this.taxonomyTermDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy term " + id + " does not exist");
        }
        res = this.taxonomyTermDao.getSiblings(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getClassDescendantsOfTerm(String id, boolean active, boolean loadDetails) throws Exception {
        List<TaxonomyTerm> res = null;
        TaxonomyTerm t = (TaxonomyTerm)this.taxonomyTermDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy term " + id + " does not exist");
        }
        res = this.taxonomyTermDao.getClassDescendants(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTerm> getClassSiblingsOfTerm(String id, boolean active, boolean loadDetails) throws Exception {
        List<TaxonomyTerm> res = null;
        TaxonomyTerm t = (TaxonomyTerm)this.taxonomyTermDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy term " + id + " does not exist");
        }
        res = this.taxonomyTermDao.getClassSiblings(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getTermDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<String> listTermsOfTaxonomy(String id, boolean active) throws Exception {
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        if (active) {
            return this.taxonomyDao.listTerms(t);
        }
        return this.taxonomyDao.listActiveTerms(t);
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTermLink> getTermLinksOfTaxonomy(String id, boolean active, boolean loadDetails) throws Exception {
        List res = new ArrayList();
        Taxonomy t = (Taxonomy)this.taxonomyDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = !active ? this.taxonomyDao.getTermLinks(t) : this.taxonomyDao.getActiveTermLinks(t);
        if (loadDetails) {
            this.getTermLinkDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public Shape getShapeOfTerm(TaxonomyTerm tt, boolean loadDetails) throws Exception {
        Shape s = this.taxonomyTermDao.getShape(tt);
        if (loadDetails) {
            s.getCreator().getName();
            if (s.getCreator().getTenant() != null) {
                s.getCreator().getTenant().getName();
            }
            if (s.getShapeImport() != null) {
                s.getShapeImport().getShapeImport();
            }
        }
        return s;
    }

    @Transactional(readOnly=true)
    public List<Shape> getShapesOfTerm(TaxonomyTerm tt, boolean loadDetails) throws Exception {
        List shapes = this.taxonomyTermDao.getShapes(tt);
        if (loadDetails) {
            for (Shape s : shapes) {
                s.getCreator().getName();
                if (s.getCreator().getTenant() != null) {
                    s.getCreator().getTenant().getName();
                }
                if (s.getShapeImport() == null) continue;
                s.getShapeImport().getShapeImport();
            }
        }
        return shapes;
    }

    @Transactional(readOnly=true)
    public Shape getShapeOfTerm(TaxonomyTerm tt) throws Exception {
        return this.getShapeOfTerm(tt, false);
    }

    @Transactional(readOnly=true)
    public List<Shape> getShapesOfTerm(TaxonomyTerm tt) throws Exception {
        return this.getShapesOfTerm(tt, false);
    }

    @Transactional
    public void updateTaxonomy(Taxonomy t, String originalName, boolean create) {
        if (create) {
            Taxonomy ex = null;
            ex = t.getId() != null ? this.findTaxonomyById(t.getId().toString(), false) : this.findTaxonomyByName(t.getName(), false);
            if (ex != null) {
                log.error("Taxonomy " + t.getName() + " already exists");
                throw new IllegalArgumentException("Taxonomy " + t.getName() + " already exists");
            }
            this.taxonomyDao.create((Entity)t);
        } else {
            Taxonomy ex = null;
            ex = t.getId() != null ? this.findTaxonomyById(t.getId().toString(), false) : this.findTaxonomyByName(originalName, false);
            if (ex == null) {
                log.error("Taxonomy " + t.getName() + " does not exist");
                throw new IllegalArgumentException("Taxonomy " + t.getName() + " does not exist");
            }
            t.setId(ex.getId());
            t.setCreationDate(ex.getCreationDate());
            this.taxonomyDao.update((Entity)t);
        }
    }

    @Transactional
    public void updateTerm(TaxonomyTerm t, String originalName, String originalTaxonomyName, boolean create) {
        if (create) {
            TaxonomyTerm ex = null;
            ex = t.getId() != null ? this.findTermById(t.getId().toString(), false) : this.findTermByNameAndTaxonomy(t.getName(), t.getTaxonomy().getName(), false);
            if (ex != null) {
                log.error("Taxonomy term " + t.getName() + " already exists");
                throw new IllegalArgumentException("Taxonomy term " + t.getName() + " already exists");
            }
            this.taxonomyTermDao.create((Entity)t);
            if (t.getParent() != null) {
                List siblings = this.taxonomyTermDao.getSiblings(t);
                int max = 0;
                for (TaxonomyTerm s : siblings) {
                    if (s.getOrder() <= max) continue;
                    max = s.getOrder();
                }
                if (t.getOrder() <= 0 || t.getOrder() > max) {
                    t.setOrder(max + 1);
                } else {
                    for (TaxonomyTerm s : siblings) {
                        if (s.getOrder() < t.getOrder()) continue;
                        s.setOrder(s.getOrder() + 1);
                        this.taxonomyTermDao.update((Entity)s);
                    }
                }
            } else {
                t.setOrder(0);
            }
            this.taxonomyTermDao.update((Entity)t);
        } else {
            TaxonomyTerm ex = null;
            ex = t.getId() != null ? this.findTermById(t.getId().toString(), false) : this.findTermByNameAndTaxonomy(originalName, originalTaxonomyName, false);
            if (ex == null) {
                log.error("Taxonomy term" + t.getName() + " does not exist");
                throw new IllegalArgumentException("Taxonomy term " + t.getName() + " does not exist");
            }
            t.setId(ex.getId());
            t.setCreationDate(ex.getCreationDate());
            t.setCreator(ex.getCreator());
            if (t.getOrder() <= 0) {
                t.setOrder(ex.getOrder());
            } else {
                List siblings = this.taxonomyTermDao.getSiblings(t);
                int max = 0;
                for (TaxonomyTerm s : siblings) {
                    if (s.getOrder() <= max) continue;
                    max = s.getOrder();
                }
                if (t.getOrder() > max) {
                    t.setOrder(max + 1);
                } else {
                    for (TaxonomyTerm s : siblings) {
                        if (s.getOrder() < t.getOrder()) continue;
                        s.setOrder(s.getOrder() + 1);
                        this.taxonomyTermDao.update((Entity)s);
                    }
                }
            }
            this.taxonomyTermDao.update((Entity)t);
        }
    }

    @Transactional
    public void updateTermLink(String sourceTermTaxonomy, String sourceTerm, String destTermTaxonomy, String destTerm, String origSourceTermTaxonomy, String origSourceTerm, String origDestTermTaxonomy, String origDestTerm, TaxonomyTermLink.Verb verb, Principal creator, boolean create) throws Exception {
        TaxonomyTermLink ex = null;
        if (create) {
            TaxonomyTerm stt = this.findTermByNameAndTaxonomy(sourceTerm, sourceTermTaxonomy, false);
            TaxonomyTerm dtt = this.findTermByNameAndTaxonomy(destTerm, destTermTaxonomy, false);
            if (stt == null) {
                throw new Exception("Taxonomy term " + sourceTermTaxonomy + ":" + sourceTerm + " does not exist");
            }
            if (dtt == null) {
                throw new Exception("Taxonomy term " + destTermTaxonomy + ":" + destTerm + " does not exist");
            }
            ex = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)new TaxonomyTermLinkPK(stt.getId(), dtt.getId()));
            if (verb == null) {
                throw new Exception("Verb is mandatory for taxonomy term links");
            }
            if (ex != null) {
                log.error("Taxonomy term link " + sourceTermTaxonomy + ":" + sourceTerm + "->" + destTermTaxonomy + ":" + destTerm + " already exists");
                throw new Exception("Taxonomy term link " + sourceTermTaxonomy + ":" + sourceTerm + "->" + destTermTaxonomy + ":" + destTerm + " already exists");
            }
            TaxonomyTermLink ttl = new TaxonomyTermLink();
            ttl.setSourceTerm(stt);
            ttl.setDestinationTerm(dtt);
            ttl.setVerb(verb);
            ttl.setCreator(creator);
            this.taxonomyTermLinkDao.create((Entity)ttl);
        } else {
            TaxonomyTerm stt = this.findTermByNameAndTaxonomy(origSourceTerm, origSourceTermTaxonomy, false);
            TaxonomyTerm dtt = this.findTermByNameAndTaxonomy(origDestTerm, origDestTermTaxonomy, false);
            if (stt == null) {
                throw new Exception("Taxonomy term " + origSourceTermTaxonomy + ":" + origSourceTerm + " does not exist");
            }
            if (dtt == null) {
                throw new Exception("Taxonomy term " + origDestTermTaxonomy + ":" + origDestTerm + " does not exist");
            }
            ex = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)new TaxonomyTermLinkPK(stt.getId(), dtt.getId()));
            if (ex == null) {
                log.error("Taxonomy term link " + origSourceTermTaxonomy + ":" + origSourceTerm + "->" + origDestTermTaxonomy + ":" + origDestTerm + " does not exist");
                throw new Exception("Taxonomy term link " + origSourceTermTaxonomy + ":" + origSourceTerm + "->" + origDestTermTaxonomy + ":" + origDestTerm + " does not exist");
            }
            stt = this.findTermByNameAndTaxonomy(sourceTerm, sourceTermTaxonomy, false);
            dtt = this.findTermByNameAndTaxonomy(destTerm, destTermTaxonomy, false);
            if (stt == null) {
                throw new Exception("Taxonomy term " + sourceTermTaxonomy + ":" + sourceTerm + " does not exist");
            }
            if (dtt == null) {
                throw new Exception("Taxonomy term " + destTermTaxonomy + ":" + destTerm + " does not exist");
            }
            if (verb != null) {
                ex.setVerb(verb);
            }
            ex.setSourceTerm(stt);
            ex.setDestinationTerm(dtt);
            this.taxonomyTermLinkDao.update((Entity)ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTaxonomies(List<String> taxonomies) throws Exception {
        for (String t : taxonomies) {
            Taxonomy tax = this.findTaxonomyByName(t, false);
            if (tax == null) {
                throw new Exception("Taxonomy " + t + " not found");
            }
            List<TaxonomyTerm> tts = this.getTermsOfTaxonomy(tax.getId().toString(), false, false);
            for (TaxonomyTerm tt : tts) {
                List desc = this.taxonomyTermDao.getClassDescendants(tt);
                for (TaxonomyTerm d : desc) {
                    d.setTaxonomyTermClass(tt.getTaxonomyTermClass());
                    this.taxonomyTermDao.update((Entity)d);
                }
                desc = this.taxonomyTermDao.getChildren(tt);
                for (TaxonomyTerm d : desc) {
                    d.setParent(tt.getParent());
                    this.taxonomyTermDao.update((Entity)d);
                }
                List linked = this.taxonomyTermDao.getLinked(tt);
                for (TaxonomyTerm l : linked) {
                    TaxonomyTermLinkPK linkKey = new TaxonomyTermLinkPK(tt.getId(), l.getId());
                    TaxonomyTermLink link = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)linkKey);
                    if (link != null) {
                        this.taxonomyTermLinkDao.delete((Entity)link);
                    }
                    if ((link = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)(linkKey = new TaxonomyTermLinkPK(l.getId(), tt.getId())))) == null) continue;
                    this.taxonomyTermLinkDao.delete((Entity)link);
                }
                this.projectTermDao.deleteByTerm(tt);
                this.taxonomyTermDao.delete((Entity)tt);
            }
            List desc = this.taxonomyDao.getInstances(tax);
            for (Taxonomy d : desc) {
                d.setTaxonomyClass(tax.getTaxonomyClass());
                this.taxonomyDao.update((Entity)d);
            }
            this.taxonomyDao.delete((Entity)tax);
        }
    }

    @Transactional
    public void deleteTerm(TaxonomyTerm tt) throws Exception {
        if (tt.getOrder() > 1) {
            List siblings = this.taxonomyTermDao.getSiblings(tt);
            for (TaxonomyTerm s : siblings) {
                if (s.getOrder() > 0 && s.getOrder() >= tt.getOrder()) {
                    s.setOrder(s.getOrder() - 1);
                }
                this.taxonomyTermDao.update((Entity)s);
            }
        }
        List desc = this.taxonomyTermDao.getClassDescendants(tt);
        for (Object d : desc) {
            d.setTaxonomyTermClass(tt.getTaxonomyTermClass());
            this.taxonomyTermDao.update((Entity)d);
        }
        desc = this.taxonomyTermDao.getChildren(tt);
        for (Object d : desc) {
            d.setParent(tt.getParent());
            this.taxonomyTermDao.update((Entity)d);
        }
        List linked = this.taxonomyTermDao.getLinked(tt);
        for (TaxonomyTerm l : linked) {
            TaxonomyTermLinkPK linkKey = new TaxonomyTermLinkPK(tt.getId(), l.getId());
            TaxonomyTermLink link = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)linkKey);
            if (link != null) {
                this.taxonomyTermLinkDao.delete((Entity)link);
            }
            if ((link = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)(linkKey = new TaxonomyTermLinkPK(l.getId(), tt.getId())))) == null) continue;
            this.taxonomyTermLinkDao.delete((Entity)link);
        }
        this.taxonomyTermDao.update((Entity)tt);
        List ttss = this.taxonomyTermShapeDao.findByTerm(tt);
        if (ttss != null) {
            for (TaxonomyTermShape tts : ttss) {
                this.shapeDocumentDao.deleteByTaxonomyTermShape(tts);
                this.taxonomyTermShapeDao.delete((Entity)tts);
            }
        }
        this.projectTermDao.deleteByTerm(tt);
        this.taxonomyTermDao.delete((Entity)tt);
    }

    @Transactional
    public void deleteTerms(List<TaxonomyTermInfo> terms) throws Exception {
        boolean error = false;
        for (TaxonomyTermInfo t : terms) {
            TaxonomyTerm tt = this.findTermByNameAndTaxonomy(t.getTerm(), t.getTaxonomy(), false);
            if (tt != null) {
                this.deleteTerm(tt);
                continue;
            }
            error = true;
        }
        if (error) {
            throw new Exception("Could not delete all taxonomy terms");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTermLinks(List<TaxonomyTermLinkInfo> links) throws Exception {
        for (TaxonomyTermLinkInfo l : links) {
            TaxonomyTerm st = this.findTermByNameAndTaxonomy(l.getSourceTerm(), l.getSourceTermTaxonomy(), false);
            TaxonomyTerm dt = this.findTermByNameAndTaxonomy(l.getDestTerm(), l.getDestTermTaxonomy(), false);
            TaxonomyTermLink ttl = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)new TaxonomyTermLinkPK(st.getId(), dt.getId()));
            if (ttl == null) {
                log.error("Taxonomy term link " + l.getSourceTermTaxonomy() + ":" + l.getSourceTerm() + "->" + l.getDestTermTaxonomy() + ":" + l.getDestTerm() + " was not found");
                throw new Exception("Taxonomy term link " + l.getSourceTermTaxonomy() + ":" + l.getSourceTerm() + "->" + l.getDestTermTaxonomy() + ":" + l.getDestTerm() + " was not found");
            }
            this.taxonomyTermLinkDao.delete((Entity)ttl);
        }
    }
}

