/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import gr.cite.gaap.datatransferobjects.AttributeInfo;
import gr.cite.gaap.datatransferobjects.ShapeImportInfo;
import gr.cite.gaap.datatransferobjects.ShapeImportInstance;
import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.ShapeManager;
import gr.cite.gaap.servicelayer.TaxonomyManager;
import gr.cite.gaap.utilities.HtmlUtils;
import gr.cite.gaap.utilities.TypeUtils;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.dataaccess.dao.UUIDGenerator;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.security.principal.dao.PrincipalDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeImport;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeImportDao;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermDao;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShapeImportManager {
    private PrincipalDao principalDao;
    private TaxonomyManager taxonomyManager;
    private ShapeManager shapeManager;
    private ConfigurationManager configurationManager;
    private ShapeImportDao shapeImportDao;
    private TaxonomyTermDao taxonomyTermDao;
    private static final String NoMappingKey = "\t\t\t__NoVal__\t\t\t";
    private static final String NoValueKey = "";
    private static final Logger log = LoggerFactory.getLogger(ShapeImportManager.class);
    private boolean inferTypes = false;
    private Map<String, ShapeAttributeDataType> featureTypes = new HashMap<String, ShapeAttributeDataType>();
    public static final String DefaultCharset = "UTF-8";
    public static final boolean DefaultForceLonLat = false;

    public ShapeImportManager() {
    }

    @Inject
    public ShapeImportManager(PrincipalDao principalDao, TaxonomyManager taxonomyManager, ConfigurationManager configManager) {
        this.principalDao = principalDao;
        this.taxonomyManager = taxonomyManager;
        this.configurationManager = configManager;
    }

    @Inject
    public void setShapeManager(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    @Inject
    public void setShapeImportDao(ShapeImportDao shapeImportDao) {
        this.shapeImportDao = shapeImportDao;
    }

    @Inject
    public void setTaxonomyTermDao(TaxonomyTermDao taxonomyTermDao) {
        this.taxonomyTermDao = taxonomyTermDao;
    }

    public void setTypeInference(boolean val) {
        this.inferTypes = val;
    }

    public void addFeatureTypes(Map<String, ShapeAttributeDataType> types) {
        this.featureTypes.putAll(types);
    }

    public void clearFeatureTypes() {
        this.featureTypes.clear();
    }

    public ShapeImportInfo fromShapeFile(String filename, String termId, int srid) throws Exception {
        return this.fromShapefile(filename, termId, srid, DefaultCharset, false, null, this.principalDao.systemPrincipal(), true);
    }

    public ShapeImportInfo fromShapeFile(String filename, String termId, int srid, String charset) throws Exception {
        return this.fromShapefile(filename, termId, srid, charset, false, null, this.principalDao.systemPrincipal(), true);
    }

    public ShapeImportInfo fromShapeFile(String filename, String termId, int srid, String charset, boolean forceLonLat) throws Exception {
        return this.fromShapefile(filename, termId, srid, charset, forceLonLat, null, this.principalDao.systemPrincipal(), true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String inferType(AttributeType t, Object value) throws Exception {
        if (t.getBinding().getName().equals(String.class.getName())) {
            String val = (String)value;
            if (this.featureTypes.containsKey(t.getName().toString())) {
                if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.STRING) return "string";
                switch (this.featureTypes.get(t.getName().toString())) {
                    case SHORT: {
                        Short.parseShort(val);
                        return "short";
                    }
                    case INTEGER: {
                        Integer.parseInt(val);
                        return "integer";
                    }
                    case LONG: {
                        Long.parseLong(val);
                        return "long";
                    }
                    case FLOAT: {
                        Float.parseFloat(val);
                        return "float";
                    }
                    case DOUBLE: {
                        Double.parseDouble(val);
                        return "double";
                    }
                    case DATE: {
                        return "date";
                    }
                    case STRING: 
                    case LONGSTRING: {
                        return "string";
                    }
                }
                throw new Exception("Unrecognized data type: " + t.getBinding().getName());
            }
            if (!this.inferTypes) return "string";
            if (TypeUtils.tryParseShort((String)val) != null) {
                return "short";
            }
            if (TypeUtils.tryParseInteger((String)val) != null) {
                return "integer";
            }
            if (TypeUtils.tryParseLong((String)val) != null) {
                return "long";
            }
            if (TypeUtils.tryParseFloat((String)val) != null) {
                return "float";
            }
            if (TypeUtils.tryParseDouble((String)val) != null) {
                return "double";
            }
            if (TypeUtils.tryParseDate((String)val, (String)"MMM dd yyyy HH:mm:ss") == null) return "string";
            return "date";
        }
        if (t.getBinding().getName().equals(Integer.class.getName())) {
            Integer val = (Integer)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "integer";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.INTEGER) return "integer";
            switch (this.featureTypes.get(t.getName().toString())) {
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case LONG: {
                    return "long";
                }
                case SHORT: {
                    return "integer";
                }
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
            }
            return "integer";
        }
        if (t.getBinding().getName().equals(Long.class.getName())) {
            Long val = (Long)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "long";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.LONG) return "long";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case SHORT: 
                case INTEGER: {
                    return "long";
                }
            }
            return "long";
        }
        if (t.getBinding().getName().equals(Short.class.getName())) {
            Short val = (Short)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "short";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.SHORT) return "short";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case INTEGER: {
                    return "integer";
                }
                case LONG: {
                    return "long";
                }
            }
            return "short";
        }
        if (t.getBinding().getName().equals(Float.class.getName())) {
            Float val = (Float)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "float";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.FLOAT) return "float";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
            }
            return "float";
        }
        if (t.getBinding().getName().equals(Double.class.getName())) {
            Double val = (Double)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "double";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.DOUBLE) return "double";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    return "double";
                }
                case FLOAT: {
                    return "double";
                }
            }
            return "double";
        }
        if (!t.getBinding().getName().equals(Date.class.getName())) throw new Exception("Unrecognized data type: " + t.getBinding().getName());
        Date val = (Date)value;
        if (!this.featureTypes.containsKey(t.getName().toString())) return "date";
        if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.DATE) return "date";
        switch (this.featureTypes.get(t.getName().toString())) {
            case STRING: 
            case LONGSTRING: {
                return "string";
            }
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return "long";
            }
        }
        return "date";
    }

    private String insertBursaWolfToWKT(String wkt, double[] bursaWolf) {
        String[] defs = wkt.split("DATUM\\[");
        if (defs.length != 2) {
            log.warn("Could not insert Bursa-Wolf Parameters to CRS WKT");
            return wkt;
        }
        int bracketCount = 1;
        int index = 0;
        int prevClose = -1;
        while (bracketCount != 0) {
            int close = defs[1].indexOf(93, index);
            if (prevClose == -1) {
                prevClose = close;
            }
            int open = defs[1].indexOf(91, index);
            if (close == -1) {
                log.warn("Invalid wkt");
                return null;
            }
            if (open < close) {
                ++bracketCount;
                index = open + 1;
            } else {
                --bracketCount;
                index = close + 1;
            }
            if (bracketCount == 0) continue;
            prevClose = close;
        }
        StringBuilder formattedBursaWolf = new StringBuilder();
        for (int i = 0; i < bursaWolf.length; ++i) {
            formattedBursaWolf.append(String.format(Locale.US, "%.2f", bursaWolf[i]));
            if (i == bursaWolf.length - 1) continue;
            formattedBursaWolf.append(", ");
        }
        String res = defs[0] + "DATUM[" + defs[1].substring(0, prevClose + 1) + ", TOWGS84[" + formattedBursaWolf.toString() + "]" + defs[1].substring(prevClose + 1);
        return res;
    }

    private void addMappingConfig(AttributeMappingConfig mcfg, Map<String, Map<String, AttributeMappingConfig>> cfgCache) throws Exception {
        if (cfgCache == null) {
            this.configurationManager.updateMappingConfig(mcfg);
            return;
        }
        String key = null;
        if (mcfg.getAttributeName() == null) {
            return;
        }
        key = mcfg.getTermId() == null && mcfg.getAttributeValue() == null ? NoMappingKey : (mcfg.getAttributeValue() == null ? NoValueKey : mcfg.getAttributeValue());
        if (cfgCache.get(mcfg.getAttributeName()) == null) {
            cfgCache.put(mcfg.getAttributeName(), new HashMap());
        }
        if (cfgCache.get(mcfg.getAttributeName()).get(key) == null) {
            cfgCache.get(mcfg.getAttributeName()).put(key, mcfg);
            this.configurationManager.updateMappingConfig(mcfg);
        }
    }

    private String createDataXML(SimpleFeature feature, Map<String, Map<String, AttributeInfo>> attrInfo, Map<String, Taxonomy> taxonomyCache, String layerTermId, Map<String, Map<String, AttributeMappingConfig>> cfgCache, boolean forceOverwriteMappings) throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<extraData>");
        List types = feature.getType().getTypes();
        for (AttributeType t : types) {
            Object val = feature.getAttribute(t.getName());
            if (val == null) continue;
            String type = null;
            type = attrInfo == null ? this.inferType(t, val) : attrInfo.get(t.getName().toString()).get(NoValueKey).getType();
            boolean setTaxonomy = false;
            boolean setValue = false;
            String taxonomyId = null;
            String termId = null;
            String attrValue = null;
            Boolean presentable = true;
            Boolean mapValue = true;
            if (attrInfo != null) {
                String taxonomy = null;
                AttributeInfo ai = attrInfo.get(t.getName().toString()).get(val);
                if (!val.equals(NoValueKey) && attrInfo.get(t.getName().toString()).get(val.toString()) != null) {
                    taxonomy = attrInfo.get(t.getName().toString()).get(val.toString()).getTaxonomy();
                    setValue = true;
                } else {
                    if (!attrInfo.get(t.getName().toString()).get(NoValueKey).isStore()) continue;
                    taxonomy = attrInfo.get(t.getName().toString()).get(NoValueKey).getTaxonomy();
                    presentable = attrInfo.get(t.getName().toString()).get(NoValueKey).isPresentable();
                }
                if (taxonomy != null) {
                    Taxonomy tax = taxonomyCache.get(taxonomy);
                    if (tax == null) {
                        tax = this.taxonomyManager.findTaxonomyByName(taxonomy, false);
                    }
                    if (tax == null) {
                        throw new Exception("Could not find taxonomy " + taxonomy);
                    }
                    taxonomyCache.put(taxonomy, tax);
                    setTaxonomy = true;
                    taxonomyId = tax.getId().toString();
                    if (setValue) {
                        AttributeInfo valueMappingInfo = attrInfo.get(t.getName().toString()).get(val.toString());
                        String term = valueMappingInfo.getTerm();
                        attrValue = valueMappingInfo.getValue();
                        if (term == null) {
                            log.error("No taxonomy term is defined for attribute value mapping (" + t.getName() + "," + val + ")");
                            throw new Exception("No taxonomy term is defined for attribute value mapping (" + t.getName() + "," + val + ")");
                        }
                        TaxonomyTerm tt = null;
                        tt = this.taxonomyManager.findTermByNameAndTaxonomy(term, taxonomy, false);
                        if (tt == null) {
                            throw new Exception("Could not find taxonomy term " + term);
                        }
                        termId = tt.getId().toString();
                        mapValue = valueMappingInfo.isMapValue();
                    }
                }
            }
            AttributeMappingConfig mcfg = new AttributeMappingConfig();
            mcfg.setAttributeName(t.getName().toString());
            mcfg.setAttributeType(type);
            mcfg.setLayerTermId(layerTermId);
            mcfg.setPresentable(presentable);
            if (setTaxonomy || setValue) {
                if (setValue) {
                    mcfg.setAttributeValue(attrValue);
                    mcfg.setMapValue(mapValue);
                }
                if (setTaxonomy || setValue) {
                    mcfg.setTermId(setValue ? termId : taxonomyId);
                }
            }
            this.addMappingConfig(mcfg, cfgCache);
            Map<String, AttributeInfo> aim = attrInfo.get(t.getName().toString());
            if (aim.size() > 1 && aim.get(NoValueKey) != null && aim.get(NoValueKey).getTaxonomy() != null) {
                mcfg = new AttributeMappingConfig();
                mcfg.setAttributeName(t.getName().toString());
                mcfg.setLayerTermId(layerTermId);
                mcfg.setAttributeType(type);
                mcfg.setPresentable(presentable);
                mcfg.setTermId(taxonomyId);
                this.addMappingConfig(mcfg, cfgCache);
            }
            String processedVal = HtmlUtils.htmlEscape((String)this.discardIllegalValues(type, feature.getAttribute(t.getName()).toString().trim()));
            xml.append("<" + t.getName() + " type=\"" + type + "\" " + (setTaxonomy ? "taxonomy=\"" + taxonomyId + "\" " : NoValueKey) + (setValue ? "term=\"" + termId + "\"" : NoValueKey) + ">");
            xml.append(processedVal);
            xml.append("</" + t.getName() + ">");
        }
        xml.append("</extraData>");
        return xml.toString();
    }

    private String discardIllegalValues(String type, String value) {
        try {
            if (type.equals("short")) {
                Short.parseShort(value);
            } else if (type.equals("integer")) {
                Integer.parseInt(value);
            } else if (type.equals("long")) {
                Long.parseLong(value);
            } else if (type.equals("float")) {
                Float.parseFloat(value);
            } else if (type.equals("double")) {
                Double.parseDouble(value);
            }
        }
        catch (NumberFormatException e) {
            return NoValueKey;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    private ShapeImportInfo fromFeatureSource(DataStore dataStore, SimpleFeatureSource featureSource, String termId, int srid, boolean forceLonLat, Map<String, Map<String, AttributeInfo>> attrInfo, Principal principal, boolean forceOverwriteMappings) throws Exception {
        HashMap<String, Taxonomy> taxonomyCache = new HashMap<String, Taxonomy>();
        SimpleFeatureCollection collection = featureSource.getFeatures();
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        SimpleFeatureIterator iterator = collection.features();
        String sourceCode = null;
        if (srid != -1) {
            sourceCode = "EPSG:" + new Integer(srid).toString();
        }
        String targetCode = "EPSG:4326";
        CoordinateReferenceSystem sourceCRS = null;
        if (schema.getCoordinateReferenceSystem() != null) {
            sourceCRS = schema.getCoordinateReferenceSystem();
        } else if (sourceCode != null) {
            sourceCRS = CRS.decode(sourceCode);
        }
        if (sourceCRS == null) {
            throw new Exception("No coordinate system provided nor found in shape file definition");
        }
        CoordinateReferenceSystem targetCRS = CRS.decode((String)targetCode, (boolean)forceLonLat);
        UUID importUUID = UUIDGenerator.randomUUID();
        boolean lenient = false;
        String wkt = sourceCRS.toWKT();
        if (!wkt.toLowerCase().contains("towgs")) {
            if (CRS.lookupEpsgCode((CoordinateReferenceSystem)sourceCRS, (boolean)true) == 2100) {
                double[] bursaWolf = new double[]{-199.87, 74.79, 246.62, 0.0, 0.0, 0.0, 0.0};
                log.warn("No transformation parameters were found within source CRS data.Automatically applying: " + Arrays.toString(bursaWolf));
                wkt = this.insertBursaWolfToWKT(wkt, bursaWolf);
                sourceCRS = CRS.parseWKT((String)wkt);
            } else {
                log.warn("No transformation parameters were found within source CRS data. Transformation may contain errors");
                lenient = true;
            }
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
        ReferencedEnvelope b = featureSource.getBounds();
        b = JTS.transform((Envelope)b, (MathTransform)transform);
        Bounds bounds = new Bounds();
        bounds.setCrs("EPSG:4326");
        bounds.setMinx(b.getMinX());
        bounds.setMiny(b.getMinY());
        bounds.setMaxx(b.getMaxX());
        bounds.setMaxy(b.getMaxY());
        Geometry g = null;
        try {
            HashMap<String, Map<String, AttributeMappingConfig>> cfgCache = new HashMap<String, Map<String, AttributeMappingConfig>>();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                g = (Geometry)feature.getDefaultGeometry();
                g = JTS.transform((Geometry)g, (MathTransform)transform);
                g.setSRID(4326);
                String data = this.createDataXML(feature, attrInfo, taxonomyCache, termId, cfgCache, forceOverwriteMappings);
                ShapeImport shape = new ShapeImport();
                shape.setCreationDate(Calendar.getInstance().getTime());
                shape.setCreator(principal);
                shape.setData(data);
                shape.setId(UUIDGenerator.randomUUID());
                shape.setLastUpdate(Calendar.getInstance().getTime());
                shape.setShapeIdentity(termId);
                shape.setShapeImport(importUUID);
                shape.setGeography(g);
                this.shapeImportDao.create((Entity)shape);
            }
        }
        finally {
            iterator.close();
        }
        HashMap<String, Set<String>> valueMappingValues = new HashMap<String, Set<String>>();
        block4: for (Map<String, AttributeInfo> aie : attrInfo.values()) {
            AttributeInfo ai = aie.get(NoValueKey);
            if (ai != null) {
                valueMappingValues.put(ai.getName(), this.getAttributeValuesFromFeatureSource(featureSource, ai.getName()));
                continue;
            }
            for (AttributeInfo info : aie.values()) {
                if (info.getValue() == null) continue;
                valueMappingValues.put(ai.getName(), this.getAttributeValuesFromFeatureSource(featureSource, info.getName()));
                continue block4;
            }
        }
        return new ShapeImportInfo(importUUID, bounds, valueMappingValues);
    }

    @Transactional
    public ShapeImportInfo fromShapefile(String pathName, String termId, int srid, String charset, boolean forceLonLat, Map<String, Map<String, AttributeInfo>> attrInfo, Principal principal, boolean forceOverwriteMappings) throws Exception {
        if (srid < 0 && srid != -1) {
            throw new IllegalArgumentException("Illegal srid code");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Creator not provided");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(pathName);
        map.put("url", file.toURI().toString());
        map.put("charset", charset);
        SimpleFeatureSource featureSource = null;
        DataStore dataStore = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            featureSource = dataStore.getFeatureSource(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            log.error("Error while reading shape file", (Throwable)e);
            throw e;
        }
        return this.fromFeatureSource(dataStore, featureSource, termId, srid, forceLonLat, attrInfo, principal, forceOverwriteMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> analyzeAttributesOfFeatureSource(SimpleFeatureSource featureSource) throws Exception {
        SimpleFeatureCollection collection = featureSource.getFeatures();
        HashMap<String, String> attributes = new HashMap<String, String>();
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                List types = feature.getType().getTypes();
                for (AttributeType t : types) {
                    Object val = feature.getAttribute(t.getName());
                    if (val == null) continue;
                    String type = this.inferType(t, val);
                    attributes.put(t.getName().toString(), type);
                }
            }
            HashMap<String, String> hashMap = attributes;
            return hashMap;
        }
    }

    public Map<String, String> analyzeAttributesOfShapeFile(String filename, String charset) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(filename);
        map.put("url", file.toURI().toString());
        map.put("charset", charset);
        SimpleFeatureSource featureSource = null;
        DataStore dataStore = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            featureSource = dataStore.getFeatureSource(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            log.error("Error while reading shape file", (Throwable)e);
            throw e;
        }
        return this.analyzeAttributesOfFeatureSource(featureSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAttributeValuesFromFeatureSource(SimpleFeatureSource featureSource, String attribute) throws Exception {
        SimpleFeatureCollection collection = featureSource.getFeatures();
        HashSet<String> values = new HashSet<String>();
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                List types = feature.getType().getTypes();
                for (AttributeType t : types) {
                    Object val;
                    if (!t.getName().toString().equals(attribute) || (val = feature.getAttribute(t.getName())) == null) continue;
                    values.add(val.toString());
                }
            }
            HashSet<String> hashSet = values;
            return hashSet;
        }
    }

    public Set<String> getAttributeValuesFromShapeFile(String pathname, String charset, String attribute) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(pathname);
        map.put("url", file.toURI().toString());
        map.put("charset", charset);
        SimpleFeatureSource featureSource = null;
        DataStore dataStore = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            featureSource = dataStore.getFeatureSource(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            log.error("Error while reading shape file", (Throwable)e);
            throw e;
        }
        return this.getAttributeValuesFromFeatureSource(featureSource, attribute);
    }

    @Transactional(readOnly=true)
    public List<ShapeImport> getImport(UUID importId) throws Exception {
        return this.shapeImportDao.getImport(importId);
    }

    @Transactional(readOnly=true)
    public List<ShapeImport> findByImportIdentity(String identity) throws Exception {
        return this.shapeImportDao.findByIdentity(identity);
    }

    @Transactional(readOnly=true)
    public List<ShapeImportInstance> getImportInstances(boolean nonEmpty) throws Exception {
        ArrayList<ShapeImportInstance> res = new ArrayList<ShapeImportInstance>();
        List instances = this.shapeImportDao.listImports();
        for (UUID instance : instances) {
            TaxonomyTerm tt;
            ShapeImport si = this.getImport(instance).get(0);
            if (nonEmpty && this.shapeManager.countShapesOfImport(instance) == 0L) continue;
            ShapeImportInstance sii = new ShapeImportInstance();
            sii.setImportId(instance);
            if (si.getShapeIdentity() != null && (tt = (TaxonomyTerm)this.taxonomyTermDao.read((Serializable)UUID.fromString(si.getShapeIdentity()))) != null) {
                sii.setTermTaxonomy(tt.getTaxonomy().getName());
                sii.setTerm(tt.getName());
            }
            sii.setTimestamp(si.getCreationDate().getTime());
            res.add(sii);
        }
        return res;
    }
}

