/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.resource;

import com.google.common.io.Files;
import com.google.inject.Inject;
import gr.cite.commons.util.datarepository.DataRepository;
import gr.cite.commons.util.datarepository.elements.RepositoryFile;
import gr.cite.commons.util.datarepository.inject.FileSystemDataRepositoryProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/datarepository")
public class FileSystemDataRepositoryResource {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemDataRepositoryResource.class);
    private static final String GET_FILE = "getFile";
    private final FileSystemDataRepositoryProvider dataRepositoryProvider;
    private final String publicUrl;

    @Inject
    public FileSystemDataRepositoryResource(FileSystemDataRepositoryProvider dataRepositoryProvider, @Named(value="publicUrl") String publicUrl) {
        this.dataRepositoryProvider = dataRepositoryProvider;
        this.publicUrl = publicUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="insertBase64")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml"})
    public Response insertBase64File(String base64String) {
        RepositoryFile repositoryFile = new RepositoryFile();
        String metadata = base64String.substring(0, base64String.indexOf(","));
        String encoding = metadata.substring(metadata.indexOf(";") + 1);
        if (!encoding.equals("base64")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
        }
        String type = metadata.substring(metadata.indexOf(":") + 1, metadata.indexOf(";"));
        repositoryFile.setDataType(type);
        String imageDataBytes = base64String.substring(base64String.indexOf(",") + 1);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(Base64.decodeBase64((byte[])imageDataBytes.getBytes()));){
            repositoryFile.setInputStream((InputStream)stream);
            DataRepository fileDataRepository = this.dataRepositoryProvider.get();
            String id = fileDataRepository.persist(repositoryFile);
            repositoryFile.setId(id);
            Response response = Response.ok((Object)repositoryFile).build();
            return response;
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="insertInputStream")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/xml"})
    public Response insertInputStream(InputStream input, @QueryParam(value="datatype") String dataType) {
        RepositoryFile repositoryFile = new RepositoryFile();
        repositoryFile.setDataType(dataType);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)input));){
            repositoryFile.setInputStream((InputStream)inputStream);
            DataRepository fileDataRepository = this.dataRepositoryProvider.get();
            String id = fileDataRepository.persist(repositoryFile);
            repositoryFile.setId(id);
            Response response = Response.ok((Object)repositoryFile).build();
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="getFile/{id}")
    public Response getFile(@PathParam(value="id") String id) {
        try {
            RepositoryFile repositoryFile = this.dataRepositoryProvider.get().retrieve(id);
            if (repositoryFile == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            MediaType type = MediaType.valueOf((String)repositoryFile.getDataType());
            logger.info("Retrieved file with local image: " + repositoryFile.getLocalImage().toString());
            Response.ResponseBuilder response = Response.ok((Object)new File(repositoryFile.getLocalImage()));
            response.type(type);
            response.header("Content-Disposition", (Object)("inline; filename=\"" + repositoryFile.getOriginalName() + "\""));
            return response.build();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="getBase64URI/{id}")
    @Produces(value={"multipart/form-data"})
    public Response getFileInBase64URI(@PathParam(value="id") String id) {
        try {
            RepositoryFile repositoryFile = this.dataRepositoryProvider.get().retrieve(id);
            StringBuffer buffer = new StringBuffer("data:");
            buffer.append(repositoryFile.getDataType());
            buffer.append(";base64,");
            buffer.append(new String(Base64.encodeBase64((byte[])Files.toByteArray((File)new File(repositoryFile.getLocalImage())))));
            return Response.ok((Object)buffer.toString()).build();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @Path(value="removeFile/{id}")
    public Response removeFile(@PathParam(value="id") String id) {
        try {
            this.dataRepositoryProvider.get().delete(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private URI createPublicLocalImageUrl(String id) {
        return UriBuilder.fromPath((String)this.publicUrl).path(GET_FILE).path(id).build(new Object[0]);
    }

    @POST
    @Path(value="persist")
    @Consumes(value={"application/json"})
    public RepositoryFile persist(RepositoryFile file) throws Exception {
        String id = this.dataRepositoryProvider.get().persist(file);
        this.dataRepositoryProvider.get().close(file);
        RepositoryFile newRf = new RepositoryFile();
        newRf.setDataType(file.getDataType());
        newRf.setId(file.getId());
        newRf.setLocalImage(this.createPublicLocalImageUrl(id));
        newRf.setOriginalName(file.getOriginalName());
        newRf.setPermanent(file.isPermanent());
        newRf.setSize(file.getSize());
        newRf.setTimestamp(file.getTimestamp());
        newRf.setUri(file.getUri());
        newRf.markPersisted();
        return newRf;
    }

    @POST
    @Path(value="update")
    @Consumes(value={"application/json"})
    public RepositoryFile update(RepositoryFile file) throws Exception {
        String id = this.dataRepositoryProvider.get().update(file);
        file.setLocalImage(this.createPublicLocalImageUrl(id));
        return file;
    }

    @GET
    @Path(value="retrieve/{id}")
    @Produces(value={"application/json"})
    public RepositoryFile retrieve(@PathParam(value="id") String id) throws Exception {
        RepositoryFile file = this.dataRepositoryProvider.get().retrieve(id);
        if (file == null) {
            logger.warn("Could not find file " + id);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        RepositoryFile newRf = new RepositoryFile();
        newRf.setDataType(file.getDataType());
        newRf.setId(file.getId());
        newRf.setLocalImage(this.createPublicLocalImageUrl(id));
        newRf.setOriginalName(file.getOriginalName());
        newRf.setPermanent(file.isPermanent());
        newRf.setSize(file.getSize());
        newRf.setTimestamp(file.getTimestamp());
        newRf.setUri(file.getUri());
        if (file.getState() == RepositoryFile.State.PERSISTED) {
            newRf.markPersisted();
        }
        return newRf;
    }

    @POST
    @Path(value="delete/{id}")
    public void delete(@PathParam(value="id") String id) throws Exception {
        this.dataRepositoryProvider.get().delete(id);
    }

    @GET
    @Path(value="listIds")
    @Produces(value={"application/json"})
    public List<String> listIds() throws Exception {
        return this.dataRepositoryProvider.get().listIds();
    }

    @POST
    @Path(value="persistToFolder")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String persistToFolder(List<RepositoryFile> files) throws Exception {
        return this.dataRepositoryProvider.get().persistToFolder(files);
    }

    @POST
    @Path(value="updateToFolder/{id}")
    @Consumes(value={"application/json"})
    public String updateToFolder(RepositoryFile file, @PathParam(value="id") String folderId) throws Exception {
        return this.dataRepositoryProvider.get().updateToFolder(file, folderId);
    }

    @POST
    @Path(value="updateToFolderMultipleFiles/{id}")
    @Consumes(value={"application/json"})
    public String updateToFolder(List<RepositoryFile> files, @PathParam(value="id") String folderId) throws Exception {
        return this.dataRepositoryProvider.get().updateToFolder(files, folderId);
    }

    @POST
    @Path(value="addToFolder/{id}")
    @Consumes(value={"application/json"})
    public String addToFolder(RepositoryFile file, @PathParam(value="id") String folderId) throws Exception {
        return this.dataRepositoryProvider.get().addToFolder(file, folderId);
    }

    @POST
    @Path(value="addToFolderMultipleFiles/{id}")
    @Consumes(value={"application/json"})
    public String addToFolder(List<RepositoryFile> files, @PathParam(value="id") String folderId) throws Exception {
        return this.dataRepositoryProvider.get().addToFolder(files, folderId);
    }

    @GET
    @Path(value="listFolder/{id}")
    @Produces(value={"application/json"})
    public List<String> listFolder(@PathParam(value="id") String folderId) throws Exception {
        return this.dataRepositoryProvider.get().listFolder(folderId);
    }

    @GET
    @Path(value="getTotalSize")
    public Response getTotalSize() {
        return Response.ok((Object)String.valueOf(this.dataRepositoryProvider.get().getTotalSize())).build();
    }

    @GET
    @Path(value="getLastSweep")
    public Response getLastSweep() {
        Long lastSweep = this.dataRepositoryProvider.get().getLastSweep();
        return lastSweep != null ? Response.ok((Object)String.valueOf(lastSweep)).build() : Response.noContent().build();
    }

    @GET
    @Path(value="getSweepSizeReduction")
    public Response getSweepSizeReduction() {
        Long reduction = this.dataRepositoryProvider.get().getSweepSizeReduction();
        return reduction != null ? Response.ok((Object)String.valueOf(reduction)).build() : Response.noContent().build();
    }

    @POST
    @Path(value="close")
    @Consumes(value={"application/json"})
    public Response close(RepositoryFile file) throws Exception {
        return Response.ok((Object)String.valueOf(this.dataRepositoryProvider.get().close(file))).build();
    }
}

