/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.additionalemailaddresses;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.User;
import com.liferay.portal.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import java.util.List;

public class CheckAdditionalEmailAddresses {
    private static Log log = LogFactoryUtil.getLog(CheckAdditionalEmailAddresses.class);

    public static User checkInIfAdditionalEmailAndIfVerified(String emailAddressName) throws Exception {
        long columnId = CheckAdditionalEmailAddresses.getColumnId();
        List<EmailAddress> emailAddresses = CheckAdditionalEmailAddresses.getEmailAddresses(emailAddressName);
        User user = CheckAdditionalEmailAddresses.checkIfIsVerified(columnId, emailAddresses);
        return user;
    }

    private static User checkIfIsVerified(long columnId, List<EmailAddress> emailAddresses) throws SystemException, NoSuchUserException {
        User user = null;
        for (EmailAddress emailAddress : emailAddresses) {
            DynamicQuery dynamicQueryValue = DynamicQueryFactoryUtil.forClass(ExpandoValue.class, (ClassLoader)PortletClassLoaderUtil.getClassLoader());
            Criterion critirioValue = RestrictionsFactoryUtil.eq((String)"columnId", (Object)columnId);
            critirioValue = RestrictionsFactoryUtil.and((Criterion)critirioValue, (Criterion)RestrictionsFactoryUtil.eq((String)"data", (Object)"true"));
            critirioValue = RestrictionsFactoryUtil.and((Criterion)critirioValue, (Criterion)RestrictionsFactoryUtil.eq((String)"classPK", (Object)emailAddress.getEmailAddressId()));
            dynamicQueryValue.add(critirioValue);
            List expandoValues = ExpandoValueLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQueryValue);
            if (expandoValues.size() <= 0) continue;
            long userId = emailAddress.getUserId();
            try {
                user = UserLocalServiceUtil.getUser((long)userId);
                break;
            }
            catch (Exception e) {
                log.error((Object)("User with id " + userId + " was not found"));
                throw new NoSuchUserException();
            }
        }
        return user;
    }

    private static List<EmailAddress> getEmailAddresses(String emailAddressName) throws SystemException {
        DynamicQuery dynamicQueryEmailAddresses = DynamicQueryFactoryUtil.forClass(EmailAddress.class, (ClassLoader)PortletClassLoaderUtil.getClassLoader());
        Criterion critirioColumn = RestrictionsFactoryUtil.eq((String)"address", (Object)emailAddressName);
        dynamicQueryEmailAddresses.add(critirioColumn);
        List emailAddresses = EmailAddressLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQueryEmailAddresses);
        return emailAddresses;
    }

    private static long getColumnId() throws Exception {
        DynamicQuery dynamicQueryColumn = DynamicQueryFactoryUtil.forClass(ExpandoColumn.class, (ClassLoader)PortletClassLoaderUtil.getClassLoader());
        Criterion critirioColumn = RestrictionsFactoryUtil.eq((String)"name", (Object)"verifiedAdditionalEmail");
        dynamicQueryColumn.add(critirioColumn);
        List expandoColumns = ExpandoColumnLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQueryColumn);
        if (expandoColumns.size() != 1) {
            log.error((Object)"Expando table has more than one column with nameverifiedAdditionalEmail");
            throw new Exception("Expando table has more than one column with nameverifiedAdditionalEmail");
        }
        ExpandoColumn expandoColumn = (ExpandoColumn)expandoColumns.get(0);
        long columnId = expandoColumn.getColumnId();
        return columnId;
    }
}

