/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.service;

import com.liferay.portal.kernel.exception.NestableException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.User;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import models.Email;
import org.springframework.stereotype.Component;

@Component
public class ExpandoService {
    private static Log log = LogFactoryUtil.getLog(ExpandoService.class);

    public void addValueToTable(long companyId, Class<?> portalModel, String columnName, long modelPrimaryKey, String value) throws NestableException {
        try {
            ExpandoValueLocalServiceUtil.addValue((long)companyId, (String)portalModel.getName(), (String)"CUSTOM_FIELDS", (String)columnName, (long)modelPrimaryKey, (String)value);
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Error during the addition of the value", e);
            e.printStackTrace();
            throw e;
        }
    }

    public void addValueToTable(long companyId, Class<?> portalModel, String columnName, long modelPrimaryKey, Boolean value) throws NestableException {
        try {
            ExpandoValueLocalServiceUtil.addValue((long)companyId, (String)portalModel.getName(), (String)"CUSTOM_FIELDS", (String)columnName, (long)modelPrimaryKey, (Object)value);
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Error during the addition of the value", e);
            e.printStackTrace();
            throw e;
        }
    }

    public void updateEmailAddressesTable(User user, EmailAddress emailAddress, String generatedUUID) throws NestableException {
        try {
            this.addValueToTable(emailAddress.getCompanyId(), EmailAddress.class, "verificationCodeAdditionalEmail", emailAddress.getEmailAddressId(), generatedUUID);
            this.addValueToTable(emailAddress.getCompanyId(), EmailAddress.class, "verifiedAdditionalEmail", emailAddress.getEmailAddressId(), Boolean.valueOf(false));
        }
        catch (NestableException e) {
            log.error((Object)"Error while updating Table", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    public Boolean getBooleanFromTable(long companyId, Class<?> prortalModel, String columnName, long modelPrimaryKey) throws NestableException {
        Boolean status = false;
        try {
            ExpandoValue expandoValue = ExpandoValueLocalServiceUtil.getValue((long)companyId, (String)prortalModel.getName(), (String)"CUSTOM_FIELDS", (String)columnName, (long)modelPrimaryKey);
            if (expandoValue != null) {
                status = expandoValue.getBoolean();
            }
        }
        catch (PortalException | SystemException e) {
            log.error((Object)"Error while getting data from table", e);
            e.printStackTrace();
            throw e;
        }
        return status;
    }

    public Email.Status getStatusOfEmailAddress(EmailAddress emailAddress) throws Exception {
        Boolean state = false;
        Email.Status status = Email.Status.UNKOWN;
        try {
            state = this.getBooleanFromTable(emailAddress.getCompanyId(), EmailAddress.class, "verifiedAdditionalEmail", emailAddress.getEmailAddressId());
            status = state != false ? Email.Status.ACTIVE : Email.Status.INACTIVE;
        }
        catch (Exception e) {
            log.error((Object)"Error while retriving the status of email address", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        return status;
    }
}

