/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.impl.memory;

import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.GraphConfiguration;
import org.grade.repo.Task;
import org.grade.repo.impl.memory.MemoryEndpoint;

@ApplicationScoped
public class MemoryEndpoints {
    @Produces
    @Qualifiers.Production
    MemoryEndpoint productionEndpoint(@Qualifiers.Production Instance<Resource> resources) {
        return this.stage(new MemoryEndpoint(DatasetFactory.createMem(), "registry"), resources);
    }

    @Produces
    @Qualifiers.Staging
    MemoryEndpoint stagingEndpoint() {
        return new MemoryEndpoint(DatasetFactory.createMem(), "sources");
    }

    @Produces
    @Qualifiers.Staging
    MemoryEndpoint uploadEndpoint(@Qualifiers.Upload Instance<Resource> resources) {
        return this.stage(new MemoryEndpoint(DatasetFactory.createMem(), "upload"), resources);
    }

    @Produces
    @Qualifiers.Tasks
    MemoryEndpoint tasksEndpoint(@Qualifiers.Tasks Instance<Task> tasks) {
        MemoryEndpoint ep = new MemoryEndpoint(DatasetFactory.createMem(), "tasks");
        for (Task task : tasks) {
            GraphConfiguration graph = GraphConfiguration.graph((String)task.graphUri()).label(task.label());
            ep.create(graph, task.resource().getModel());
        }
        return ep;
    }

    private MemoryEndpoint stage(MemoryEndpoint ep, Instance<Resource> resources) {
        for (Resource res : resources) {
            GraphConfiguration graph = GraphConfiguration.graph((String)res.getURI());
            if (res.hasProperty(RDFS.label)) {
                graph.label(res.getProperty(RDFS.label).getString());
            }
            ep.create(graph, res.getModel());
        }
        return ep;
    }
}

