/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.impl;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.grade.configuration.EndpointConfiguration;
import org.grade.configuration.GraphConfiguration;
import org.grade.repo.impl.AbstractEndpoint;

public class DefaultEndpoint
extends AbstractEndpoint {
    @NonNull
    private final EndpointConfiguration cfg;

    @Override
    public QueryExecution executionFor(@NonNull Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query is null");
        }
        return QueryExecutionFactory.sparqlService((String)this.cfg.uri(), (Query)query);
    }

    @Override
    public QueryExecution executionFor(@NonNull Query query, @NonNull List<String> graphs) {
        if (query == null) {
            throw new IllegalArgumentException("query is null");
        }
        if (graphs == null) {
            throw new IllegalArgumentException("graphs is null");
        }
        return QueryExecutionFactory.sparqlService((String)this.cfg.uri(), (Query)query, graphs, null);
    }

    @Override
    public void updateWith(@NonNull UpdateRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        String writeuri = this.cfg.writeUri();
        if (writeuri == null || writeuri.isEmpty()) {
            throw new IllegalStateException("endpoint " + this.configuration().name() + " is not configured to accept write requests");
        }
        UpdateExecutionFactory.createRemote((UpdateRequest)request, (String)writeuri).execute();
    }

    @Override
    public void close() {
    }

    @Override
    public EndpointConfiguration configuration() {
        return this.cfg;
    }

    @ConstructorProperties(value={"cfg"})
    public DefaultEndpoint(@NonNull EndpointConfiguration cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        this.cfg = cfg;
    }

    public EndpointConfiguration writeUri(String uri) {
        return this.cfg.writeUri(uri);
    }

    public boolean canAdd() {
        return this.cfg.canAdd();
    }

    public boolean canDelete() {
        return this.cfg.canDelete();
    }

    public EndpointConfiguration uri(String uri) {
        return this.cfg.uri(uri);
    }

    public String id() {
        return this.cfg.id();
    }

    public String name() {
        return this.cfg.name();
    }

    public String uri() {
        return this.cfg.uri();
    }

    public String writeUri() {
        return this.cfg.writeUri();
    }

    public Set<GraphConfiguration> graphs() {
        return this.cfg.graphs();
    }

    public EndpointConfiguration.Status status() {
        return this.cfg.status();
    }

    public boolean locked() {
        return this.cfg.locked();
    }

    public EndpointConfiguration id(String arg0) {
        return this.cfg.id(arg0);
    }

    public EndpointConfiguration name(String arg0) {
        return this.cfg.name(arg0);
    }

    public EndpointConfiguration graphs(Set<GraphConfiguration> graphs) {
        return this.cfg.graphs(graphs);
    }

    public EndpointConfiguration status(EndpointConfiguration.Status status) {
        return this.cfg.status(status);
    }

    public EndpointConfiguration locked(boolean locked) {
        return this.cfg.locked(locked);
    }
}

